;;; -*- Mode:Common-Lisp; Package:Yes-Way; Base:10; Patch-File: t -*-

(setq *default-mail-server-user-directory* '("F" "RICE"))
(setq *Default-Mailbox-Directory* *default-mail-server-user-directory*)

(setq yw-zwei:*mail-reply-indent-prefix-strings*
      '(">>  " "->  " ">" "--> " "--->" "> ")
)

(setq yw-zwei:*mail-reply-indent-prefix-string-ring*
      (copy-list yw-zwei:*mail-reply-indent-prefix-strings*)
)

(setq *try-to-expose-all-summary-windows-on-mailer-expose* t)
(setq yw-zwei:*address-disposition-notifications-to-suppress* '(:Queued))
(setq yw-zwei:*silent-mail-delivery* :minibuffer)
(setq mail:*use-primary-mail-servers* :always)
(setq yw-zwei:*address-database-path* "x35:rice;address-database.database#1")
(setq *rule-base-path* "x35:rice;rule-base.rule-base#1")
(if nil;(and (not (find-package "SPELLER")) (not (sys:mx-p)))
    (progn (make-system :Spelling-Checker :Noconfirm :Nowarn :Silent)
	   (inside-all-zmacs 
	     (pushnew '((zwei:text-mode) zwei:auto-spell-check-mode)
		      zwei:*initial-minor-modes*
	     )
	   )
    )
    nil
)

(setq yw-zwei:*mail-fonts-attribute-mapping-alist*
      '(
	(fonts:cptfontb  fonts:tr8b)
	(fonts:cptfontcb fonts:tr8b)
	(fonts:cptfontbi fonts:5x5)
	(fonts:cptfonti  fonts:tr8i)
	(fonts:cptfont	 fonts:tvfont)
	(fonts:hl10b	 fonts:tr8b)
	(fonts:hl10	 fonts:hl7)
	(fonts:hl12bi	 fonts:tr8b)
	(fonts:hl12b	 fonts:tr8b)
	(fonts:hl12i	 fonts:tr8i)
	(fonts:hl12	 fonts:hl7)
	(fonts:medfnt	 fonts:tvfont)
	(fonts:metsb	 fonts:tr8b)
	(fonts:metsi	 fonts:tr8i)
	(fonts:mets	 fonts:tvfont)
	(fonts:tr10bi	 fonts:tr8i)
	(fonts:tr10b	 fonts:tr8b)
	(fonts:tr10i	 fonts:tr8i)
	(fonts:tr10	 fonts:tr8)
	(fonts:tr12bi	 fonts:tr8i)
	(fonts:tr12b	 fonts:tr8b)
	(fonts:tr12i	 fonts:tr8i)
	(fonts:tr12	 fonts:tr8)
       )
)
(setq *mouse-l-hold-drag-selection-enabled* t)
(setq fs:*merge-unix-types* t)
;(setq fs:*merge-unix-types* nil)
(setq *indent-text-for-message-replies* t)
(setq *include-source-header-in-reply* nil)
(setq *split-screen-for-message-replies* nil)
(setq mail:*user-mail-address* "James Rice <Rice@SUMEX-AIM.Stanford.Edu>")
(setf (net:get-site-option :Primary-Mail-Servers)
      '("HPP.Stanford.Edu"); "Sumex-Aim.Stanford.Edu")
)
(setq *imap-server-hosts-default-host-first*
      '("HPP" "CAMIS" "Sumex-AIM" "Knife")
)
(setq yw-zwei:*mail-reply-indent-rejustify-right-margin* 59)
(setq *Default-Daemon-Actions*
	'((:Get-Unseen-Bodies :all)
	  (:Get-Selected-Bodies)
	  (:Get-Nearby-Bodies 3)
	  (:Get-Nearby-Bodies 3 :backwards)
	  (:Get-Headers 100 :Backwards)
	  (:Get-Recent-Bodies)
	  (:bodies-present)
	  (:Get-And-Cache-Directory-For-Completion)
	 )
)
(setq zwei:*default-bcc-string*
      "Outgoing Mail <Rice-Msgs@SUMEX-AIM.Stanford.Edu>"
)
(setq yw-zwei:*always-use-deduced-prefices* t)
(setq *bboard-search-list* '("COMMON-LISP" "COMMONLOOPS" "SU-JOBS" "SU-ETC"))
(setq *netnews-search-list* '("clari.news.gov.state" "clari.news.gov.corrupt"))
(setq *bboard-filter-alist* '(("SU-ETC" uncrispin)))
(deffilter uncrispin
	   (:Printed-Representation "UnCrispin"
	    :Documentation "All messages not from Crispin"
	   )
  (and (recent) (not (from crispin)))
)

(deffilter unseen-to-me (:printed-representation "Personal Unread Mail")
  ;(and (Unseen) (or (to Rice) (cc Rice)))
  "Unseen and (to rice or cc rice)"
)

(deffilter unseen-to-lists (:printed-representation "Group Unread Mail")
  (and (Unseen) (not (or (to Rice) (cc Rice))))
)
(deffilter already-read-mail (:printed-representation "Seen Mail")
  (and (undeleted) (and (unflagged) (seen)))
)

(deffilter marked-mail (:printed-representation "Flagged Mail")
  (and (flagged) (undeleted)))

(setq *summary-windows-to-create-for-mailbox-alist*
     `(("Inbox" ((marked-mail)) ((already-read-mail))))
)
(setq *summary-windows-to-create-for-mailbox-alist*
     `(("Inbox" ((marked-mail))))
)
(setq *summary-windows-to-create-for-mailbox-alist*
     `(("Inbox" ((unseen-to-me)) ((unseen-to-lists))))
)
(setq *summary-windows-to-create-for-mailbox-alist*
     `(("Inbox" ((unseen-to-me)) ((unseen-to-lists)) ((already-read-mail))))
)
(setq *summary-windows-to-create-for-mailbox-alist* nil)

(deffilter special
	   (:Printed-Representation "Special"
	    :Documentation "All messages not from Rice"
	    :Applicable-If
	      #'(lambda (name ignore) (search "LOTUS" name :Test #'char-equal))
	   )
  (not (from Rice))
)
(deffilter magic ()
  (then (and (unseen) (reverse (and (not (deleted)) (to rice))))
	(and (unseen) (and (not (deleted)) (cc rice)))
  )
)
(defun user-find-zmacs-frame ()
  (declare (special *primary-zmacs-frame*))
  (if (boundp '*primary-zmacs-frame*)
      *primary-zmacs-frame*
      (progn (if (not (and (boundp 'Zwei::*All-Zmacs-Windows*)
			   Zwei::*All-Zmacs-Windows*
		      )
		 )
		 (zwei:find-or-create-idle-zmacs-window)
		 nil
	     )
	     (Send (First Zwei::*All-Zmacs-Windows*) :Superior)
      )
  )
)
(setq yw:*basic-header-types-to-filter*
      '(:Received :Return-Path :message-id :Full-Name :Character-Type-Mappings
	:In-Reply-To :Fonts :Posted-Date :Content-Type
	:Content-Transfer-Encoding :X-Fonts
       )
)
(setq yw:*address-header-types-to-filter* '(:Bcc :Sender))
(setq yw:*yw-daemon-sleep-interval* (For-Processor-Type 40 10 20))
(setq *new-headers-window-x-offset* 0)
(setq *new-headers-window-y-offset* -15)
(setq zwei:*unsent-message-query-p* nil)
(setq mail:*try-mail-now-p* nil)
(setq zwei:*reformat-headers-include-list*
      '(:date :from :reply-to :to :cc :subject))
(setq zwei:*reformat-headers-body-goal-column* 9)
(setq zwei:*mail-template-header-body-goal-column* 9)
;(setq zwei:*choose-from-all-mail-keywords-p* t)
(setq zwei::*dont-reply-to*
      '("Rice@Sumex-Aim.Stanford.Edu" "Rice@Camis.Stanford.Edu"
	"Rice@HPP.Stanford.Edu" "Rice@KSL.Stanford.Edu")
)
(setq *message-header-flags-format-string* "~vA80")
(setq *message-header-length-format-string* "(~@vA)270")
(setq *message-header-from-format-string* "~vA220")
(defmethod yw-header-display-spec
       ((type (eql :from))
        value message-number cache-entry message-flags message-date
	message-from message-to message-subject message-length-in-chars day
	month year date-mode-args
       )
  (ignore message-number cache-entry message-flags message-date message-subject
	  message-length-in-chars day month year date-mode-args message-to
  )
  (let ((me-p (or (search "Rice@Sumex" message-from :Test #'char-equal)
		  (search "Rice@HPP" message-from :Test #'char-equal)
		  (search "Rice@Camis" message-from :Test #'char-equal)
		  (search "James Rice" message-from :Test #'char-equal)
	      )
	)
       )
       (maybe-max-width (if me-p
			    "-> ~vA220" 
			    *message-header-from-format-string*
			)
			value (if me-p message-to message-from)
       )
  )
)

(setq yw:*message-header-display-specification*
     '(:Content-Type 3
       :Number 3
       :Space nil
       :Flags (4 nil :Font 2)
       :date :Date-Or-Time
       :from (15 15)
       :length (4 nil :Font 2)
       :Space nil
       :keywords (0 10 :Font 1)
       :Space nil
       :subject 0
      )
)
(defmacro-command interesting (:Keys (#\M-I))
  "Head from lakin
   Read >
  "
)
(setq *user-summary-window-inits* '(:scroll-bar-side :right))
(setq *user-mailbox-selector-inits* '(:scroll-bar-side :right))
(setq *user-system-output-window-inits* '(:scroll-bar-side :right))


;===============================================================================

;;; Gruberian filters.

(deffilter already-read-mail (:printed-representation "Seen Mail")
  (and (undeleted) (and (unflagged) (seen))))

(deffilter marked-mail (:printed-representation "Flagged Mail")
  (and (flagged) (undeleted)))

(deffilter unseen-mail (:printed-representation "Unread Mail")
  (unseen))

(deffilter unseen-to-me (:printed-representation "Personal Unread Mail")
  (and (unseen) (or (to Rice) (cc Rice))))

(deffilter unseen-to-lists (:printed-representation "Group Unread Mail")
  (and (unseen) (not (or (to Rice) (cc Rice)))))

(defun configure-windows ()
  (setf yw:*mail-control-window-height* 200)
  (let* ((target-window-width 550)
         (min-left-edge 550)
         (max-right (send tv:main-screen :width))
         (left-edge (max min-left-edge (- max-right target-window-width)))
         (right-edge (min max-right (+ left-edge target-window-width)))
         (all-windows-width (- right-edge left-edge))
         (max-bottom (send tv:main-screen :height))
         (top-of-control-window (- max-bottom yw:*mail-control-window-height*))
         (vertical-space top-of-control-window)
         (top-of-screen 0)
         (window-1-height (floor (* .4 vertical-space)))
         (window-2-height (floor (* .2 vertical-space)))
         (window-3-height (floor (* .2 vertical-space)))
         (window-4-height (floor (* .2 vertical-space)))
         (window-1-top top-of-screen)
         (window-2-top (+ window-1-top window-1-height))
         (window-3-top (+ window-2-top window-2-height))
         (window-4-top (+ window-3-top window-3-height))
         (window-1-edges `(,left-edge ,window-1-top ,right-edge ,window-1-height))
         (window-2-edges `(,left-edge ,window-2-top ,right-edge ,(+ window-2-top window-2-height)))
         (window-3-edges `(,left-edge ,window-3-top ,right-edge ,(+ window-3-top window-3-height)))
         (window-4-edges `(,left-edge ,window-4-top ,right-edge ,(+ window-4-top window-4-height)))
         )
    (setf yw:*message-window-width* all-windows-width)
    (setf yw:*message-window-height* 200 #+OLD (- window-1-height 20)) ;make it shorter
    (setf yw:*default-ideal-message-display-pane-position* `(,(- left-edge 15) ,top-of-screen))
    (setf yw:*new-headers-window-y-offset* 15)
    (setf yw:*new-headers-window-x-offset* -15)
    (setf yw:*default-ideal-mail-control-window-position* `(,left-edge ,(+ window-4-top window-4-height)))
    (setf yw:*mail-control-window-width* all-windows-width)
    (setf yw:*summary-windows-to-create-for-mailbox-alist*
          `(("INBOX"
             (nil :no-window)
             ((unseen-to-me)
              :edges (:values ,window-4-edges)
              :user-defined-position-p  t)
             ((unseen-to-lists)
              :edges (:values ,window-3-edges)
              :user-defined-position-p  t)
             ((marked-mail)
              :edges (:values ,window-2-edges)
              :user-defined-position-p t)
             ((already-read-mail)
              :edges (:values ,window-1-edges)
              :user-defined-position-p t)
             )))
    ))


;(configure-windows)