;;; -*- Mode:Common-Lisp; Package:SYSTEM; Base:10 -*-



(defmacro ticl:With-Metering
	  ((file &key
		 (predicate t)
		 (without-interrupts-p nil)
		 (functions 4096)
		 (notify-p t)
	   )
	   (&key (sort nil) (brief nil) (verbose t))
	   &body body)
"Executes body maybe withg metering switched on.
  File is the output file for the metering report.
  Predicate is a predicate to determine whether to switch on metering.
  When without-interrupts-p is true then the metering runs without interrupts.
  Functions is the size of the metering function hash table.  This table will
    not grow if it uverflows, so this value should be large enough to exceed
    the number of unique functions that will be called during metering.
  When Notify-p is true it tells you when you are entering the metered segment.
  Sort, Brief and Verbose  are the keyword args to pass to sys:submeter-report.
"
  `(if ,predicate
       (let ((completed-ok-p nil))
	    (unwind-protect
		(progn (sys:submeter-initialize
			 :Items (list sys:current-process)
			 :Functions ,functions
		       )
		       (if ,notify-p
			   (format t "~&!! Entering metered segment.")
			   nil
		       )
		       (sys:submeter-enable)
		       (if ,without-interrupts-p
			   (without-interrupts
			     (multiple-value-prog1
			       (progn ,@body)
			       (setq completed-ok-p t)
			     )
			   )
			   (multiple-value-prog1
			     (progn ,@body)
			     (setq completed-ok-p t)
			   )
		       )
		)
	      (sys:submeter-disable)
	      (if ,notify-p
		  (format t "~&!! Finished metered segment.")
		  nil
	      )
	      (if (or completed-ok-p
		      (y-or-n-p "Metered segment terminated abnormally.  ~
				Generate a report anyway?"
		      )
		  )
		  (with-open-file (*standard-output* ,file :Direction :Output)
		    (sys:submeter-report
		      :Sort ,sort :Verbose ,verbose :Brief ,brief
		    )
		  )
		  nil
	      )
	    )
       )
       (progn ,@body)
   )
)

(export 'ticl:With-Metering 'ticl)