;;; -*- Mode:Common-Lisp; Package:USER; Base:10 -*-

;;; **********************************************************************
;;; Copyright (c) 1990 Stanford University.
;;; Copyright is held by Stanford University except where code has been
;;; modified from TI source code.  In these cases TI code is marked with
;;; a suitable comment.  Where functionality implemented herein replicates
;;; similarly named functionality on Symbolics machines, this code was
;;; developed solely from the interface specification in the documentation
;;; or through guesswork, never by examination of Symbolics source code.

;;; All Stanford Copyright code is in the public domain.  This code may be
;;; distributed and used without restriction as long as this copyright
;;; notice is included and no fee is charged.  This can be thought of as
;;; being equivalent to the Free Software Foundation's Copyleft policy.

;;; TI source code may only be distributed to users who hold valid TI
;;; software licenses.
;;; **********************************************************************

(load-tools '(:Window-System-Additions :Utilities))

(defsystem grapher
  (:output-version :newest)
  (:Pathname-Default "Grapher:Grapher;")
  (:module scroll-window "BASIC-X-Y-SCROLLING-WINDOW")
  (:module macros "MACROS-FOR-ESSENTIAL-GRAPH-MIXIN")
  (:module grapher "GRAPH-WINDOW")
  (:module rendering "RENDERING")
  (:module functional-interface "FUNCTIONAL-INTERFACE")
  (:module graph-calls (("GRAPH-CALLS") ("GRAPH-CALLERS")))
  (:compile-load macros)
  (:compile-load-init scroll-window (macros) (:Fasload macros))
  (:compile-load-init rendering (macros) (:fasload scroll-window macros))
  (:compile-load-init grapher (macros)
		      (:fasload scroll-window macros rendering)
  )
  (:compile-load-init functional-interface (macros)
		      (:fasload macros scroll-window grapher)
  )
  (:compile-load-init graph-calls (macros)
		      (:fasload macros scroll-window grapher)
  )
)
