;;; -*- Mode: Common-Lisp; Package: User; Base: 10.; Patch-File: T -*-
;;; Written 13-Aug-91 10:06:30 by acuff,
;;; Reason: SPR 174: Get DST time offset right for Mac files on mX (RPC patch 6.4 from TI).
;;; while running on KSL-Mac-62 from band KSL1
;;; With SYSTEM 6.41, GC 6.7, VIRTUAL-MEMORY 6.3, MICRONET 6.0, MICRONET-COMM 6.4,
;;;  DISK-IO 6.4, DISK-LABEL 6.1, BASIC-PATHNAME 6.5, MAC-PATHNAME 6.0, NETWORK-SUPPORT-COLD 6.2,
;;;  BASIC-NAMESPACE 6.8, BASIC-FILE 6.15, RPC 6.2, NFS-MX 6.9, EH 6.8, MAKE-SYSTEM 6.5,
;;;  MEMORY-AUX 6.0, COMPILER 6.18, TV 6.32, NVRAM 6.4, UCL 6.1, INPUT-EDITOR 6.1,
;;;  MACTOOLBOX 2.25, METER 6.2, ZWEI 6.28, DEBUG-TOOLS 6.5, WINDOW-MX 6.12, PRINTER 6.8,
;;;  MAC-PRINTER-TYPES 6.2, CLIPBOARD 6.1, TI-CLOS 6.53, CLEH 6.5, NETWORK-PATHNAME 6.2,
;;;  NETWORK-NAMESPACE 6.1, DATALINK 6.0, CHAOSNET 6.9, NETWORK-SUPPORT 6.1, NETWORK-SERVICE 6.3,
;;;  DATALINK-DISPLAYS 6.0, MX-DATALINK 6.1, NAMESPACE-EDITOR 6.7, IP 3.65, NFS-MX-SERVER 6.0,
;;;  MX-SERIAL 6.2, PRINTER-TYPES 6.2, IMAGEN 6.1, MAIL-DAEMON 6.6, MAIL-READER 6.9,
;;;  TELNET 6.1, VT100 6.0, STREAMER-TAPE 6.6, DECNET 1.72, VISIDOC 6.7, PROFILE 6.3,
;;;  Experimental KSL-PATCHES 10.8,  microcode 195, Band Name: 6.1(41), KSL9 10.6,
;;;  16-Apr

#!C
; From file PATCHES-9.LISP#> SYS-PATCHES; KSL-EXP-7:
#10R USER#:
(lisp:COMPILER-LET ((*PACKAGE* (FIND-PACKAGE "USER"))
                          (SI:*LISP-MODE* :COMMON-LISP)
                          (*READTABLE* SYS:COMMON-LISP-READTABLE)
                          (SI:*READER-SYMBOL-SUBSTITUTIONS* SYS::*COMMON-LISP-SYMBOL-SUBSTITUTIONS*))
  (COMPILER#:PATCH-SOURCE-FILE "KSLx: SYS-PATCHES; PATCHES-9.#"


;; RPC patch 6.4 (unreleased as of 08/12/91)
;;;
;;; -*- Mode: Common-Lisp; Package: User; Base: 10.; Patch-File: T -*-
;;; Written 08/12/91 11:23:09 by MARKY,
;;; Reason: Correct unix-lisp-ut and lisp-unix-up functions for timezones OTHER THAN "CST".
;;; while running on MX64 from band N928
;;; With SYSTEM 6.49, GC 6.10, VIRTUAL-MEMORY 6.3, MICRONET 6.0, MICRONET-COMM 6.4,
;;;  DISK-IO 6.5, DISK-LABEL 6.1, BASIC-PATHNAME 6.7, MAC-PATHNAME 6.0, NETWORK-SUPPORT-COLD 6.3,
;;;  BASIC-NAMESPACE 6.8, BASIC-FILE 6.15, RPC 6.3, NFS-MX 6.10, EH 6.8, MAKE-SYSTEM 6.5,
;;;  MEMORY-AUX 6.0, COMPILER 6.20, TV 6.37, NVRAM 6.5, UCL 6.1, INPUT-EDITOR 6.1,
;;;  MACTOOLBOX 2.32, METER 6.2, ZWEI 6.31, DEBUG-TOOLS 6.5, WINDOW-MX 6.17, PRINTER 6.9,
;;;  MAC-PRINTER-TYPES 6.3, CLIPBOARD 6.1, TI-CLOS 6.54, CLEH 6.5, NETWORK-PATHNAME 6.2,
;;;  NETWORK-NAMESPACE 6.1, DATALINK 6.0, CHAOSNET 6.9, NETWORK-SUPPORT 6.1, NETWORK-SERVICE 6.3,
;;;  DATALINK-DISPLAYS 6.0, MX-DATALINK 6.1, NAMESPACE-EDITOR 6.7, IP 3.67, NFS-MX-SERVER 6.0,
;;;  MX-SERIAL 6.2, PRINTER-TYPES 6.2, IMAGEN 6.1, MAIL-DAEMON 6.6, MAIL-READER 6.9,
;;;  TELNET 6.1, VT100 6.0, STREAMER-TAPE 6.8, DECNET 1.72, VISIDOC 6.7, PROFILE 6.3,
;;;   microcode 195, Band Name: microExplorer Network (9/28)

;;; SPR 22879. Fix lisp-unix-ut and unix-lisp-ut for timezones OTHER THAN "cst"

#!C
; From file MX-TIME-SKEW.LISP HD:NAGASE:MISC: MX64:
#10R REMOTE-PROCEDURE-CALL#:
(lisp:COMPILER-LET ((*PACKAGE* (FIND-PACKAGE "REMOTE-PROCEDURE-CALL"))
                          (SI:*LISP-MODE* :COMMON-LISP)
                          (*READTABLE* SYS:COMMON-LISP-READTABLE)
                          (SI:*READER-SYMBOL-SUBSTITUTIONS* SYS::*COMMON-LISP-SYMBOL-SUBSTITUTIONS*))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: NAGASE.MISC; MX-TIME-SKEW.#"


;;(DEFCONSTANT 0000GMT-1JAN04 (encode-universal-time 0 0 6 1 1 1904 0))
;;(DEFCONSTANT 0000GMT-1JAN04DST (encode-universal-time 0 0 5 1 1 1904 0))
(eval-when (compile load eval)
  (DEFparameter 0000GMT-1JAN04 (encode-universal-time 0 0 time:*timezone* 1 1 1904 0))
  (DEFparameter 0000GMT-1JAN04DST (encode-universal-time 0 0 (1- time:*timezone*) 1 1 1904 0))
  )

))

;; Must recompile functions below since former defconstants 0000GMT-1JAN04DST and 0000GMT-1JAN04 are imbedded in functions as numbers
#!C
; From file MX-TIME-SKEW.LISP HD:NAGASE:MISC: MX64:
#10R REMOTE-PROCEDURE-CALL#:
(lisp:COMPILER-LET ((*PACKAGE* (FIND-PACKAGE "REMOTE-PROCEDURE-CALL"))
                          (SI:*LISP-MODE* :COMMON-LISP)
                          (*READTABLE* SYS:COMMON-LISP-READTABLE)
                          (SI:*READER-SYMBOL-SUBSTITUTIONS* SYS::*COMMON-LISP-SYMBOL-SUBSTITUTIONS*))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: NAGASE.MISC; MX-TIME-SKEW.#"


;; may 08/12/91 Added
(defvar *old-timezone* time:*timezone* "Snapshot of time:*timezone* to use to also change 0000GMT-1JAN04DST")

;; may 08/12/91 Added
(defun update-timezone ()
  "Insure changes to time:*timezone* are also reflected in 0000GMT-1JAN04DST and 0000GMT-1JAN04"
  (unless (= *old-timezone* time:*timezone*)
    (setq 0000GMT-1JAN04 (encode-universal-time 0 0 time:*timezone* 1 1 1904 0))
    (setq 0000GMT-1JAN04DST (encode-universal-time 0 0 (1- time:*timezone*) 1 1 1904 0))
    (setq *old-timezone* time:*timezone*)))

;; may 08/12/91 Added
(eval-when (load eval)
  (update-timezone))

(DEFUN LISP-UNIX-UT (lisp-universal-time)
   "Convert LISP-UNIVERSAL-TIME (seconds since 0000GMT 1 January 1900) into
UNIX-style universal time (seconds since 0000GMT 1 January 1970)."
   (declare (values unix-universal-time))
   (when (si:addin-p)
     (update-timezone))	;; may 08/12/91 Added
   (let ((ut
	   (- lisp-universal-time
	      (COND ((si:addin-p) RPC:0000GMT-1JAN04)
		    (t RPC:0000GMT-1JAN70)))))
     (if (and (si:addin-p) (time:ut-daylight-savings-p lisp-universal-time)) ; DAB  05-01-89 Then check if it needs readjusting.
	 (- lisp-universal-time
	    0000GMT-1JAN04DST)			       ; DAB 04-18-89
	 UT)
      ))

(DEFUN UNIX-LISP-UT (unix-universal-time &optional (read-host si:local-host))
   "Convert UNIX-UNIVERSAL-TIME (seconds since 0000GMT 1 January 1970) into
Lisp universal time (seconds since 0000GMT 1 January 1900)."
   (declare (values lisp-universal-time))
   (when (si:addin-p)
     (update-timezone))	;; may 08/12/91 Added
   (let ((UT (+ unix-universal-time    ; DAB 04-18-89 First build the time without daylight savings.
		(IF (mac-host-p read-host)
		    0000GMT-1JAN04 
		    0000GMT-1JAN70))))
     (if (and (mac-host-p read-host) (time:ut-daylight-savings-p  UT)) ; DAB 04-18-89 Then check if it needs readjusting.
	      (+ unix-universal-time
		 0000GMT-1JAN04DST) ; DAB 04-18-89
	      UT))
   )

))

))
