;;; -*- Mode: Common-Lisp; Package: User; Base: 10.; Patch-File: T -*-
;;; Written 11-Jan-91 02:07:30 by acuff,
;;; Reason: SPR 168: Call STREAM-INTO-BP correctly from COM-INSERT-FILE.
;;; while running on KSL-Mac-62 from band KSL9
;;; With SYSTEM 6.41, GC 6.7, VIRTUAL-MEMORY 6.3, MICRONET 6.0, MICRONET-COMM 6.4,
;;;  DISK-IO 6.4, DISK-LABEL 6.1, BASIC-PATHNAME 6.5, MAC-PATHNAME 6.0, NETWORK-SUPPORT-COLD 6.2,
;;;  BASIC-NAMESPACE 6.8, BASIC-FILE 6.15, RPC 6.2, NFS-MX 6.9, EH 6.8, MAKE-SYSTEM 6.5,
;;;  MEMORY-AUX 6.0, COMPILER 6.18, TV 6.32, NVRAM 6.4, UCL 6.1, INPUT-EDITOR 6.1,
;;;  MACTOOLBOX 2.25, METER 6.2, ZWEI 6.28, DEBUG-TOOLS 6.5, WINDOW-MX 6.12, PRINTER 6.8,
;;;  MAC-PRINTER-TYPES 6.2, CLIPBOARD 6.1, TI-CLOS 6.53, CLEH 6.5, NETWORK-PATHNAME 6.2,
;;;  NETWORK-NAMESPACE 6.1, DATALINK 6.0, CHAOSNET 6.9, NETWORK-SUPPORT 6.1, NETWORK-SERVICE 6.3,
;;;  DATALINK-DISPLAYS 6.0, MX-DATALINK 6.1, NAMESPACE-EDITOR 6.7, IP 3.65, NFS-MX-SERVER 6.0,
;;;  MX-SERIAL 6.2, PRINTER-TYPES 6.2, IMAGEN 6.1, MAIL-DAEMON 6.6, MAIL-READER 6.9,
;;;  TELNET 6.1, VT100 6.0, STREAMER-TAPE 6.6, DECNET 1.72, VISIDOC 6.7, PROFILE 6.3,
;;;  Experimental KSL-PATCHES 10.0,  microcode 195, Band Name: 6.1(41), KSL9 10.0,
;;;  16-Nov

#!C
; From file PATCHES-9.LISP#> SYS-PATCHES; KSL-EXP-7:
#10R USER#:
(lisp:COMPILER-LET ((*PACKAGE* (FIND-PACKAGE "USER"))
                          (SI:*LISP-MODE* :COMMON-LISP)
                          (*READTABLE* SYS:COMMON-LISP-READTABLE)
                          (SI:*READER-SYMBOL-SUBSTITUTIONS* SYS::*COMMON-LISP-SYMBOL-SUBSTITUTIONS*))
  (COMPILER#:PATCH-SOURCE-FILE "kslx:sys-patches; PATCHES-9.#"


zwei:
(DEFCOM COM-INSERT-FILE "Insert the contents of the specified file at point.
Reads a file name from the mini-buffer, and inserts the contents of that
file at point. Leaves mark at the end of inserted text, and point at the 
beginning, unless given an argument.  Acts like Yank (Control-Y) with respect
to the region." ()
  (POINT-PDL-PUSH (POINT) *WINDOW* NIL NIL)
  (MOVE-BP (MARK) (POINT))
  (SETQ *CURRENT-COMMAND-TYPE* :YANK)
  (LET ((PATHNAME (READ-DEFAULTED-AUX-PATHNAME "Insert file:")))
    (WITH-OPEN-FILE (STREAM PATHNAME :ERROR :RETRY)
      (LET* ((ATTRIBUTES (FS:EXTRACT-ATTRIBUTE-LIST STREAM))
	     (FONTS (GETF ATTRIBUTES :FONTS))
	     (START-POINT (COPY-BP (POINT))))
	(WITH-UNDO-SAVE ("Insert file" (POINT) (POINT) T)
	  (DBP START-POINT)
	  (MOVE-BP (POINT) (STREAM-INTO-BP STREAM
					   (POINT)

					   ;; pass T instead of a list
					   ;; FritzM. 1/10/91
					   (WHEN (OR (CDR FONTS)
						     (GETF ATTRIBUTES :DIAGRAM))
					     T)))

	  (IBP START-POINT)
	  (DOLIST (BP (LINE-BP-LIST (BP-LINE (POINT))))
	    (WHEN (AND (BP-= (POINT) BP)
		       (NEQ BP (POINT))
		       (EQ (BP-STATUS BP) :NORMAL))
	      (MOVE-BP BP START-POINT)))
	  (FIXUP-FONTS-INTERVAL FONTS START-POINT (POINT)))))
    (MAYBE-DISPLAY-DIRECTORY :READ PATHNAME))
  (OR *NUMERIC-ARG-P*
      (SWAP-BPS (POINT) (MARK)))
  DIS-TEXT)
))
