;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:ZWEI; Vsp:0; Fonts:(CPTFONT HL12 TR12I COURIER CPTFONTB HL12B CPTFONTBI) -*-

;1;; File "3ZMACS-UNKNOWN-FONTS-PATCH*".*
;1;; Makes Zmacs not dive into the debugger when visiting a file whose 5Fonts:* field contains unknown fonts.*
;1;;*
;1;; 5ChangeLog:**
;1;;*
;1;;    5 Dec 89*	1Jamie Zawinski*	1Created.*
;1;;*


;1;; Originally defined in 5Sys: Zmacs; Font.Lisp#>**
;1;; Added optional 5nobarf* argument.*
;1;;*
(DEFUN SET-BUFFER-FONTS (BUFFER &OPTIONAL (FONTS (SEND BUFFER :GET-ATTRIBUTE :FONTS)) (nobarf t))
  "Set the fonts of BUFFER according to its attribute list.
We assume that the buffer's attribute list has been read in and stored.
2If NOBARF is non-NIL, then a warning will be printed when we encounter an unknown font.*"
  (COND ((AND FONTS (SYMBOLP FONTS))
	 (SETQ FONTS (INTERN (SYMBOL-NAME FONTS) "FONTS"))
	 (SETQ FONTS (AND (BOUNDP FONTS) (LIST (CONS (SYMBOL-NAME FONTS) (SYMBOL-VALUE FONTS))))))
	(T
	 (DO ((FL FONTS (CDR FL))
	      (L NIL)
	      (F))
	     ((NULL FL)
	      (SETQ FONTS (NREVERSE L)))
	   (SETQ F (INTERN (SYMBOL-NAME (CAR FL)) "FONTS"))
	   (COND ((NOT (BOUNDP F))
		  ;1; 5jwz: added condition trapping.**
		  (condition-call-if nobarf (c)
		      (send (send (send *window* :superior) :superior) :parse-font-descriptor f)
		    ((errorp c)
		     (warn "3~A.  Using ~A instead.*"
			   (send c :report-string)
			   (W:FONT-NAME (W:SCREEN-DEFAULT-FONT W:DEFAULT-SCREEN))
			   )))
		  (OR (BOUNDP F)
		      ;;If font not loaded, substitute default to keep font numbers ok
		      (SETQ F (W:FONT-NAME (W:SCREEN-DEFAULT-FONT W:DEFAULT-SCREEN))))))
	   (PUSH (CONS (SYMBOL-NAME F) (SYMBOL-VALUE F)) L))))
  (SEND BUFFER :SET-SAVED-FONT-ALIST FONTS)
  FONTS)
