;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:ZWEI; Vsp:0; Fonts:(CPTFONT HL12 TR12I COURIER ADOBE-COURIER14B HL12B CPTFONTBI) -*-

;1;; File "4UNIX-MANUAL*".*
;1;; Runs the 5man* program on a Unix host, and pretty-prints the output into a Zmacs buffer.*
;1;; Requires Eric Karlson's 5rexec* code, or any other code that does the same thing.*
;1;; Copyright (c) 1989 University of California, Berkeley.*
;1;;*
;1;; 5ChangeLog:**
;1;;*
;1;;   14 Feb 90*	1Jamie Zawinski*	1Created.*
;1;;*

(defvar 4*unix-manual-host* *"3Teak*"
  "2The Unix host to contact for the manual pages.*")

(defvar 4*unix-manual-fonts* *'(FONTS:CPTFONT FONTS:CPTFONTI FONTS:HL12B)
  "2The fonts to use when displaying the manual pages into a buffer.
  The first is for normal text, the second is for underlined text, and the third is for section headings.*")


(defun 4manual-entry *(topic &optional (output-stream *standard-output*) hack-fonts-p)
  (if (not hack-fonts-p)
      (net:rexec *unix-manual-host* (format nil "3man - ~A*" topic)
		 :stdout output-stream :stderr sys:*null-stream*)
      (let* ((string (with-output-to-string (stream)
		       (net:rexec *unix-manual-host* (format nil "3man - ~A*" topic)
				  :stdout stream :stderr sys:*null-stream*)))
	     (L (length string))
	     (standout-p nil))
	(do* ((i 2 (1+ i)))
	     ((>= i L)
	      (write-char (char string (- L 2)) output-stream)
	      (write-char (char string (- L 1)) output-stream))
	  (let* ((c (char string i))
		 (c-1 (char string (- i 1)))
		 (c-2 (char string (- i 2))))
	    (cond ((and (char= c-2 #\_)
			(char= c-1 #\Backspace))
		   (unless (eq standout-p :underline)
		     (setq standout-p :underline)
		     (write-char #\Epsilon output-stream)
		     (write-char #\1 output-stream))
		   (write-char c output-stream)
		   (incf i 2))

		  ((char= c-2 #\Newline)
		   (when standout-p
		     (setq standout-p nil)
		     (write-char #\Epsilon output-stream)
		     (write-char #\* output-stream))
		   (write-char c-2 output-stream)
		   (when (alphanumericp c-1)
		     (setq standout-p :heading)
		     (write-char #\Epsilon output-stream)
		     (write-char #\2 output-stream)))
		  (t
		   (when (eq standout-p :underline)
		     (setq standout-p nil)
		     (write-char #\Epsilon output-stream)
		     (write-char #\* output-stream))
		   (write-char c-2 output-stream)
		   )))))
      ))


(defcom 4com-manual-entry *"2Document something from the Unix manual.*" ()
  (let* ((buffer (find-buffer-named "3*Manual Entry**" t))
	 (topic (prompt-and-read :string-trim "3Unix Manual Topic: *")))
    (make-buffer-not-read-only buffer)
    (delete-interval buffer)
    (send buffer :set-saved-major-mode 'text-mode)
    (send buffer :set-attribute :fonts *unix-manual-fonts*)
    (send buffer :set-attribute :backspace t)
    (set-buffer-fonts buffer)
    (manual-entry topic (interval-stream buffer nil nil t) t)
    (make-buffer-read-only buffer)
    (make-buffer-current buffer))
  DIS-TEXT)

(set-comtab *zmacs-comtab* () (make-command-alist '(com-manual-entry)))
