;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:TV; Vsp:0; Fonts:(CPTFONT HL12 TR12I COURIER ADOBE-COURIER14B HL12B CPTFONTBI); Patch-File:T -*-

;1;; File "3TERM-N-FIX*".*
;1;; Makes 5Terminal-N* place the newly-shown notifications on 5tv:notification-history* so that they can be looked at again later*
;1;; with 5Terminal-1-N* or with 5#'tv:print-notifications*.*
;1;;*
;1;; 5ChangeLog:**
;1;;*
;1;;    2 Oct 89*	1Jamie Zawinski*	1Created.*
;1;;*

(DEFUN kbd-terminal-notifications (ARG &aux nn tem)	 ;1TERM N*
  "2Display notifications in a pop-up window.
With no argument, pending notifications only are printed. If there are none, we say so.
With an argument of T, pending notifications only are printed.
  If there are none, we return immediately.
With an argument of 1, displays all notifications.
With an argument of 2, prints nothing, but marks pending
 notifications as no longer pending.*"
  ;1;do this before selecting new window -- don't get screwed by the wait-to-notify process*
  (WITHOUT-INTERRUPTS
   (SETQ nn (APPEND pending-notifications deferred-notifications)
	 deferred-notifications NIL
	 pending-notifications NIL))
  (IF (CASE arg
	((nil) t)
	((t) nn)
	(1 t)
	(2 (SETQ deferred-notifications nn) nil))
      (unwind-protect	;1 jwz, added.*
      (USING-RESOURCE (window pop-up-finger-window)
	(SETF (sheet-truncate-line-out-flag window) 0)
	(SEND window :set-label "Notifications -- most recent first")
	(window-call (window :deactivate)
	  (SETQ kbd-terminal-time NIL)
	  ;1;crock to let us catch more notifications while this window is exposed*
	  (DO () (nil)
	    (WITHOUT-INTERRUPTS
	      (SETQ nn (APPEND pending-notifications nn)
		    pending-notifications NIL))
	    (SEND window :clear-screen)
	    (FORMAT window "~:[[There are no pending notifications]~;New notifications:~]~%"
		    nn)
	    (SETQ tem notification-history)
	    (IF nn
		(DOLIST (n nn)
		  (time:print-brief-universal-time (FIRST n) window)
		  (FORMAT window ": ~a~&" (SECOND n))
		  (POP tem)))			;1don't duplicate messages -- unseen messages are also in tem*
	    (WHEN arg
	      (FORMAT window "~%~:[[No Notifications]~;Previous notifications:~]~%" tem)
	      (DOLIST (n tem)
		(time:print-brief-universal-time (FIRST n) window)
		(FORMAT window ": ~a~&" (SECOND n))))
	    (FORMAT window "~%~a" *remove-typeout-standard-message*)
	    (PROCESS-WAIT *DEFAULT-READ-WHOSTATE*
			  #'(lambda (window)
			      (OR pending-notifications
				  (NEQ selected-window window)
				  (SEND window :listen)))
			  window)
	    (OR pending-notifications
		(NEQ selected-window window)
		(SEND window :tyi-no-hang))
	    (OR pending-notifications
		(RETURN t)))))
	;1; jwz: Added to remember the just-shown notifications for 5#'print-notifications*.*
	(without-interrupts
	  (setq notification-history (append nn notification-history)))
	)))
