;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:TV; Vsp:0; Fonts:(CPTFONT HL12 TR12I COURIER CPTFONTB HL12B CPTFONTBI) -*-

;1;; File "3SPLINE-SCREENHACK*".*
;1;; Bounces a spline around the screen.  For use as a screensaver.*
;1;;*
;1;; 5ChangeLog:**
;1;;*
;1;;   29 Dec 88*	1Jamie Zawinski*	1Created.*
;1;;*

(defun 4draw-curve* (sheet px py npoints &optional closed (alu TV:ALU-TRANSP))
  "2PX and PY are one dimensional arrays of X and Y points.  Lines are drawn between these points on SHEET.*"
  (let* ((maxx (tv:sheet-inside-width sheet))
	 (maxy (tv:sheet-inside-height sheet))
	 (x0 nil)
	 (x1 (floor (aref px 0)))
	 (y0 nil)
	 (y1 (floor (aref py 0))))
    (do* ((i 1 (1+ i)))
	 ((>= i npoints))
      (setq x0 x1)
      (setq y0 y1)
      (setq x1 (floor (min maxx (max 0 (aref px i)))))
      (setq y1 (floor (min maxy (max 0 (aref py i)))))
      (tv:prepare-sheet (sheet)
	(sys:%draw-line x0 y0 x1 y1 alu nil sheet)))
    (when closed
      (tv:prepare-sheet (sheet)
	(sys:%draw-line x1 y1 (floor (min maxx (max 0 (aref px 0)))) (floor (min maxx (max 0 (aref py 0))))
			alu nil sheet)))))


(defun 4shift-spline* (ax ay dxy max-x max-y &optional (min-x 0) (min-y 0))
  "2 AX and AY are vectors of X and Y points.
 DXY is a N x 2 array of the change in position of the points in AX/AY where N is the length of both AX and AY.
 MAX-X and MAX-Y are the maximum values that points in AX and AY may take on; if they would exceed that, then they are
  clipped to it, and the corresponding value in DX or DY is inverted.  Likewise for MIN-X and MIN-Y.*"
  (dotimes (n (length ax))
    (incf (aref ax n) (aref dxy n 0))
    (incf (aref ay n) (aref dxy n 1))
    (when (or (> (aref ax n) max-x)
	      (< (aref ax n) min-x))
      (setf (aref ax n) (min max-x (max min-x (aref ax n))))
      (setf (aref dxy n 0) (- (aref dxy n 0))))
    (when (or (> (aref ay n) max-y)
	      (< (aref ay n) min-y))
      (setf (aref ay n) (min max-y (max min-y (aref ay n))))
      (setf (aref dxy n 1) (- (aref dxy n 1))))))


;1;;*
;1;; This function will cons* 1(*3 * NPOINTS + NPOINTS * GRANULARITY1) words each time it is called.*
;1;; For the default, this is 35 words.  I think this is good enough to be a screensaver, since the function*
;1;; does not terminate.  So sue me.*
;1;;*
(defun 4spline-demo* (&optional (nlines 10) (npoints 5) (granularity 5) (closed t) (move-inc 25)
		              (sheet tv:selected-window) color)
  "2 *NLINES2 is how many lines to draw on the screen at once.*
 NPOINTS2 is how many control points the line has.*
 GRANULARITY2 is how many points to interpolate between each control point.*
 MOVE-INC2 is the average distance that one point will be shifted next generation.*
 SHEET2 is where to draw it.*"
  (send sheet :clear-screen)
  (when closed (incf npoints))
  (let* ((nresult (+ npoints (* granularity (1- npoints))))
	 (min-x 0) (min-y 0)
	 (max-x (- (tv:sheet-inside-width sheet) 2))
	 (max-y (- (tv:sheet-inside-height sheet) 2))
	 (splines '()))
    (dotimes (x nlines)
      (push (cons (make-array nresult :element-type 'SHORT-FLOAT :initial-element -1.0s0)
		  (make-array nresult :element-type 'SHORT-FLOAT :initial-element -1.0s0))
	    splines))
    (rplacd (last splines) splines)
    (let* ((ax (make-array npoints :element-type 'SHORT-FLOAT :initial-element 0.0s0))
	   (ay (make-array npoints :element-type 'SHORT-FLOAT :initial-element 0.0s0))
	   (dxy (make-array (list npoints 2) :element-type 'FIXNUM))
	   )
      ;1; set up the initial points.*
      (dotimes (n npoints)
	(setf (aref ax n) (+ min-x (random (- max-x min-x))))
	(setf (aref ay n) (+ min-y (random (- max-y min-y)))))
      ;1; set up the initial delta-x and delta-y of the points.*
      (dotimes (n npoints)
	(setf (aref dxy n 0) (- (random (* 2 move-inc)) move-inc))
	(setf (aref dxy n 1) (- (random (* 2 move-inc)) move-inc)))
      (when closed
	(setf (aref ax (1- npoints)) (aref ax 0))
	(setf (aref ay (1- npoints)) (aref ay 0)))
      (let* ((rx nil)
	     (ry nil)
	     (erase-alu (send sheet :erase-aluf))
	     (first-time t))
	(loop
	  (setq rx (car (car splines)))
	  (setq ry (cdr (car splines)))
	1   *;1; Except for the first time, erase the old spline.*
	  (if first-time
	      (setq first-time nil)
	      (draw-curve sheet rx ry nresult closed erase-alu)) ;1erase to the background color.*
	1   *;1;*
	1   *;1; Next, we bash the contents of the old spline since it has been erased.*
	  (tv:spline ax ay granularity rx ry (if closed :CYCLIC :RELAXED))
	  
	1   *;1; Then we draw this new spline.*
	  (tv:prepare-color (sheet color)
	    (draw-curve sheet rx ry nresult closed TV:ALU-TRANSP))
	  
	1   *;1; POPping from a circular list rotates it towards the front; the new line we have produced is currently at the*
	1   *;1; front, so this POP sends it to the bottom of the stack.*
	  (pop splines)
	1   *;1; Move the control points.*
	  (shift-spline ax ay dxy max-x max-y min-x min-y)
	  (when closed
	    (setf (aref ax (1- npoints)) (aref ax 0))
	    (setf (aref ay (1- npoints)) (aref ay 0)))
	  )))))


(defun 4spline-screenhack* (window)
  "2The ScreenSaver interface to the SPLINE-DEMO function.*"
  (let* ((colors '(W:WHITE W:BLUE W:RED W:PURPLE W:PINK W:CYAN W:MAGENTA W:YELLOW W:GREEN))
	 (color (if (tv:color-system-p window)
		    (symbol-value (nth (random (length colors)) colors))
		    nil))
	 (nlines 4)
	 (npoints 5)
	 (granularity 5)
	 (closed-p (zerop (random 2)))
	 (move-inc 25))
    ;1;*
    ;1; If we're on an Explorer II, then we can crank things up a bit without being slow.*
    (when (eq :EXPLORER-II (sys:processor-type))
      (setq move-inc (round move-inc 2)
	    granularity (* 3 granularity)
	    nlines (round (* nlines 1.5))))
    (spline-demo nlines npoints granularity closed-p move-inc window color)))


(when (boundp 'tv:*screen-saver-hacks-list*)
  (pushnew 'SPLINE-SCREENHACK tv:*screen-saver-hacks-list*))
