;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:ZWEI; Fonts:(CPTFONT HL12 TR12I COURIER CPTFONT HL12B) -*-

;1;; File "SHOW-COMTAB"*
;1;; Searching and examining ZMACS Comtabs.*
;1;; Written and maintained by Jamie Zawinski.*
;1;;*
;1;; ChangeLog:*
;1;;*
;1;; 25 Mar 87*	1Jamie Zawinski*	1Created.*
;1;;  8 Aug 87*	1Jamie Zawinski*	1Ported to 3.0.  (This only meant adding *SI::1 before vars like *%%KBD-CONTROL-META1).*
;1;;  5 Jan 89*	1Jamie Zawinski*	1Seems that now the "keyboard array" alist of comtabs assocs on chars, not ints.*
;1;;*				1 changed it so that FIND-BINDING can find keys either way.*

;1;; Synopsis:*
;1;; *
;1;; SHOW-COMTAB will list all of the bindings in a comtab and its parents.*
;1;;*
;1;; FIND-BINDING will tell you where the ultimate binding of a key comes from, or where any other bindings are.*
;1;;*

(defun 4show-comtab* (comtab &optional squeeze-self-insert)
  "2List the keybindings in COMTAB.  If SQUEEZE-SELF-INSERT is T, don't show those keys bound to 
SELF-INSERT, COM-NUMBERS, or COM-NEGATE-NUMERIC-ARG.*"
  (let* ((keyboard-array (comtab-keyboard-array comtab)))
    (cond ((listp keyboard-array)
	   (format t "3~&~:@(~S~) is a sparse comtab.~%*" (comtab-name comtab))
	   (if keyboard-array
	       (dolist (elt keyboard-array)
		 (when (and (cdr elt)
			    (not (eq (cdr elt) 'com-ordinarily-self-insert))
			    (not (and squeeze-self-insert
				      (or (consp (cdr elt))
					  (member (cdr elt) '(com-ordinarily-self-insert
							      com-numbers
							      com-negate-numeric-arg))))))
		   (format t "3~&   #\\~:C~25t ~S~%*" (int-char (car elt)) (cdr elt))))
	       (format t "3~&It contains no entries.~%~%*")))
	  ((arrayp keyboard-array)
	   (format t "3~&~:@(~S~) is a non-sparse comtab.~%*" (comtab-name comtab))
	   (let* ((any-entries-p nil))
	     (dotimes (x (array-dimension keyboard-array 0))
	       (dotimes (y (array-dimension keyboard-array 1))
		 (let* ((char (int-char (si:%logdpb y si:%%KBD-CONTROL-META x))))
		   (when (aref keyboard-array x y) (setq any-entries-p t))
		   (when (and (aref keyboard-array x y)
			      (not (and squeeze-self-insert
					(or (consp (aref keyboard-array x y))
					    (member (aref keyboard-array x y) '(com-ordinarily-self-insert
										com-numbers
										com-negate-numeric-arg))))))
		     (format t "3~&   #\\~:C~25t ~s~%*" char (aref keyboard-array x y))))))
	     (unless any-entries-p (format t "3~&It contains no entries.~%~%*"))))
	  (t (format t "3~&   KEYBOARD-ARRAY is ~S~%*" keyboard-array))))
  (when (and (comtab-indirect-to comtab)
	     (y-or-n-p "3~&~%~S indirects to ~S.  Look at ~:*~S? *"
		       (comtab-name comtab) (comtab-name (comtab-indirect-to comtab))))
    (terpri) (terpri)
    (show-comtab (comtab-indirect-to comtab) squeeze-self-insert)))


(defun 4find-binding-internal* (key comtab &optional (indent 0) except)
  (let* ((keyboard-array (comtab-keyboard-array comtab)))
    (let* ((binding (if (arrayp keyboard-array)
			(aref keyboard-array (ldb si::%%KBD-CHAR (char-int key))
			      (ldb si::%%KBD-CONTROL-META (char-int key)))
			(or (cdr (assoc (char-int key) keyboard-array))
			    (cdr (assoc key keyboard-array))))))
      (unless (member comtab except)
	(when binding
	  (when (listp binding) (setq binding (int-char (cadr binding))))
	  (format t "3~&~vT#\\~:C is bound to ~S in ~S.~%*" indent key binding (comtab-name comtab)))
	(cons comtab
	      (when (comtab-indirect-to comtab)
		(find-binding-internal key (comtab-indirect-to comtab) (if binding (+ indent 2) indent) except)))))))


(defun 4find-binding* (key &optional (comtab *comtab*))  
  "2Given a character, this function will tell you where it is bound in COMTAB, and what bindings are shadowed by this comtab.
If COMTAB is :ALL, then it searches even inaccessable comtabs for the binding.*"
  (cond ((eq comtab :ALL)
	 (let* ((done (list comtab)))
	   (dolist (ct every-comtab)
	     (setq done (append done (find-binding-internal key (symbol-value ct) 0 done))))))
	(t (check-type comtab comtab)
	   (find-binding-internal key comtab)))
  (values))
