;;; -*- Mode:Common-Lisp; Package:TV; Base:10 -*-

; rocks demo by John Nguyen  MIT  1988  johnn@hx.lcs.mit.edu

(defconstant *max-depth* 60)
(defvar *sin* (make-array 1000))
(defvar *cos* (make-array 1000))
(loop for i from 0 below 1000
      for angle = (/ (* i 2 pi) 1000)
      do
      (setf (aref *sin* i) (sin angle)
	    (aref *cos* i) (cos angle)))
(defvar *depths* (make-array (1+ *max-depth*)))
(loop for i from 2 to *max-depth*
      do
      (setf (aref *depths* i) (atan (/ .5 i))))

(defflavor rock
	   (real-size
	    r
	    theta
	    (depth nil)
	    size
	    x
	    y
	    width
	    height
	    hwidth
	    hheight
	    window)
	   ()
  :settable-instance-variables
  :gettable-instance-variables
  :inittable-instance-variables)

(defmethod (rock :reset) ()
  (setq width  (send window :width)
	height (send window :height))
  (setq hwidth  (lsh width -1)
	hheight (lsh height -1))
  (setq real-size 100
	r         (+ (random 30000.0) 700)
	theta     (random 1000)
	depth     *max-depth*)
  (send self :compute)
  (send self :draw x y size w:normal))

(defmethod (rock :tick) (d)
  (if depth
      (progn
	(decf depth)
	(setq theta (mod (+ theta d) 1000))
	(send self :draw x y size w:erase)
	(if (< depth 2)
	    (setq depth nil)
	    (progn
	      (send self :compute)
	      (send self :draw x y size w:normal))))
      (when (zerop (random 40))
	(send self :reset))))

(defmethod (rock :compute) ()
  (let ((factor (aref *depths* depth)))
    (setq size (round (* real-size factor))
	  x    (+ hwidth (round (* (aref *cos* theta) r factor)))
	  y    (+ hheight (round (* (aref *sin* theta) r factor))))))

(defmethod (rock :draw) (xx yy ss alu)
  (if (and (< 0 xx width)
	   (< 0 yy height))
      (cond ((<= ss 1)
	     (setf (aref (send window :screen-array) yy xx)
		   (if (equal alu w:normal) 1 0)))
	    (t
	     (let* ((s2 (lsh ss -1))
		    (x1 (- xx s2))
		    (y1 (- yy s2)))
	       (send window :bitblt alu ss ss (aref *circles* ss)
		     0 0 x1 y1))))
;	       (w:prepare-sheet (window)
;		 (w:with-clipping-rectangle (2 2 (- width 2) (- height 2))
;		   (w:%draw-rectangle ss ss x1 y1 alu window)))))
      (setq depth nil)))

(defvar *rocks* nil)
(loop repeat 100
      collect (make-instance 'rock)
      into rocks
      finally (setq *rocks* rocks))

(defvar *circles* (make-array 101))
(defun init-circles ()
  (loop for i from 2 to 100 do
	(let ((bits (make-array (list i (lsh (ceiling i 32) 5)) :element-type '(mod 2))))
	  (w:%draw-shaded-triangle (round (* .15 i)) (round (* .85 i))
				   (round (* .00 i)) (round (* .20 i))
				   (round (* .30 i)) (round (* .00 i))
				   w:normal t t t nil bits)
	  (w:%draw-shaded-triangle (round (* .15 i)) (round (* .85 i))
				   (round (* .30 i)) (round (* .00 i))
				   (round (* .40 i)) (round (* .10 i))
				   w:normal t t t nil bits)
	  (w:%draw-shaded-triangle (round (* .15 i)) (round (* .85 i))
				   (round (* .40 i)) (round (* .10 i))
				   (round (* .90 i)) (round (* .10 i))
				   w:normal t t t nil bits)
	  (w:%draw-shaded-triangle (round (* .15 i)) (round (* .85 i))
				   (round (* .90 i)) (round (* .10 i))
				   (round (* 1.0 i)) (round (* .55 i))
				   w:normal t t t nil bits)
	  (w:%draw-shaded-triangle (round (* .15 i)) (round (* .85 i))
				   (round (* 1.0 i)) (round (* .55 i))
				   (round (* .45 i)) (round (* 1.0 i))
				   w:normal t t t nil bits)
	  (setf (aref *circles* i) bits))))
(init-circles)

(defun tick-rocks (d)
  (process-sleep 1)
  (loop for rock in *rocks* do
	(send rock :tick d)))

(defun rocks (&optional (window w:selected-window))
  (send window :clear-screen)
  (loop for rock in *rocks* do
	(send rock :set-window window)
	(send rock :set-depth nil))
  (let ((cur-d 0))
    (do-forever
      (when (zerop (random 50))
	(let ((new-d (* (- (random 11) 5)
			(if (zerop (random 10)) 10 1))))
	  (do ((d cur-d (if (< cur-d new-d) (1+ d) (1- d))))
	      ((= d new-d))
	    (dotimes (i 3)
	      (tick-rocks d)))
	  (setq cur-d new-d)))
      (tick-rocks cur-d))))


(when (boundp '*screen-saver-hacks-list*)
  (pushnew 'rocks *screen-saver-hacks-list*))
