;;; -*- Mode:Common-Lisp; Package:USER; Base:10; Fonts:(COURIER TR12I TR12BI TR12 MEDFNTB) -*-

;1 File name: DEFSYSTEM.LISP*
;1 Defines the NEW-SYSTEM System*
;1 Started 8-24-1987 bvy Eric Karlson, UC-Berkeley under Robert Wilensky*
;1 Phone: (415) 642-9076, E-mail Address: karlson@ucbarpa.berkeley.edu*

;1 Export the global functions.*
(export '(net:REXEC net:RSHELL) 'net)
(export '(printer:PRINTER-QUEUE printer:CANCEL-PRINT-REQUEST) 'printer)

;1 Define th Network-Services system. This system is a collection of network protocols that I*
;1 have implemented for the TI.*

(defsystem 4network-services*
  (:name "3Network Services*")
  (:pathname-default "3v:KARLSON.NETWORK;*")
  (:patchable "3v:KARLSON.PATCH.NETWORK;*" network)
  (:warnings-pathname-default "3v:KARLSON.CWARNS;NETWORK.LISP#>*")

  (:module utilities "3UTILITIES*")
  (:module rexec "3REXEC-SERVICE*")
  (:module printer ("3SERVER*" "3PRINTER-SERVICE*" "3POSTSCRIPT-PRINTER*"))
  (:module tcp ("3TCP-MEDIUM*" "3TCP-STREAM*"))
  (:module udp "3UDP-STREAM*")
  (:module stream "3STREAMS*")
  (:module services "3NETWORK-MODE-EXPERT-EDITORS*")

  (:compile-load utilities)
  (:compile-load services)
  (:compile-load-init rexec (utilities) (:fasload utilities) (:fasload utilities))
  (:compile-load-init printer (utilities) (:fasload utilities) (:fasload utilities))
  (:compile-load udp)
  (:compile-load tcp))