;;; -*- Mode:Common-Lisp; Package:TV; Base:10 -*-
;;;
;;;
;;;   quad-triangle: kaleidoscope of QIX triangles
;;;
;;;   John Nguyen  MIT  1987  johnn@hx.lcs.mit.edu
;;;

(defconstant *num-triangles* 100)
(defconstant *num-sides* 4)

(defvar pos-x (make-array (list *num-triangles* *num-sides*) :element-type 'fixnum :initial-element 0))
(defvar pos-y (make-array (list *num-triangles* *num-sides*) :element-type 'fixnum :initial-element 0))
(defvar speed-x (make-array *num-sides* :element-type 'fixnum))
(defvar speed-y (make-array *num-sides* :element-type 'fixnum))

(defvar num-quad-triangles 50)

(defsubst quad-triangle-speed ()
  (+ 2 (random 3)))

(defun quad-triangles (window)
  (loop with real-width = (send window :width)
	and real-height = (send window :height)
	and width = (lsh (send window :width) -1)
	and height = (lsh (send window :height) -1)
	and ptr = 0 and last = 1
	initially
	(send window :clear-screen)
	(loop for i from 0 below *num-sides* do
	      (if (zerop (logand i 1))
		  (progn
		    (setf (aref pos-x 0 i) 0
			  (aref pos-y 0 i) 0
			  (aref speed-x i) (quad-triangle-speed)
			  (aref speed-y i) (quad-triangle-speed)))
		  (progn
		    (setf (aref pos-x 0 i) width
			  (aref pos-y 0 i) height
			  (aref speed-x i) (- (quad-triangle-speed))
			  (aref speed-y i) (- (quad-triangle-speed))))))
	while t do
	(w:prepare-sheet (window)
	  (loop for i from 0 below *num-sides*
		for j = (mod (1+ i) *num-sides*)
		do
		(tv:%draw-line (aref pos-x ptr i) (aref pos-y ptr i)
			       (aref pos-x ptr j) (aref pos-y ptr j)
			       w:normal t window)
		(tv:%draw-line (aref pos-x last i) (aref pos-y last i)
			       (aref pos-x last j) (aref pos-y last j)
			       w:erase t window)
		(tv:%draw-line (- real-width (aref pos-x ptr i)) (aref pos-y ptr i)
			       (- real-width (aref pos-x ptr j)) (aref pos-y ptr j)
			       w:normal t window)
		(tv:%draw-line (- real-width (aref pos-x last i)) (aref pos-y last i)
			       (- real-width (aref pos-x last j)) (aref pos-y last j)
			       w:erase t window)
		(tv:%draw-line (aref pos-x ptr i) (- real-height (aref pos-y ptr i))
			       (aref pos-x ptr j) (- real-height (aref pos-y ptr j))
			       w:normal t window)
		(tv:%draw-line (aref pos-x last i) (- real-height (aref pos-y last i))
			       (aref pos-x last j) (- real-height (aref pos-y last j))
			       w:erase t window)
		(tv:%draw-line (- real-width (aref pos-x ptr i))
			       (- real-height (aref pos-y ptr i))
			       (- real-width (aref pos-x ptr j))
			       (- real-height (aref pos-y ptr j))
			       w:normal t window)
		(tv:%draw-line (- real-width (aref pos-x last i))
			       (- real-height (aref pos-y last i))
			       (- real-width (aref pos-x last j))
			       (- real-height (aref pos-y last j))
			       w:erase t window)))
	(loop with new-ptr = (mod (1+ ptr) num-quad-triangles)
	      and temp
	      for i from 0 below *num-sides*
	      do
	      (if (< 0
		     (setq temp (+ (aref pos-x ptr i) (aref speed-x i)))
		     width)
		  (setf (aref pos-x new-ptr i) temp)
		  (progn
		    (setf (aref speed-x i)
			  (if (< (aref speed-x i) 0)
			      (quad-triangle-speed)
			      (- (quad-triangle-speed))))
		    (setf (aref pos-x new-ptr i)
			  (+ (aref pos-x ptr i) (aref speed-x i)))))
	      (if (< 0
		     (setq temp (+ (aref pos-y ptr i) (aref speed-y i)))
		     height)
		  (setf (aref pos-y new-ptr i) temp)
		  (progn
		    (setf (aref speed-y i)
			  (if (< (aref speed-y i) 0)
			      (quad-triangle-speed)
			      (- (quad-triangle-speed))))
		    (setf (aref pos-y new-ptr i)
			  (+ (aref pos-y ptr i) (aref speed-y i)))))
	      finally
	      (setq ptr new-ptr
		    last (mod (1+ last) num-quad-triangles)))))


(pushnew 'quad-triangles tv:*screen-saver-hacks-list*)


