;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:PRINTER; VSP:0; Fonts:(CPTFONT HL12 TR12I COURIER CPTFONT HL12B) -*-

;1;; File "3PS-FONT-MAP*"*
;1;; Give me full-screen-width, man!*
;1;;*
;1;; 5ChangeLog:**
;1;;*
;1;;    17 Aug 89*	1Jamie Zawinski*	1 Created.*
;1;;*   126 Sep 89*	1Jamie Zawinski *	 1Added adobe fonts to the font map.*
;1;;*


(unless (member :ADOBE-FONT-MAP *features*)
  (dolist (names '(("3ADOBE-COURIER*"	"3Courier*"	"3Courier-Bold*"	   "3Courier-Oblique*"	"3Courier-BoldOblique*")
		   ("3ADOBE-HL*"		"3Helvetica*"	"3Helvetica-Bold*" "3Helvetica-Oblique*" "3Helvetica-BoldOblique*")
		   ("3ADOBE-SYMBOL*"	"3Symbol*"	"3Symbol*"	   "3Symbol*"		"3Symbol*")
		   ("3ADOBE-TR*"		"3Times-Roman*"	"3Times-Bold*"	   "3Times-Italic*"	"3Times-BoldItalic*")
		   ))
    (dolist (size '(8 10 12 14 18 24))
      (let* ((faces '("" "3B*" "3I*" "3BI*")))
	(dolist (face faces)
	  (let* ((ti-font-name (format nil "3~A~D~A*" (first names) size face))
		 (ps-mapping (list (nth (1+ (position face faces)) names)
				   size)))
	    (push (list ti-font-name ps-mapping) *explorer-postscript-font-map*))))))
  (pushnew :ADOBE-FONT-MAP *features*)
  )

(defvar 4*original-explorer-postscript-font-map*)*
(setq 4*original-explorer-postscript-font-map* *Explorer-PostScript-font-map**)


(defun 4scale-ps-font-map *(scale)
  "2Call this function to multiply the sizes of all of the fonts in the PS font map by SCALE.
 If you want to print a file which uses more than 80 columns of text, call this will 0.7 or less.
 Calling it with 1.0 will reset the sizes to their defaults (the effect is not cumulative).*"
  (setq 4*explorer-postscript-font-map** (copy-tree 4**original-4explorer-postscript-font-map**))
  (do* ((rest1 4**original-4explorer-postscript-font-map** (cdr rest1))
	(rest2 4*explorer-postscript-font-map**          (cdr rest2))
	)
       ((null rest1))
    (let* ((cons1 (car rest1))
	   (cons2 (car rest2)))
      (let* ((font-cons1 (second cons1))
	     (font-cons2 (second cons2))
	     (size1 (second font-cons1))
	     (size2 (second font-cons2)))
	(if (consp size1)
	    (setf (first size2)  (round (* (first size1) scale))
		  (second size2) (round (* (second size1) scale)))
	    (setf (second font-cons2) (round (* size1 scale))))))))

;(scale-ps-font-map 0.7)
