;;; -*- Mode:Common-Lisp; Package:W; Base:10 -*-

(defconstant *procmon-default-width* 150)
(defconstant *procmon-default-height* 80)

(defvar *procmon-time-between-updates* 30)

(defflavor process-monitor-window
	   (
	    graph-height
	    graph-width
	    array
	    array-pointer
	    )
	   (w:process-mixin
	    w:graphics-mixin
	    w:minimum-window
	    )
  (:default-init-plist
    :process '(process-monitor)
    :expose-p t
    :deexposed-typeout-action :permit
    :save-bits t
    :blinker-p nil
    :width *procmon-default-width*
    :height *procmon-default-height*))

(defmethod (process-monitor-window :after :init) (&rest ignore)
  (send self :initialize))

(defmethod (process-monitor-window :screen-manage-deexposed-visibility) ()
  t)

(defmethod (process-monitor-window :mouse-click) (char x y)
  (ignore x y)
  (case char
    (#\mouse-l-1
     (send self :refresh)
     t)
    (t nil)))

(defmethod (process-monitor-window :deexposed-mouse-buttons) (mask x y)
  (send self :mouse-buttons mask x y))

(defmethod (process-monitor-window :who-line-documentation-string) ()
  `(:mouse-l-1 "Refresh process monitor"
    ,@(when (boundp 'w:*dragging-enabled?*) '(:mouse-m-hold "Drag window"))
    ))

(defmethod (process-monitor-window :deexposed-who-line-documentation-string) ()
  (send self :who-line-documentation-string))

(defmethod (process-monitor-window :verify-new-edges)
	   (new-left new-top new-width new-height)
  (ignore new-left new-top)
  (when (or (< new-width 80) (< new-height 50))
    "Process monitor size too small"))

(defmethod (process-monitor-window :after :change-of-size-or-margins) (&rest ignore)
  (send self :initialize)
  (send self :refresh))

(defun process-monitor (window)
  (send (send window :process) :set-priority -5)
  (send window :refresh)
  (send window :run))

(defmethod (process-monitor-window :initialize) ()
  (setq graph-width (- w:width 6))
  (setq graph-height (- w:height 25))
  (let ((array-width (lsh (lsh (+ graph-width 31) -5) 5)))
    (setq array (make-array (list graph-height array-width)
			    :element-type '(mod 2))))
  (setq array-pointer 0))

(defmethod (process-monitor-window :refresh) (&rest ignore)
  (send self :clear-screen)
  (send self :draw-rectangle 0 0 w:width w:height)
  (send self :draw-line 0 20 w:width 20)
;  (send self :draw-filled-rectangle
;	3 3 (- *display-width* 6) (- w:height 6) tv:25%-gray-color)
;  (send self :draw-rectangle 2 2 (- w:width 4) (- w:height 4))
  (send self :string-out-centered-explicit "PROCESSOR USAGE"
	0 6 w:width nil fonts:hl10b)
  (send self :display))

(defmethod (process-monitor-window :display) ()
  (w:prepare-sheet (self)
    (bitblt w:normal graph-width graph-height array 0 0
	    w:screen-array 3 22)))

(defmethod (process-monitor-window :run) ()
  (loop
    (send self :update-array)
    (send self :display)
    (sleep *procmon-time-between-updates*)))

(defmethod (process-monitor-window :update-array) ()
  (loop for p in si:active-processes
	sum (if (typep (car p) 'w:process)
		(send (car p) :percent-utilization)
		0)
	into total-percentage
	finally
	(let ((h (round (* graph-height total-percentage) 100)))
	  (setq h (min (max h 1) (1- graph-height)))
	  (tv:%draw-line array-pointer (- graph-height h)
			 array-pointer (1- graph-height)
			 w:normal t array)))
  (if (< array-pointer (1- graph-width))
      (incf array-pointer)
      (progn
	(bitblt w:normal (- graph-width 5) graph-height array 5 0 array 0 0)
	(decf array-pointer 4)
	(tv:%draw-rectangle 5 graph-height array-pointer 0 w:erase array))))
