;;; -*- Mode:Common-Lisp; Package:TV; Vsp:0; Fonts:(CPTFONT HL12 TR12I COURIER CPTFONT HL12B TR12BI ILSYMBOLS10); Base:10 -*-

;1;; File "3PHONES-INTERFACE*"*
;1;; A window-based phonebook program.*
;1;; Written by Eric Gardner and Jamie Zawinski.*
;1;;*
;1;; 5ChangeLog:**
;1;;*
;1;;   distant past*	1Eric Gardner*	1Created.*
;1;;   10 Apr 89*	1Jamie Zawinski*	1Added changelog, fontified the display.*
;1;;   11 Apr 89*	1Jamie Zawinski *	1Got rid of the scrollbar on the query window.  Made Control-V and Meta-V scroll the list nearest the*
;1;;*				1  mouse instead of always scrolling the query window.*
;1;;   16 Apr 89*	1Jamie Zawinski *	1Made the items in the list default to a one-line display, and expand or contract on middle-click.*
;1;;*				1Gave them wholine documentation strings.*
;1;;    26 Apr 89*	1Jamie Zawinski* 1 * 1 Phone numbers like 5621-0818* were printing as 5621-818* because 5~A* was being used instead of 5~4,'0D.**
;1;;    27 Apr 89*	1Jamie Zawinski *	1Sped up the expansion/contraction of items.  Made query-window mousable.*
;1;;    28 Apr 89*	1Jamie Zawinski *	1Started working on the Edit Window.*
;1;;   10 May 89*	1Jamie Zawinski *	1Added some editing ability.*
;1;;   12 May 89*	1Jamie Zawinski *	1Got rid of superfluous mouse-bindings - mouse L activiates items, mouse-R brings up a menu.*
;1;;*				1Renamed *MAIN-MENU1 to be *PHONE-DB-MAIN-MENU1.*
;1;;     9 Jun 89*	1Jamie Zawinski *	1Added the ability to add and delete entries.*
;1;;*  114 Sep 89*	1Jamie Zawinski *	1Renamed some of the flavors to be more unique (typein-window --> phone-typein-window).*
;1;;*				1Parameterized the fonts some, so that they can be smaller if the window is small.*
;1;;*				1Mixed in KSL's mousable labels if they are around at compile-time.*
;1;;*  112 Feb 90*	1Jamie Zawinski *	1Added a new configuration that is more usable in small sizes.*
;1;;*				1Defined Zmacs commands 5Who Sender* and 5Annotate Sender* for touching the phone db while in the*
;1;;*				1 mail reader.  So I don't have to remember who I'm talking to....*
;1;;*  122 Feb 90*	1Jamie Zawinski *	1Changed defvar of *phone-db-constraints-list* to be defparameter so this can be re-loaded...*
;1;;*   11 Mar 90*	1Jamie Zawinski *	1Made unknown zip-codes print as "" instead of "00000".*
;1;;*				1Made addresses be mailable and numbers be dialable from the Selected Record window (Mouse-M).*
;1;;*


(defvar *phone-db-command-table*)
(defvar *phone-db-minimalist-command-table*)

(defvar *phone-db-command-menu*)


(defvar 4*phone-db-default-font**		 nil	"2The font in which most text is displayed.*")
(defvar 4*phone-db-name-font**		 nil	"2The font in which personal names are displayed.*")
(defvar 4*phone-db-postal-address-font**	 nil	"2The font in which postal addresses are displayed.*")
(defvar 4*phone-db-phone-extension-font**	 nil	"2The font in which telephone extensions are displayed.*")
(defvar 4*phone-db-company-font**		 nil	"2The font in which company names are displayed.*")
(defvar 4*phone-db-net-address-font**	 nil	"2The font in which network addresses are displayed.*")
(defvar 4*phone-db-phone-number-font**	 nil	"2The font in which phone numbers are displayed.*")

(defun 4phone-db-default-fonts *()
  "2Set the Phone DB program up to use a readable font set.*"
  (setq 4*phone-db-default-font** fonts:hl12
	4*phone-db-name-font** fonts:hl12b
	4*phone-db-postal-address-font** fonts:HL12I
	4*phone-db-phone-extension-font** fonts:tr10i
	4*phone-db-company-font** fonts:hl12bi
	4*phone-db-net-address-font** fonts:tvfont
	4*phone-db-phone-number-font** fonts:cptfont))

(defun 4phone-db-small-fonts *()
  "2Set the Phone DB program up to use a small font set.*"
  (setq 4*phone-db-default-font** fonts:hl10
	4*phone-db-name-font** fonts:hl10b
	4*phone-db-postal-address-font** fonts:tr10i
	4*phone-db-phone-extension-font** fonts:tr8i
	4*phone-db-company-font** fonts:tr10bi
	4*phone-db-net-address-font** fonts:tvfont
	4*phone-db-phone-number-font** fonts:tvfont))

(phone-db-default-fonts)


;1;;; This is some conditional compilation noise - ignore it.*
(eval-when (eval compile)
  (when (get 'w::label-accelerators-for-superior 'sys:flavor)
    (pushnew :accelerators *features*))) ;1 removed later*



;1;; The windows.*

(defparameter *phone-db-pane-list* '((menu			phone-db-main-menu)
				     (query			phone-query-window)
				     (master-phone-list	master-phone-list-window)
				     (query-phone-list	query-phone-list-window)
				     (selected-phone-record	selected-phone-record-window)
				     (typein			phone-typein-window)))


(defparameter *phone-db-constraints-list*
	      '((LARGE . ((whole)
			  ((whole :horizontal (:even)
			     (left-side right-side)
			     ((left-side :vertical (0.7)
				(phone-list typein)
				((phone-list :horizontal (0.9)
				   (master-phone-list query-phone-list)
				   ((master-phone-list 0.5))
				   ((query-phone-list :even))))
				((typein :even))))
			     ((right-side :vertical (:even)
				(menu query selected-phone-record)
				((menu   :limit (10 10 :lines) 0.01))
				((query  :limit (9 9 :lines) 0.01))
				((selected-phone-record :even))
				))))))
		
		(SMALL   . ((whole)
			    ((whole :horizontal (:even) (whole2)
			       ((whole2 :vertical (:even)
				  (top typein)
				  ((typein :limit (6 8 :lines) 0.01))
				  ((top :horizontal (:even)
				     (left-side right-side)
				     ((right-side :vertical (:limit (25 40 :characters menu) 0.01)
					(menu query)
					((menu   :limit (10 10 :lines) 0.01))
					((query  :even))))
				     ((left-side :vertical (:even)
					(mumble)
					((mumble :horizontal (:even)
					   (master-phone-list middle-column)
					   ((master-phone-list 0.5))
					   ((middle-column :vertical (:even)
					      (query-phone-list selected-phone-record)
					      ((selected-phone-record :limit (15 20 :lines) 0.1))
					      ((query-phone-list :even))
					      ))))))
				     ))
				  ))))))
		))

(defvar *phone-db-4default-configuration**4 *nil
  "2The default configuration to use.  Should be 'LARGE 'SMALL, or NIL, meaning use the first one (which is, uh, large).*")


(defflavor phone-db-frame
	   (main-menu master-phone-list query-phone-list query selected-phone-record
	    (editor-window nil))
	   (ucl:command-loop-mixin
	    #+ACCELERATORS w:label-accelerator-mixin
	    ucl:selective-features-mixin
	    tv:inferiors-not-in-select-menu-mixin
	    tv:list-mouse-buttons-mixin
	    tv:bordered-constraint-frame-with-shared-io-buffer
	    w:window)
  (:default-init-plist
    :remove-features '(:LISP-TYPEIN :ALL-UNIVERSAL-COMMANDS)
    :active-command-tables '(*phone-db-command-table*)
    :all-command-tables    '(*phone-db-command-table* *phone-db-minimalist-command-table*)
    
    ;1;Specify that terminal-io be used for command type-in.  The default is a pop-up window.*
    ;1;See below in 5:designate-io-streams* where terminal-io is set to the interaction pane.*
    :typein-handler nil ;1 :handle-typein-input*
    
    :constraints *phone-db-constraints-list*
    :panes	 *phone-db-pane-list*
    :menu-panes '((menu *phone-db-command-menu*))

    :configuration *phone-db-4default-configuration**
    
    :more-p      nil
    :blinker-deselected-visibility nil
    :border-margin-width 2
    :label nil
    )
  :gettable-instance-variables
  :settable-instance-variables
  :initable-instance-variables)


(defflavor 4basic*-phone-list-window
	   ((phone-list '())
	    (expanded-listings '())
	    )
	   (w:scroll-mouse-mixin
	    w:borders-mixin
	    w:scroll-bar-mixin
	    w:scroll-window-with-typeout)
  (:default-init-plist
    :truncation t
    :blinker-deselected-visibility nil
    :save-bits t
    :border-margin-width 5
    :label nil)
  :gettable-instance-variables
  :settable-instance-variables
  :initable-instance-variables)

(defflavor master-phone-list-window () (basic-phone-list-window)
  :gettable-instance-variables
  :settable-instance-variables
  :initable-instance-variables)

(defflavor query-phone-list-window () (basic-phone-list-window)
  :gettable-instance-variables
  :settable-instance-variables
  :initable-instance-variables)


(defflavor 4phone-db-*main-menu
	   ((w:item-alignment :center)
	    (w:columns 1))
	   (#+ACCELERATORS w:label-accelerators-for-superior
	    w:dynamic-item-list-mixin
	    w:command-menu-pane
	    tv:menu)
  (:default-init-plist
    :border-margin-width 2
    :label  '(:string "Phone DB" :font FONTS:METS :centered)
    )
  :gettable-instance-variables
  :settable-instance-variables
  :initable-instance-variables)


(defflavor phone-typein-window
	   ()
	   (#+ACCELERATORS w:label-accelerators-for-superior
	    ucl:command-and-lisp-typein-window)
  (:default-init-plist :label nil :more-p nil)
  :gettable-instance-variables
  :settable-instance-variables
  :initable-instance-variables)


(defmethod (phone-db-frame :after :set-more-p) (newval)
  (send (send self :get-pane 'typein) :set-more-p newval))

(defflavor phone-query-window
	   ((company "") (name "") (area-code nil) (phone-prefix nil) (phone-extension nil)
	    (note "") (net ""))
	   (w:basic-mouse-sensitive-items w:window)
  (:default-init-plist
    :blinker-deselected-visibility nil
    :item-type-alist '((:query-company         :query-company "3Limit Search by Company Name*")
		       (:query-name            :query-name "3Limit Search by Name*")
		       (:query-area-code       :query-area-code  "3Limit Search by Area Code*")
		       (:query-phone-prefix    :query-phone-prefix    "3Limit Search by Phone Prefix*")
		       (:query-phone-extension :query-phone-extension "3Limit Search by Phone Suffix*")
		       (:query-net	       :query-net	      "3Limit Search by Network Address*")
		       (:query-notes	       :query-notes	      "3Limit Search by Annotations*")
		       (:query-reset	       :query-reset "3Unlimit the Search*")
		       )
    :font-map #(fonts:tr12 fonts:tr12i)
    :border-margin-width 2 :label nil)
  :gettable-instance-variables
  :settable-instance-variables
  :initable-instance-variables)


(defflavor selected-phone-record-window
	   ((person-rec nil))
	   (w:basic-mouse-sensitive-items
	    w:line-truncating-mixin
	    w:window)
  (:default-init-plist
    :blinker-deselected-visibility nil
    :border-margin-width 2
    :item-type-alist '((:edit-company         :edit-company "3Edit Company Name*")
		       (:edit-name            :edit-name "3Edit Name*")
		       (:edit-phone           :edit-phone "3Edit a Phone Number*")
		       (:edit-address         :edit-address "3Edit an Address*")
		       (:edit-notes           :edit-notes "3Edit the Notes*")
		       (:edit-net	      :edit-net "3Edit the Network Address*")
		       (:edit-menu	      :edit-menu "3Menu of More Commands*")
		       )
    :label nil
    )
  :gettable-instance-variables
  :settable-instance-variables
  :initable-instance-variables)


(defmethod 4(phone-db-frame :inverse-around :init)* (cont mt args plist)
  "2If the :configuration init parameter is NIL, set it to the first configuration we can find.*"
  (unless (get plist :configuration)
    (setf (get plist :configuration)
	  (caar (or (get plist :constraints)
		    tv:constraints
		    *phone-db-constraints-list*))))
  (sys:funcall-with-mapping-table cont mt (car args) plist))


(defmethod 4(phone-db-frame :after :init*) (&rest ignore)
  ;1;*
  ;1; Initialize the pointers to the subwindows.*
  ;1;*
  (setq main-menu (send self :get-pane 'menu))
  (setq master-phone-list (send self :get-pane 'master-phone-list))
  (setq query-phone-list  (send self :get-pane 'query-phone-list))
  (setq query (send self :get-pane 'query))
  (setq selected-phone-record (send self :get-pane 'selected-phone-record))
  
  (setq editor-window (make-instance 'zwei:standalone-editor-window :superior self :label nil))
  ;1;*
  ;1; Initialize the command menu.*
  (setf (send main-menu :item-list) (send main-menu :column-spec-list))
  ;1;*
  ;1; Enable mouse-sensitive-text input.*
  (push '(:TYPEOUT-EXECUTE :HANDLE-TYPEOUT-EXECUTE) ucl:blip-alist)
  ;1; Enable deferred execution.*
  (push '(:EXECUTE :HANDLE-EXECUTE) ucl:blip-alist)
  ;1;*
  ;1; Load a database if one is not loaded*
  (unless *phone-list* (read-phone-file *default-phone-db-file* t))
  (send master-phone-list :set-phone-list *phone-list*)
  )


(defmethod (phone-db-frame :designate-io-streams) ()
  (setq *terminal-io* (send self :get-pane 'typein)))


(defmethod (phone-db-frame :name-for-selection) () (send self :name))

(defmethod 4(basic-phone-list-window*	4 :screen-manage-deexposed-visibility*) () t)
(defmethod 4(selected-phone-record-window :screen-manage-deexposed-visibility*) () t)
(defmethod 4(phone-query-window*		4 :screen-manage-deexposed-visibility*) () t)
(defmethod 4(phone-typein-window*		4 :screen-manage-deexposed-visibility*) () t)
(defmethod 4(phone-db-main-menu*		4 :screen-manage-deexposed-visibility*) () t)


(defun phone-list-entries (phone-list-window phone-list)
  (scroll-parse-phone-rec phone-list-window phone-list))


(defun 4display-phone-list-window* (phone-list-window phone-list &optional (go-to-top t))
  "2Completely recalculate the scroll-items of the Phone list.*"
  (when phone-list
    (let* ((new-display-item (phone-list-entries phone-list-window phone-list)))
      (if go-to-top
	  (send phone-list-window :set-display-item new-display-item)
	  (send phone-list-window :alter-display-item new-display-item)))))


(defmethod 4(master-phone-list-window :before :refresh)* (&rest ignore)
  ;1; If it's empty, maybe we're out of date.*
  (when (null phone-list) (setq phone-list *phone-list*)))


(defmethod 4(basic-phone-list-window :before :refresh)* (&optional (type :complete-redisplay))
  "2Make sure the font map corresponds to the font variables, and adjust the screen image if the number-of-lines has changed.*"
  (when (eq type :complete-redisplay)
    (send self :set-font-map (vector 4*phone-db-default-font** 4*phone-db-name-font** 4*phone-db-postal-address-font** 
				     4*phone-db-phone-extension-font** 4*phone-db-company-font** 4*phone-db-net-address-font**
				     4*phone-db-phone-number-font**))
    (setq tv:screen-lines (floor (tv:sheet-inside-height) tv:line-height))
    (unless (>= (array-dimension tv:screen-image 0) tv:screen-lines)
      (adjust-array tv:screen-image (list tv:screen-lines (array-dimension tv:screen-image 1))
		    :initial-element (list nil -1 -1)))
    ))


(defmethod 4(basic-phone-list-window :after :refresh*) (&optional (type :complete-redisplay))
  "2Draw the phone list item.*"
  (send self :set-more-p nil)
  (when (and (eq type :complete-redisplay) phone-list)
    (send self :clear-screen)
    (display-phone-list-window self phone-list nil)
    ))


(defmethod 4(phone-db-frame :handle-typeout-execute*) ()
  (declare (special UCL:KBD-INPUT))
  (let* ((type (second UCL:KBD-INPUT)))
    (send self type)))


(defmethod (4phone-db*-frame :handle-execute) ()
  (declare (special UCL:KBD-INPUT))
  (apply (second UCL:KBD-INPUT) (cddr UCL:KBD-INPUT)))


(defmethod (phone-query-window :after :refresh) (&optional (type :complete-redisplay))
  "2Draw the query window's mouse-items.*"
  (send self :set-more-p nil)
  (when (eq type :complete-redisplay)
    (send self :clear-screen)
    (setq company (send self :company))
    (setq name (send self :name))
    (setq area-code (send self :area-code))
    (setq phone-prefix (send self :phone-prefix))
    (setq phone-extension (send self :phone-extension))
    (send self :set-current-font fonts:tr12 t)
    (format self "3~2&~VM~2%*" :query-reset "3<Reset All>*")
    (flet ((mouse-item (item-name type string &optional format-string)
	     (send self :set-current-font fonts:tr12 t)
	     (format self "3~&~A~21t*" item-name)
	     (cond ((or (null string) (equal "" string))
		    (send self :set-current-font fonts:tr12i t)
		    (format self "3~VM*" type "3<any>*"))
		   (t
		    (format self "3~VM*" type (if format-string (format nil format-string string) string))))))
      (mouse-item "3Company Name:*" :query-company company)
      (mouse-item "3Name:*" :query-name name)
      (mouse-item "3Area Code:*" :query-area-code area-code "3~3,'0d*")
      (mouse-item "3Phone Prefix:*" :query-phone-prefix phone-prefix "3~3,'0d*")
      (mouse-item "3Phone Suffix:*" :query-phone-extension phone-extension "3~4,'0d*")
      (mouse-item "3Net Address:*" :query-net net)
      (mouse-item "3Notes:*" :query-notes note)
      )))


(defmethod 4(*query-phone-list-window4 :before *:compute-border-margin-area-margins4)* (&rest ignore)
  "2Make the Query List Window not have a ScrollBar.*"
  (send self :set-scroll-bar-on-off :off))


(defmethod 4(selected-phone-record-window :after :refresh*) (&optional (type :complete-redisplay))
  "2Draw this window's mouse-items.*"
  (send self :set-more-p nil)
  (setf (tv:sheet-truncate-line-out-flag) 0)
  (send self :set-font-map (vector 4*phone-db-default-font** 4*phone-db-name-font** 4*phone-db-postal-address-font** 
				   4*phone-db-phone-extension-font** 4*phone-db-company-font** 4*phone-db-net-address-font**
				   4*phone-db-phone-number-font**))
  (when (and person-rec (eq type :complete-redisplay))
    (send self :clear-screen)
    (send self :set-more-p nil)
    (let (cx cy max-cx)
      (flet ((space (n)
	       (setf (tv:sheet-truncate-line-out-flag) 1)
	       (setf tv:cursor-x tv:left-margin-size
		     tv:cursor-y (+ tv:cursor-y n))))
	(let* ((pname (and (person-name person-rec) (pretty-print-person-name (person-name person-rec))))
	       (pcomp (person-company person-rec)))
	  (when (string= pname "") (setq pname nil))
	  (when (string= pcomp "") (setq pcomp nil))
	  (when pname
	    (send self :set-current-font *phone-db-name-font* t)
	    (setf (tv:sheet-truncate-line-out-flag) 1)
	    (format self "3~vM*" :edit-name (string-append pname #\Space)))
	  (when pcomp
	    (send self :set-current-font *phone-db-company-font* t)
	    (setf (tv:sheet-truncate-line-out-flag) 1)
	    (when (and pname pcomp) (princ "3-*" self))
	    (format self "3~vM*" :edit-company (string-append #\Space pcomp #\Space))))
	(terpri self)
	(space 5)
	
	(setq cx tv:cursor-x cy tv:cursor-y max-cx cx)
	(dolist (phone (person-phones person-rec))
	  (send self :set-current-font *phone-db-default-font* t)
	  (setf (tv:sheet-truncate-line-out-flag) 1)
	  (format self "3~4t~A*" (phone-where phone))
	  (send self :set-current-font *phone-db-phone-number-font* t)
	  (setf (tv:sheet-truncate-line-out-flag) 1)
	  (format self "3~16t~a *" (phone-number-string phone t))
	  (when (phone-ext phone)
	    (setf (tv:sheet-truncate-line-out-flag) 1)
	    (send self :set-current-font *phone-db-phone-extension-font* t)
	    (format self "3(~A)*" (phone-ext phone)))
	  (setq max-cx (max max-cx tv:cursor-x))
	  (terpri self))
	(send self :primitive-item :edit-phone person-rec (* 3 tv:char-width) (- cy tv:top-margin-size) max-cx tv:cursor-y)
	(when (person-phones person-rec) (space 5))
	
	(setq cx tv:cursor-x cy tv:cursor-y max-cx 0)
	(dolist (address (person-addresses person-rec))
	  (send self :set-current-font *phone-db-name-font* t)
	  (format self "3~3t~A*" (address-where address))
	  (send self :set-current-font *phone-db-postal-address-font* t)
	  (when (string/= (address-street1 address) "")
	    (format self "3~12t~A*" (address-street1 address))
	    (setq max-cx (max max-cx tv:cursor-x)) (terpri self))
	  (when (string/= (address-street2 address) "")
	    (format self "3~12t~A*" (address-street2 address))
	    (setq max-cx (max max-cx tv:cursor-x)) (terpri self))
	  (if (zerop (or (address-zip address) 0))
	      (format self "3~12t~A, ~A*" (or (address-city address) "") (or (address-state address) ""))
	      (format self "3~12t~A, ~A  ~5,'0D*" (or (address-city address) "")
		      (or (address-state address) "") (or (address-zip address) 0)))
	  (setq max-cx (max max-cx tv:cursor-x))
	  (terpri self)
	  (space 5))
	(send self :primitive-item :edit-address person-rec
	      (* 3 tv:char-width) (- cy tv:top-margin-size) max-cx tv:cursor-y)
	(unless (string= (person-net person-rec) "")
	  (send self :set-current-font *phone-db-postal-address-font* t)
	  (princ "3net:  *" self)
	  (send self :set-current-font *phone-db-net-address-font* t)
	  (setf (tv:sheet-truncate-line-out-flag) 1)
	  (format self "3~vM*" :edit-net (person-net person-rec))
	  (terpri self))
	
	(unless (string= (person-note person-rec) "")
	  (send self :set-current-font *phone-db-default-font* t)
	  (setf (tv:sheet-truncate-line-out-flag) 0)
	  (let* ((x tv:cursor-x)
		 (y tv:cursor-y))
	    (multiple-value-bind (ignore max-y ignore max-x)
				 (send self :compute-motion (person-note person-rec) 0 nil x y
				       nil 0 nil nil nil *phone-db-default-font*)
	      (incf max-y tv:line-height)
	      (write-string (person-note person-rec) self)
	      (send self :primitive-item :edit-notes person-rec
		    (- x tv:left-margin-size) (- y tv:top-margin-size) max-x max-y)
	      (setf (tv:sheet-truncate-line-out-flag) 1)
	      )))
	))))


(defwhopper 4(basic-phone-list-window :mouse-click)* (button x y)
  "2Make Mouse-R bring up the system menu, even over a scrolling-text window.*"
  (prog1
    (continue-whopper button x y)
    (let* ((blip (read-any-no-hang self)))
      (cond ((null blip))
	    ((and (consp blip)
		  (eq (car blip) :MOUSE-BUTTON)
		  (char= (second blip) #\Mouse-R))
	     (send self :force-kbd-input (list :execute #'mouse-call-system-menu)))
	    (t (send self :force-kbd-input blip))))))


(defwhopper 4(phone-query-window :mouse-click)* (button x y)
  "2Make Mouse-R bring up the system menu.*"
  (if (char= button #\Mouse-R)
      (tv:mouse-call-system-menu)
      (continue-whopper button x y)))

(defwhopper 4(selected-phone-record-window :mouse-click)* (button x y)
  "2Make Mouse-R bring up the edit menu.*"
  (cond ((char= button #\Mouse-R)
	 (send tv:superior :force-kbd-input (list :execute #'(lambda (w) (send w :edit-menu)) tv:superior)))
	((char= button #\Mouse-M)
	 (send self :handle-mouse-m x y))
	(t (continue-whopper button x y))))

(defmethod 4(phone-query-window :non-sensitive-mouse-click*) (button x y)
  "2Does nothing - This is just so extranious clicks cause a beep.*"
  (declare (ignore button x y)))

(defmethod 4(selected-phone-record-window :non-sensitive-mouse-click*) (button x y)
  "2Does nothing - This is just so extranious clicks cause a beep.*"
  (declare (ignore button x y)))


(defwhopper 4(selected-phone-record-window :who-line-documentation-string)* ()
  (let* ((string (continue-whopper))
	 (rest '(:Mouse-R-1 "2Edit Menu*" :Mouse-R-2 "2System Menu*")))
    (if string
	(list* :Mouse-L-1 string :Mouse-M-1 "2Activate Item*" rest)
	rest)))

(defwhopper 4(phone-query-window :who-line-documentation-string)* ()
  (let* ((string (continue-whopper))
	 (rest '(:Mouse-R-1 "3System Menu*")))
    (if string
	(list* :Mouse-L-1 string rest)
	rest)))


(defmethod 4(selected-phone-record-window :handle-mouse-M)* (x y)
  (let* ((item (send self :mouse-sensitive-item x y)))
    (if item
	(case (car item)
	  (:EDIT-NET (mouse-mail person-rec self))
	  (:EDIT-PHONE
	   (let* ((phones (person-phones person-rec)))
	     (if (null (cdr phones))
		 (mouse-dial (car phones) self)
		 (process-run-function "3Mouse Dial*"
		   #'(lambda (phones window)
		       (let* ((p (w:menu-choose
				   (mapcar #'(lambda (x) (list (format-phone x) :value x :font fonts:hl12)) phones)
				   :label '(:string "3Dial which phone number?*" :font FONTS:HL12B))))
			 (and p (mouse-dial p window))))
		   phones self))))
	  (:EDIT-ADDRESS
	   (let* ((addresses (person-addresses person-rec)))
	     (if (null (cdr addresses))
		 (mouse-address (person-name person-rec) (car addresses) self)
		 (process-run-function "3Mail Address*"
		   #'(lambda (addresses person-name window)
		       (let* ((a (w:menu-choose
				   (mapcar #'(lambda (address)
					       (list (if (zerop (or (address-zip address) 0))
							 (format nil "3 ~A:  *~3A, ~A*"
								 (address-where address) (or (address-city address) "")
								 (or (address-state address) ""))
							 (format nil "3 ~A:  *~3A, ~A  ~5,'0D*"
								 (address-where address) (or (address-city address) "")
								 (or (address-state address) "")
								 (address-zip address)))
						     :value address :font fonts:hl12))
					   addresses)
				   :label '(:string "3Mail to which Address?*" :font FONTS:HL12B))))
			 (and a (mouse-address person-name a window))))
		   addresses (person-name person-rec) self))))
	  (t (beep)))
	(beep))))


(defmethod 4(phone-query-window :query*) ()
  (phone-search :company (send self :company)
		:name (send self :name)
		:area-code (send self :area-code)
		:phone-prefix (send self :phone-prefix)
		:phone-extension (send self :phone-extension)
		:net-address (send self :net)
		:notes (send self :note)))

(defmethod 4(phone-typein-window :after :refresh*) (&optional (type :complete-redisplay))
  (when (eq type :complete-redisplay) (send self :home-cursor)))



;1;;; The Command Definitions.*

(defmacro 4def-phone-db-command* ((method-name string-name description &optional keys) arglist &body body)
  "2Shorthand for the calls to DEFCOMMAND that we make for the phone DB.*"
  `(defcommand (phone-db-frame ,method-name) ,arglist
     '(:description ,description
       :names ,string-name
       :keys ,keys)
     ,@body))


(defun 4prompt-with-default *(prompt-string default &optional type format-string)
  "2Calls prompt-and-read, after stuffing some text on the input buffer as a default.*"
  (let* ((string (if format-string
		     (format nil format-string default)
		     (princ-to-string default))))
    (send *query-io* :force-kbd-input string)
    (send *query-io* :force-kbd-input #\Control-A)
    (prompt-and-read (or type :string-trim) "3~&~A *" prompt-string)))


(def-phone-db-command 4(:query-company "2Query on Company*" "3Query on Company*"*) ()
  (let* ((company (prompt-with-default "3Company:*" (send query :company))))
    (setf (send query :company) company)
    (send query :refresh :complete-redisplay)
    (setf (send query-phone-list :phone-list) (send query :query))
    (update-phone-list-window nil query-phone-list t)
    (format t "3~&Finished Query.~%*")))

(def-phone-db-command 4(:query-name "2Query on Name*" "3Query on Name*"*) ()
  (let* ((new-name (prompt-with-default "3Name:*" (send query :name))))
    (setf (send query :name) new-name)
    (send query :refresh :complete-redisplay)
    (setf (send query-phone-list :phone-list) (send query :query))
    (update-phone-list-window nil query-phone-list t)
    (format t "3~&Finished Query.~%*")))

(def-phone-db-command 4(:query-area-code "2Query on Area Code*" "3Query on Area Code*"*) ()
  (let* ((area-code (prompt-with-default "3Area Code:*" (send query :area-code) '(:NUMBER :OR-NIL T) "3~:[~;~:*~3,'0D~]*")))
    (setf (send query :area-code) area-code)
    (send query :refresh :complete-redisplay)
    (setf (send query-phone-list :phone-list) (send query :query))
    (update-phone-list-window nil query-phone-list t)
    (format t "3~&Finished Query.~%*")))

(def-phone-db-command 4(:query-phone-prefix "2Query on Phone Prefix*" "3Query on Phone Prefix*"*) ()
  (let* ((phone-prefix (prompt-with-default "3Phone Prefix:*" (send query :phone-prefix) '(:NUMBER :OR-NIL t)
					    "3~:[~;~:*~3,'0D~]*")))
    (setf (send query :phone-prefix) phone-prefix)
    (send query :refresh :complete-redisplay)
    (setf (send query-phone-list :phone-list) (send query :query))
    (update-phone-list-window nil query-phone-list t)
    (format t "3~&Finished Query.~%*")))

(def-phone-db-command 4(:query-phone-extension "2Query on Phone Suffix*" "3Query on Phone Extension*"*) ()
  (let* ((phone-extension (prompt-with-default "3Phone Suffix:*" (send query :phone-extension) '(:NUMBER :OR-NIL t)
					       "3~:[~;~:*~4,'0D~]*")))
    (setf (send query :phone-extension) phone-extension)
    (send query :refresh :complete-redisplay)
    (setf (send query-phone-list :phone-list) (send query :query))
    (update-phone-list-window nil query-phone-list t)
    (format t "3~&Finished Query.~%*")))

(def-phone-db-command 4(:query-net "2Query on Network Address*" "2Query on Network Address*"*) ()
  (let* ((addr (prompt-with-default "3Network Address:*" (or (send query :net) "") :string-trim "3~A*")))
    (setf (send query :net) addr)
    (send query :refresh :complete-redisplay)
    (setf (send query-phone-list :phone-list) (send query :query))
    (update-phone-list-window nil query-phone-list t)
    (format t "3~&Finished Query.~%*")))

(def-phone-db-command 4(:query-notes "2Query on Notes*" "2Query on Notes*"*) ()
  (let* ((note (prompt-with-default "3Notes:*" (or (send query :note) "") :string-trim "3~A*")))
    (setf (send query :note) note)
    (send query :refresh :complete-redisplay)
    (setf (send query-phone-list :phone-list) (send query :query))
    (update-phone-list-window nil query-phone-list t)
    (format t "3~&Finished Query.~%*")))


(def-phone-db-command 4(:query-reset "2Reset Query Window*" "3Reset Query Window*"*) ()
  (setf (send query :company) "")
  (setf (send query :name) "")
  (setf (send query :area-code) nil)
  (setf (send query :phone-prefix) nil)
  (setf (send query :phone-extension) nil)
  (setf (send query :net) "")
  (setf (send query :note) "")
  (send query :refresh :complete-redisplay)
  (setf (send query-phone-list :phone-list) (send query :query))
  (update-phone-list-window nil query-phone-list t)
  (format t "3~&Finished Resetting Query.~%*"))


(def-phone-db-command 4(:read-phone-db "2Read phone db*" "2Read a phone db file*"*) ()
  (let* ((default *default-phone-db-file*)
	 (file (prompt-and-read (list :PATHNAME :DEFAULTS default) "3~&Read db from what file? (default ~A) *"
				default)))
      (setq *default-phone-db-file* file)
      (read-phone-file file)
      (setf (send master-phone-list :phone-list) *phone-list*)
      (send master-phone-list :refresh :complete-redisplay)
      (setf (send query-phone-list :phone-list) (send query :query))
      (update-phone-list-window nil query-phone-list t)
      (send (send self :selected-phone-record) :set-person-rec nil)
      (send (send self :selected-phone-record) :refresh)
      (format t "3~&Finished reading phone db from file ~A.~%*" (truename file))))


(def-phone-db-command 4(:save-phone-db "2Save phone db*" "2Save current phone db to a file*"*) ()
  (let* ((default *default-phone-db-file*)
	 (file (prompt-and-read (list :PATHNAME :DEFAULTS default) "3~&Save db to what file? (default ~A) *"
				default)))
      (setq *default-phone-db-file* file)
      (let* ((truename (write-phone-file file)))
	(format t "3~&Saved phone db to file ~A.~%*" truename))))

(def-phone-db-command 4(:add-an-entry "2Add an Entry*" "2Add a new entry to the database.*")* ()
  (let* ((new-person (make-person :name (make-name :first "" :last "")))
	 (selected (send self :selected-phone-record)))
    (setf (send selected :person-rec) new-person)
    (send self :edit-name)
    (push new-person *phone-list*)
    (setq *phone-list* (sort *phone-list* 'phone-list<))
    (send (send self :master-phone-list) :set-phone-list *phone-list*)
    (update-phone-list-window new-person (send self :master-phone-list))
    (send selected :force-kbd-input `(:execute ,#'(lambda (w) (send w :edit-menu)) ,self))))


(def-phone-db-command 4(:page-up-cmd "2Page up*" "2Display the next page up in the the nearest scroll window.*"*
				    (#\meta-v #\c-up-arrow #\rubout)) ()
  (let* ((indicated-scroll-window (cond ((< tv:mouse-x (tv:sheet-width master-phone-list)) master-phone-list)
					(t query-phone-list)))
	 (top-line-number (send indicated-scroll-window :scroll-position)))
    (when (plusp top-line-number)
      (send indicated-scroll-window :scroll-relative :top :bottom))))


(def-phone-db-command 4(:page-down-cmd "2Page down*" "2Display the next page down in the nearest scroll window.*"*
				      (#\control-v #\c-down-arrow #\space)) ()
  (let* ((indicated-scroll-window (cond ((< tv:mouse-x (tv:sheet-width master-phone-list)) master-phone-list)
					(t query-phone-list))))
    (multiple-value-bind (top-line-number total-lines pixels-per-line lines-shown)
			 (send indicated-scroll-window :scroll-position)
      (declare (ignore top-line-number total-lines))
      (unless (< (* pixels-per-line (+ 2 lines-shown)) (tv:sheet-inside-height indicated-scroll-window))
	(send indicated-scroll-window :scroll-relative :bottom :top)))))


(def-phone-db-command (:4refresh-phone-db* "2Refresh*" "2Redisplay everything.4"** 4(#\Control-L #\Clear-Screen)*) ()
  (send self :refresh))
  
(def-phone-db-command (:4quit-phone-db* "2Quit*" "2Quit and bury this window.4"** 4(#\End)*) ()
  (w:deselect-and-maybe-bury-window self))

(let* ((large-p t))
  (def-phone-db-command (:4other-fonts* "2Use Other Fonts*" "2Toggle between a large and a small font set.4"**) ()
    (if (setq large-p (not large-p))
	(phone-db-default-fonts)
	(phone-db-small-fonts))
    (dolist (person (send master-phone-list :phone-list))
      (remf (person-plist person) :elided-display-items)
      (remf (person-plist person) :expanded-display-items))
    (send self :refresh)))

(def-phone-db-command (:4other-config* "2Change Configuration*" 4"2Switch to another window layout.*"*) ()
  (let* ((config (w:menu-choose (mapcar #'car *phone-db-constraints-list*) :label "2Configuration:*" :columns 1
				:default-item *phone-db-4default-configuration**)))
    (when config (send self :set-configuration config))
    (send self :refresh)))



(build-command-table '*phone-db-command-table* 'phone-db-frame
  '(:query-company
    :query-name
    :query-area-code
    :query-phone-prefix
    :query-phone-extension
    :query-reset
    :read-phone-db
    :save-phone-db
    :page-down-cmd
    :page-up-cmd
    :refresh-phone-db
    :quit-phone-db
    :add-an-entry
    :other-fonts
    :other-config
    ))

(build-menu '*phone-db-command-menu* 'phone-db-frame
  :item-list-order
  '("3                      *"
    :read-phone-db
    :save-phone-db
    :add-an-entry
    :other-fonts
    :other-config
    :quit-phone-db
    )
  :default-item-options '(:font fonts:hl12))


(defun phone-listing-select (phone-rec phone-list-pane)
  (let* ((selected-rec-win (send (send phone-list-pane :superior) :selected-phone-record)))
    (setf (send selected-rec-win :person-rec) phone-rec)
    (send selected-rec-win :refresh :complete-redisplay)))

(defun phone-listing-4expand* (phone-rec phone-list-pane)
  (pushnew phone-rec (send phone-list-pane :expanded-listings))
  (update-phone-list-window phone-rec phone-list-pane))

(defun phone-listing-4elide* (phone-rec phone-list-pane)
  (setf (send phone-list-pane :expanded-listings) (delete phone-rec (send phone-list-pane :expanded-listings) :test #'eq))
  (update-phone-list-window phone-rec phone-list-pane))


(defun mouse-dial (phone pane)
  (process-run-function "Dialer"
			#'(lambda (p *terminal-io*) (dial p))
			phone
			(send (send pane :superior) :get-pane 'typein)))

(defun 4mouse-mail *(user pane)
  (when (person-p user) (setq user (pretty-print-net-address user)))
  (process-run-function "3M*a3iler*"
			#'(lambda (u *terminal-io*) 
			    (format t "3~&Initializing mail buffer.~%*")
			    (zwei:mail u))
			user
			(send (send pane :superior) :get-pane 'typein)))


(defun 4self-address *()
  "2Looks up the logged-in user in the database, and returns a string of his/her return address.*"
  (when (or (null fs:user-personal-name-first-name-first)
	    (string= "" fs:user-personal-name-first-name-first))
    (return-from SELF-ADDRESS nil))
  (let* ((space-1 (position #\Space fs:user-personal-name-first-name-first))
	 (space-2 (position #\Space fs:user-personal-name-first-name-first :from-end t))
	 (first (string-left-trim "3 *" (subseq fs:user-personal-name-first-name-first 0 space-1)))
	 (last (string-right-trim "3 *" (subseq fs:user-personal-name-first-name-first (1+ space-2))))
	 (self (dolist (phone *phone-list*)
		 (let* ((name (person-name phone)))
		   (when (and name
			      (string-equal first (name-first (person-name phone)))
			      (string-equal last (name-last (person-name phone))))
		     (return phone)))))
	 (addr (and self (car (person-addresses self)))))
    (when addr
      (with-output-to-string (stream)
	(format stream "3~A~%*" fs:user-personal-name-first-name-first)
	(unless (string= "" (address-street1 addr)) (format stream "3~A~%*" (address-street1 addr)))
	(unless (string= "" (address-street2 addr)) (format stream "3~A~%*" (address-street2 addr)))
	(if (zerop (or (address-zip addr) 0))
	    (format stream "3~A, ~A*" (address-city addr) (address-state addr))
	    (format stream "3~A, ~A@ @ ~5,'0D*" (address-city addr) (address-state addr) (address-zip addr)))))))



(defun 4scribe-letter-buffer *(to-name address)
  (let ((pathname (make-pathname :name (if (stringp to-name)
					   (string-append (substitute #\- #\Space to-name) "3-LETTER*")
					   (format nil "3~A-~A-LETTER*" (name-first to-name) (name-last to-name)))
				 :type "3MSS*" :version :NEWEST
				 :defaults (user-homedir-pathname)))
	(buffer (zwei:create-one-buffer-to-go)))
    (zwei:set-buffer-pathname pathname buffer)
    (send buffer :set-major-mode 'ZWEI:TEXT-MODE)
    
    (zwei:with-bp (bp (zwei:interval-first-bp buffer) :moves)
      (dolist (string (list "3-*- Mode:Text -*-*"
			    "3@MAKE(LETTER)*" ""
			    (or (self-address) "<< return address not found >>")
			    ""
			    "3@BEGIN(ADDRESS)*"
			    "3@VALUE(DATE)*" ""
			    (pretty-print-person-name to-name)
			    (and (address-street1 address) (string/= (address-street1 address) "") (address-street1 address))
			    (and (address-street2 address) (string/= (address-street2 address) "") (address-street2 address))
			    (if (zerop (or (address-zip address) 0))
				(format nil "3~A, ~A*" (address-city address) (address-state address))
				(format nil "3~A, ~A@ @ ~5,'0D*"
					(address-city address) (address-state address) (address-zip address)))
			    "3@END(ADDRESS)*" ""
			    "3@BEGIN(BODY)*"
			    (format nil "3@GREETING(Dear ~A:)~%*" (pretty-print-person-name to-name :print-last nil))
			    "3@END(BODY)*"
			    "3@BEGIN(SIGNATURE)*"
			    (format nil "3Sincerely,~4%~A*" fs:user-personal-name-first-name-first)
			    "3@END(SIGNATURE)*"
			    ))
	(zwei:insert-moving bp (string string))
	(zwei:insert-moving bp #\Newline)
	))
    
    (let* ((sheet (zwei:find-or-create-idle-zmacs-window)))
      (send sheet :select)
      (send sheet :force-kbd-input `(:execute ,#'(lambda (buffer) (send buffer :select)) ,buffer))
      (tv:await-window-exposure)))
  nil)


(defun 4mouse-address *(to-name address pane)
  (process-run-function "3M*a3iler*"
			#'(lambda (to-name address *terminal-io*) (scribe-letter-buffer to-name address))
			to-name
			address
			(send (send pane :superior) :get-pane 'typein)))


(defun scroll-parse-phone-rec (phone-list-pane phone-list)
  (let ((scroll-list (list nil)))
    (dolist (phone-rec phone-list)
      (let* ((plist (person-plist phone-rec))
	     (elided (not (member phone-rec (send phone-list-pane :expanded-listings) :test #'eq)))
	     (prop (if elided :elided-display-items :expanded-display-items))
	     (items (getf plist prop)))
	(unless items
	  (setq items (scroll-parse-one-phone-rec phone-list-pane phone-rec))
	  (setf (getf (person-plist phone-rec) prop) items))
	(setq scroll-list (append items scroll-list))))
    (nreverse scroll-list)))

(defun 4phone-number-string *(phone &optional always-use-area-code)
  (let* ((ac (phone-area-code phone))
	 (pr (phone-prefix phone))
	 (ex (phone-extension phone)))
    (if (and (not always-use-area-code) (eql ac *my-area-code*))
	(format nil "3      ~D-~4,'0D*" pr ex)
	(format nil "3(~D) ~D-~4,'0D*" ac pr ex))))


(defun 4update-phone-list-window *(ignore phone-list-pane &optional hard-p)
  (let* ((new-list (scroll-parse-phone-rec phone-list-pane (send phone-list-pane :phone-list))))
    (if hard-p
	(send phone-list-pane :set-display-item new-list)
	(send phone-list-pane :alter-display-item new-list))))


(defmethod 4(basic-phone-list-window :alter-display-item)* (new-display-item)
  (setq display-item new-display-item
	top-item nil
	;target-top-item 0
	)
  (send self :redisplay t :force))


(defun 4scroll-parse-one-phone-rec *(phone-list-pane phone-rec)
  (let* ((scroll-list '())
	 (font			4*phone-db-default-font*)*
	 (4name*-font		4*phone-db-name-font**)
	 (postal-address-font	4*phone-db-*postal-address4-font**)
	 (phoneext-font		4*phone-db-*phone-extension4-font**)
	 (addrloc-font		4*phone-db-*company4-font**)
	 (net-address-font	4*phone-db-*net-address4-font**)
	 (number-font		4*phone-db-*phone-number4-font**)

	 (wide (> (tv:sheet-width phone-list-pane) 250))  ;1 This evil hack partially due to scrolling windows not dealing with fonts.*
	 (elided  (not (member phone-rec (send phone-list-pane :expanded-listings) :test #'eq)))
	 (documentation (make-array 100 :element-type 'string-char :fill-pointer 0))
	 )
    (labels ((string-in-font (string font)
	       "2Set the window's font, and return STRING.*"
	       (send self :set-current-font font t)
	       string)
	     
	     (item (string &optional width (font font))
	       "2Returns a scroll-item list to display the string in the font specified.*"
	       (if width
		   `(:function ,#'string-in-font (,string ,font) ,width)
		   `(:function ,#'string-in-font (,string ,font))))
	     
	     (multi-mouse-item (string left middle right &optional ldoc mdoc rdoc width (font font) longdoc)
	       "2Returns a scroll-item list to display the string in the font specified, and use EVAL for mouse-clicks.*"
	       (unless left   (setq left '(beep)))
	       (unless middle (setq middle '(beep)))
	       (unless right  (setq right '(tv:mouse-call-system-menu)
				    rdoc "3System Menu*"))
	       `(:mouse (nil :buttons ((nil :eval ,left) (nil :eval ,middle) (nil :eval ,right))
			     :documentation (,@(and ldoc (list :mouse-L-1 ldoc))
					     ,@(and mdoc (list :mouse-m-1 mdoc))
					     ,@(and rdoc (list :mouse-r-1 rdoc))
					     ,@(and longdoc (list :documentation longdoc))
					     ))
			,@(item string width font)))
	     
	     (mouse-item (string eval &optional doc width (font font) longdoc)
	       "2Returns a scroll-item list to display the string in the font specified, and use EVAL for mouse-clicks.*"
	       (multi-mouse-item string eval nil nil doc nil nil width font longdoc))
	     
	     (blank (n &optional font)
	       "2Insert N characters of blankspace.  Use this instead of '*(:string 2\*"2\*" 4)2 - font lossage.*"
	       (item "" n (or font net-address-font)))
	     )
1        *;1;*
      ;1; 5Name and Company**
      ;5;*
      (let* ((name (and (person-name phone-rec) (pretty-print-person-name (person-name phone-rec))))
	     (comp (person-company phone-rec))
	     (phone (car (person-phones phone-rec))))
	(when (equal name "") (setq name nil))
	(when (equal comp "") (setq comp nil))
	(let* ((namestring (cond ((and name comp) (format nil "3~A - ~A*" name comp))
				 (name)
				 (comp)
				 (t ""))))
	  (format documentation "3~A *" namestring)
	  (push (tv:scroll-parse-item
		  (multi-mouse-item (string-append namestring #\Space)
				    `(phone-listing-select ,phone-rec self)		;1 left*
				    (if elided
					`(phone-listing-expand ,phone-rec self)		;1 middle*
					`(phone-listing-elide ,phone-rec self))
				    nil							;1 right*
				3    *"2Select this record*"
				3    *(if elided "2Expand this record*" "2Elide this record*")
				     nil
				     (when phone 25)
				     name-font documentation)
		  (when (and elided phone)
		    (mouse-item (phone-number-string phone)
				`(mouse-dial ,phone self)
				"2Dial this number*"
				15 number-font documentation))
		  (when (and elided phone (phone-ext phone))
		3    *(item (format nil "3(*~D3)*" (phone-ext phone))
			   nil phoneext-font))
		  )
		scroll-list)
	  ))
      ;1;*
      ;1; 5Phone Numbers**
      ;1;*
      (dolist (phone (person-phones phone-rec))
	(format documentation "3   ~A: ~A *" (phone-where phone) (phone-number-string phone t))
	(unless elided
	  (push (tv:scroll-parse-item
		  (blank 5 font)
		  (item (phone-where phone) (if wide 24 20) font)
		3  *(mouse-item (phone-number-string phone)
			       `(mouse-dial ,phone self)
			       "2Dial this number*"
			       15 number-font documentation)
		   (when (phone-ext phone)
		3     *(item (format nil "3(~D)*" (phone-ext phone))
			    nil phoneext-font))
		   )
		scroll-list)))
      
      (unless elided
	;1;*
	;1; 5Address**
	;1;*
	(dolist (address (person-addresses phone-rec))
	  ;1;*
	  ;1; 5Location**
	  (push (tv:scroll-parse-item
		  (blank 3)
		  (mouse-item (address-where address)
			      `(mouse-address ,(person-name phone-rec) ,address self)
			      "3Enter a ZMACS buffer with a letter template.*"
			      15 addrloc-font documentation))
		scroll-list)
	  ;1;*
	  ;1; 5Street**
	  (when (string/= (address-street1 address) "")
	    (push (tv:scroll-parse-item
		    (blank 8)
		    (item (address-street1 address) nil postal-address-font))
		  scroll-list))
	  (when (string/= (address-street2 address) "")
	    (push (tv:scroll-parse-item
		    (blank 8)
		    (item (address-street2 address) nil postal-address-font))
		  scroll-list))
	  ;1;*
	  ;1; 5City, State, Zip**
	  (push (tv:scroll-parse-item
		  (blank 8)
		  (item (if (zerop (or (address-zip address) 0))
			    (format nil "~3A, ~A*" (or (address-city address) "") (or (address-state address) ""))
			    (format nil "~3A, ~A  ~5,'0D*"
				    (or (address-city address) "") (or (address-state address) "")
				    (address-zip address)))
			nil postal-address-font))
		scroll-list))
	;1;*
	;1; 5Network Address**
	;1;*
	(unless (string= (person-net phone-rec) "")
	  (push (tv:scroll-parse-item
		  (blank 2)
		  (item "net:" 7)
		  (mouse-item (person-net phone-rec)
			      `(mouse-mail ,phone-rec self) "3Enter the Send-Mail program*"
			      nil net-address-font documentation))
		scroll-list))
	)
      ;1;*
      ;1; 5Notes...**
      ;1;*
      (unless (string= (person-note phone-rec) "")
	(format documentation "3  (~A)*" (person-note phone-rec))
	(unless elided
	  (push (tv:scroll-parse-item
		  (blank 2)
		  (item (string-append #\(
			  (let* ((note (person-note phone-rec))
				 (nl (position #\Newline note)))
			    (setq nl (min (or nl (length note)) 30))
			    (if (< nl (length note))
				(string-append (subseq (person-note phone-rec) 0 nl) "3...*")
				(person-note phone-rec)))
			  #\))
			nil font))
		scroll-list)))
      ;1;*
      ;1; 5Extra Space.**
      ;1;*
      (unless elided (push (tv:scroll-parse-item (blank 0)) scroll-list))
      )
    
    (values scroll-list elided)))



(defun 4dump-phone-with-zmacs-fonts *(person-rec stream font-map)
  (flet ((font (font)
	   (let* ((n (or (position (tv:font-evaluate font) font-map) 0)))
	     (princ #\Epsilon stream)
	     (princ (make-char (+ (char-code #\0) n)) stream)))
	 (font-pop ()
	   (princ #\Epsilon stream) (princ #\* stream)))
    (let* ((pname (and (person-name person-rec) (pretty-print-person-name (person-name person-rec))))
	   (pcomp (person-company person-rec)))
      (when (string= pname "") (setq pname nil))
      (when (string= pcomp "") (setq pcomp nil))
      (when pname
	(font *phone-db-name-font*)
	(princ pname stream) (princ #\Space stream)
	(font-pop))
      (when pcomp
	(font *phone-db-company-font*)
	(when (and pname pcomp) (princ "3- *" stream))
	(princ pcomp stream)
	(font-pop))
      (when (or pname pcomp) (terpri stream))

      (dolist (phone (person-phones person-rec))
	(format stream "3~4t*")
	(font *phone-db-name-font*)
	(princ (phone-where phone) stream)
	(font *phone-db-phone-number-font*)
	(format stream "3~18t~C~A *" #\Tab (phone-number-string phone t))
	(when (phone-ext phone)
	  (font *phone-db-phone-extension-font*)
	  (format stream "3(~A)*" (phone-ext phone))
	  (font-pop))
	(font-pop) (font-pop)
	(terpri stream))
      
      (dolist (address (person-addresses person-rec))
	(format stream "3~4t*")
	(font *phone-db-name-font*)
	(princ (address-where address) stream)
	(font *phone-db-postal-address-font*)
	(when (string/= (address-street1 address) "")
	  (format stream "3~18t~C~A*" #\Tab (address-street1 address))
	  (terpri stream))
	(when (string/= (address-street2 address) "")
	  (format stream "3~18t~C~A*" #\Tab (address-street2 address))
	  (terpri stream))
	(if (zerop (or (address-zip address) 0))
	    (format stream "3~18t~C~A, ~A*" #\Tab (or (address-city address) "") (or (address-state address) ""))
	    (format stream "3~18t~C~A, ~A  ~5,'0D*" #\Tab (or (address-city address) "") (or (address-state address) "")
		    (address-zip address)))
	(font-pop) (font-pop)
	(terpri stream))
      (unless (string= (person-net person-rec) "")
	(format stream "3~4t*")
	(font *phone-db-postal-address-font*)
	(princ "3Net:  *" stream)
	(princ #\Tab stream)
	(font *phone-db-net-address-font*)
	(princ (person-net person-rec) stream)
	(font-pop) (font-pop)
	(terpri stream))
      (unless (string= (person-note person-rec) "")
	(format stream "3~4t*")
	(font *phone-db-postal-address-font*)
	(princ "3Notes:  *" stream)
	(font *phone-db-default-font*)
	(princ #\Tab stream)
	(princ (person-note person-rec) stream)
	(font-pop) (font-pop) (terpri stream))
      )))

(defun 4dump-all-phonebook-entries-with-zmacs-fonts *(persons stream)
  (cond ((or (pathnamep stream) (stringp stream))
	 (with-open-file (f stream :direction :output)
	   (4dump-all-phonebook-entries-with-zmacs-fonts* persons f)))
	((typep stream 'zwei:interval)
	 (zwei:delete-interval stream)
	 (with-open-stream (f (zwei:interval-stream stream nil nil t))
	   (4dump-all-phonebook-entries-with-zmacs-fonts* persons f))
	 (let* ((props (fs:read-attribute-list stream (zwei:interval-stream stream))))
	   (send stream :set-attribute :FONTS (getf props :fonts))
	   (zwei:set-buffer-fonts stream (getf props :fonts))))
	(t
	 (let* ((fonts (list 4*phone-db-default-font** 4*phone-db-name-font** 4*phone-db-postal-address-font** 
			     4*phone-db-phone-extension-font** 4*phone-db-company-font** 4*phone-db-net-address-font**
			     4*phone-db-phone-number-font**)))
	   (format stream "3-*- Mode:Text; Fonts:~A -*-~2%*"
		   (mapcar #'(lambda (x) (tv:font-name (tv:font-evaluate x))) fonts))
	   (dolist (person persons)
	     (4dump-*phone4-with-zmacs-fonts* person stream fonts)
	     (terpri stream)))))
  t)


(defun 4phone-db* ()
  "2Select a new or old window to edit or search a phone book.*"
  (tv:select-or-create-window-of-flavor 'PHONE-DB-FRAME)
  nil)


(tv:remove-system-key #\#)  ;1In case one already exists.*
(tv:delete-from-system-menu-column :programs "3Phone DB*")

(tv:add-system-key #\# 'phone-db-frame "2Edit or search a phone book.*" t nil "3Phone DB*")

(tv:add-to-system-menu-column :PROGRAMS "3Phone DB*" '(phone-db)
 '(:documentation "2Select a new or old window to edit or search a phone book.*")
 nil)

(setq tv:default-window-types-item-list
      (delete "3Phone DB*" tv:default-window-types-item-list :test #'string-equal :key #'car))

(tv:add-window-type "3Phone DB*" 'phone-db-frame "2A phonebook database program.*")



;1;;; Editing.*

(defmethod 4(phone-db-frame :edit-refresh)* (person)
  (when person
    (remf (person-plist person) :expanded-display-items)
    (remf (person-plist person) :elided-display-items)
    (send (send self :selected-phone-record) :refresh)))


(defun prompt-for-phone-number4 *(&optional phone-rec)
  (let* ((string (prompt-with-default "3Phone number:*" (if phone-rec
							    (format nil "3(~3D) ~3D-~4,'0D~A*"
								    (phone-area-code phone-rec)
								    (phone-prefix phone-rec)
								    (phone-extension phone-rec)
								    (if (phone-ext phone-rec)
									(format nil "3 x~A*" (phone-ext phone-rec))
									""))
							    "")))
	 n1 n2 n3 n4 pos)
    (setq string (nsubstitute #\Space #\( string))
    (setq string (nsubstitute #\Space #\) string))
    (setq string (nsubstitute #\Space #\- string))
    (setq string (nsubstitute #\Space #\x string :test #'char-equal))
    (multiple-value-setq (n1 pos) (parse-integer string :junk-allowed t))
    (when n1 (multiple-value-setq (n2 pos) (parse-integer string :junk-allowed t :start pos)))
    (when n2 (multiple-value-setq (n3 pos) (parse-integer string :junk-allowed t :start pos)))
    (when n3 (multiple-value-setq (n4 pos) (parse-integer string :junk-allowed t :start pos)))
    
    (let* (area-code prefix suffix
	   (extension nil))
      (cond (n4 (setq area-code n1 prefix n2 suffix n3 extension n4))
	    (n3 (setq area-code n1 prefix n2 suffix n3))
	    (n2 (setq area-code (when phone-rec (phone-area-code phone-rec))
		      prefix n1 suffix n2))
	    (n1 (beep)
		(format t "3~&Too few numbers!*")
		(return-from PROMPT-FOR-PHONE-NUMBER (prompt-for-phone-number phone-rec)))
	    (t (when phone-rec
		 (setq prefix (phone-prefix phone-rec)
		       suffix (phone-extension phone-rec)))))
      (values area-code prefix suffix extension))))


(defmethod 4(phone-db-frame :edit-phone)* ()
  (let* ((person (send (send self :selected-phone-record) :person-rec))
	 (phones (person-phones person))
	 (menu (mapcar #'(lambda (x)
			   (list (format-phone x) :value x :font fonts:hl12))
		       phones)))
    (case (w:menu-choose '(("3Add a Phone Number*" :value :add :font fonts:hl12)
			   ("3Edit a Phone Number*" :value :edit :font fonts:hl12)
			   ("3Delete a Phone Number*" :value :delete :font fonts:hl12)))
      
      (:ADD (send *query-io* :clear-screen)
	    (let* ((location (prompt-and-read :string-trim "3~&Location: *")))
	      (multiple-value-bind (area-code prefix suffix extension) (prompt-for-phone-number)
		(let* ((new (make-phone :where location
					:area-code (or area-code *my-area-code*)
					:prefix prefix :extension suffix :ext extension)))
		  (setf (person-phones person)
			(append (person-phones person) (list new)))
		  (send self :edit-refresh person)))))
      
      (:EDIT (let* ((which (w:menu-choose menu :label '(:string "3Edit which phone number?*" :font FONTS:HL12B))))
	       (when which
		 (send *query-io* :clear-screen)
		 (let* ((location (prompt-with-default "3Location:*" (phone-where which))))
		   (unless (string= "" location) (setf (phone-where which) location)))
		 (multiple-value-bind (area-code prefix suffix extension) (prompt-for-phone-number which)
		   (setf (phone-area-code which) (or area-code *my-area-code*)
			 (phone-prefix which) prefix
			 (phone-extension which) suffix
			 (phone-ext which) extension))
		 (send self :edit-refresh person))))
      
      (:DELETE (let* ((which (w:menu-choose menu :label '(:string "3Delete which phone number?*" :font FONTS:HL12B))))
		 (when which
		   (setf (person-phones person) (delete which phones))
		   (send self :edit-refresh person)
		   ))))))


(defmethod 4(phone-db-frame :edit-company)* ()
  (let* ((person (send (send self :selected-phone-record) :person-rec)))
    (send *query-io* :clear-screen)
    (setf (person-company person) (prompt-with-default "3Company:*" (person-company person)))
    (setq *phone-list* (sort *phone-list* 'phone-list<))
    (send (send self :master-phone-list) :set-phone-list *phone-list*)
    (update-phone-list-window person (send self :master-phone-list))
    (send self :edit-refresh person)))



(defmethod 4(phone-db-frame :edit-name)* ()
  (let* ((person (send (send self :selected-phone-record) :person-rec)))
    (send *query-io* :clear-screen)
    (let* ((nn (person-name person))
	   (first (prompt-with-default "3First Name:*" (name-first nn)))
	   (last  (prompt-with-default "3Last Name:*" (name-last nn)))
	   (title (prompt-with-default "3Title:*" (name-title nn))))
      (setf (name-first nn) first)
      (setf (name-last nn) last)
      (setf (name-title nn) title)
      (when (and (zerop (length first)) (zerop (length last)))
	(setf (person-name person) nil)))
    (setq *phone-list* (sort *phone-list* 'phone-list<))
    (send (send self :master-phone-list) :set-phone-list *phone-list*)
    (update-phone-list-window person (send self :master-phone-list))
    (send self :edit-refresh person)))

(defun 4prompt-for-address *(&optional default-address)
  (values (prompt-with-default "3Location:*" (if default-address (address-where default-address) ""))
	  (prompt-with-default "3Street:*" (if default-address (address-street1 default-address) ""))
	  (prompt-with-default "3Street, line 2:*" (if default-address (address-street2 default-address) ""))
	  (prompt-with-default "3City:*" (if default-address (address-city default-address) ""))
	  (prompt-with-default "3State:*" (if default-address (address-state default-address) ""))
	  (prompt-with-default "3Zip Code:*" (when default-address (address-zip default-address))
			       '(:number :or-nil t)3 *"3~:[~;~:*~5,'0D~]*")
	  ))


(defmethod 4(phone-db-frame :edit-address)* ()
  (let* ((person (send (send self :selected-phone-record) :person-rec))
	 (addresses (person-addresses person))
	 (menu (mapcar #'(lambda (address)
			   (list (if (zerop (or (address-zip address) 0))
				     (format nil "3 ~A:  *~3A, ~A*"
					     (address-where address)
					     (or (address-city address) "") (or (address-state address) ""))
				     (format nil "3 ~A:  *~3A, ~A  ~5,'0D*"
					     (address-where address)
					     (or (address-city address) "") (or (address-state address) "")
					     (address-zip address)))
				 :value address :font fonts:hl12))
		       addresses)))
    (case (w:menu-choose '(("3Add an Address*" :value :add :font fonts:hl12)
			   ("3Edit an Address*" :value :edit :font fonts:hl12)
			   ("3Delete an Address*" :value :delete :font fonts:hl12)))
      
      (:ADD (send *query-io* :clear-screen)
	    (multiple-value-bind (location s1 s2 city state zip) (prompt-for-address)
	      (let* ((new (make-address :where location :street1 s1 :street2 s2 :city city :state state :zip zip)))
		(setf (person-addresses person)
		      (append (person-addresses person) (list new)))
		(send self :edit-refresh person))))
      
      (:EDIT (let* ((which (w:menu-choose menu :label '(:string "3Edit which Address?*" :font FONTS:HL12B))))
	       (when which
		 (send *query-io* :clear-screen)
		 (multiple-value-bind (location s1 s2 city state zip) (prompt-for-address which)
		   (setf (address-where which) location
			 (address-street1 which) s1
			 (address-street2 which) s2
			 (address-city which) city
			 (address-state which) state
			 (address-zip which) zip))
		 (send self :edit-refresh person))))
      
      (:DELETE (let* ((which (w:menu-choose menu :label '(:string "3Delete which Address?*" :font FONTS:HL12B))))
		 (when which
		   (setf (person-addresses person) (delete which addresses))
		   (send self :edit-refresh person)
		   ))))))


(defmethod 4(phone-db-frame :delete-this-person)* ()
  (let* ((person (send (send self :selected-phone-record) :person-rec))
	 (pname (if (person-name person)
		   (pretty-print-person-name (person-name person))
		   (person-company person))))
    (when (w:menu-choose '(("" :no-select t) ("No" :value nil :font fonts:hl12b)
			   ("Yes" :value t :font fonts:hl12b) ("" :no-select t))
			 :columns 1 :item-alignment :center
			 :label `(:string ,(format nil "3~% Permanently delete the phonebook entry for ~A? ~%*" pname)
				  :font ,fonts:hl12b
				  :color ,*default-menu-label-foreground* :background ,*default-menu-label-background*))
      (setq *phone-list* (delete person *phone-list* :test #'eq))
      (setf (send (send self :selected-phone-record) :person-rec) nil)
      (send self :edit-refresh person)
      (send (send self :master-phone-list) :refresh)
      (send (send self :query-phone-list) :refresh)))
  nil)


(defmethod 4(phone-db-frame :edit-menu)* ()
  (if (send (send self :selected-phone-record) :person-rec)
      (w:menu-choose (mapcar #'(lambda (x)
				 `(,(string-capitalize (substitute #\Space #\- (string x)))
				   :eval (send ,self ,x)
				   :font fonts:hl12))
			     '(:edit-name :edit-company :edit-phone :edit-address :edit-net :edit-notes :delete-this-person))
		     :label '(:string "3Commands:*" :font hl12b)
		     :columns 1)
      (beep)))


(defmethod 4(phone-db-frame :edit-net)* ()
  (send *query-io* :clear-screen)
  (let* ((person (send (send self :selected-phone-record) :person-rec)))
    (setf (person-net person) (prompt-with-default "3Network Address:*" (person-net person)))
    (send self :edit-refresh person)))


;(defmethod 4(phone-db-frame :edit-notes)* ()
;  (send *query-io* :clear-screen)
;  (let* ((person (send (send self :selected-phone-record) :person-rec)))
;    (setf (person-note person) (prompt-with-default "3Notes:*" (person-note person)))
;    (send self :edit-refresh person)))


(defmethod 4(phone-db-frame :edit-notes)* ()
  (send *query-io* :clear-screen)
  (lexpr-send editor-window :set-edges (multiple-value-list (send (send self :get-pane 'typein) :edges)))
  (let* ((person (send (send self :selected-phone-record) :person-rec))
	 (prior-select (send self :master-phone-list)))
    (send editor-window :set-interval-string (string-right-trim '(#\Space #\Tab #\Newline) (person-note person)))
    (catch 'ZWEI:ABORT-STANDALONE-EDIT
      (send editor-window :select)
      (send editor-window :edit)
      (setf (person-note person) (send editor-window :interval-string)))
    (send editor-window :deactivate)
    (send prior-select :select)
    (send self :edit-refresh person)
    ))


;1;; A quick Zmacs interface.*

(defun 4phone-db-lookup-net-address *(address)
  (unless (typep address 'mail:address) (setq address (mail:parse-address address)))
  (or (let* ((name (or (send address :send-if-handles :name)
		       (string-trim '(#\Space #\Tab #\Newline #\( #\) #\[ #\])
				    (or (send address :send-if-handles :comments) ""))
		       ))
	     (first-space (and name (position #\Space name :test #'char=)))
	     (last-space  (and first-space (position #\Space name :test #'char= :from-end t :start first-space)))
	     (f-n (and first-space (subseq name 0 first-space)))
	     (l-n (and last-space  (subseq name (1+ last-space)))))
	(when (and f-n l-n) (setq name (string-append l-n #\Space f-n)))
	(or (and name (string/= "" name) (tv:phone-search :name name))
	    (and l-n  (string/= "" l-n)  (tv:phone-search :name l-n))))
      
      (let* ((addr (send address :send-if-handles :basic-string))
	     (local (car (send address :send-if-handles :local-part)))
	     (bang (and local (position #\! local :test #'char= :from-end t))))
	(when bang (setq bang (subseq local (1+ bang))))
	(or (and addr (tv:phone-search :net-address addr))
	    (and local (or (tv:phone-search :net-address local)
			   (tv:phone-search :name local)))
	    (and bang  (or (tv:phone-search :net-address bang)
			   (tv:phone-search :name bang))))
	)))

(defun 4phone-db-describe-address *(address)
  (let* ((persons (4phone-db-lookup-net-address* address)))
    (if persons
	(dolist (person persons) (format t "3~2&~A*" (format-person person)))
	(format t "3~2&Can't find ~A in the Phone DB.*" address)
	)))

ZWEI:
(defcom 4com-who-from *"2Look up the person listed in the From: line in the phone database.*" ()
  (let* ((i *interval*))
    (when (typep i 'zwei:mail-summary-buffer) (setq i (send i :sequence-buffer)))
    (unless (typep i 'zwei:mail-file-buffer)
      (barf "2This command only makes sense in mail buffers.*"))
    (let* ((msg (aref (send i :message-array) (send i :current-message-index))))
      (assure-message-parsed msg t)
      (let* ((froms (getf (or (get-message-header msg :from) (get-message-header msg :sender))
			  :address-list)))
	(unless froms (barf "2No From: or Sender: fields!*"))
	;1; If the sender of this message is the logged-in user, then look at the recipients instead.*
	(when (string-equal (or zwei:*send-mail-signature-string* "3.*")
			    (or (send (car froms) :send-if-handles :string-for-message) ""))
	  (setq froms (getf (or (get-message-header msg :to) (get-message-header msg :cc))
			    :address-list))
	  (unless froms (barf "2No To: or CC: fields!*")))
	(dolist (from froms)
	  (tv:phone-db-describe-address from)))))
  DIS-NONE)


ZWEI:
(defcom 4com-annotate-sender *"2Add some text to the sender's NOTES entry in the Phone DB.*" ()
  (let* ((i *interval*))
    (when (typep i 'zwei:mail-summary-buffer) (setq i (send i :sequence-buffer)))
    (unless (typep i 'zwei:mail-file-buffer)
      (barf "2This command only makes sense in mail buffers.*"))
    (let* ((msg (aref (send i :message-array) (send i :current-message-index))))
      (assure-message-parsed msg t)
      (let* ((address (car (getf (or (get-message-header msg :from) (get-message-header msg :sender))
				 :address-list))))
	(unless address (barf "2No From: or Sender: fields!*"))
	;1; If the sender of this message is the logged-in user, then look at the recipients instead.*
	(when (string-equal (or zwei:*send-mail-signature-string* "3.*")
			    (or (send address :send-if-handles :string-for-message) ""))
	  (setq address (car (getf (or (get-message-header msg :to) (get-message-header msg :cc))
				   :address-list)))
	  (unless address (barf "2No To: or CC: fields!*")))
	TV:
	(let* ((person (car (4phone-db-lookup-net-address* zwei:address))))
	  (unless person
	    (unless (typep zwei:address 'mail:address) (setq zwei:address (mail:parse-address zwei:address)))
	    (let* ((name (or (send zwei:address :send-if-handles :name)
			     (string-trim '(#\Space #\Tab #\Newline #\( #\) #\[ #\])
				    (or (send zwei:address :send-if-handles :comments) ""))
			     ))
		   (first-space (and name (position #\Space name :test #'char=)))
		   (last-space  (and first-space (position #\Space name :test #'char= :from-end t :start first-space)))
		   (f-n (and first-space (subseq name 0 first-space)))
		   (l-n (and last-space  (subseq name (1+ last-space)))))
	      (and f-n (setq f-n (string-trim '(#\" #\( #\)) f-n)))
	      (and l-n (setq l-n (string-trim '(#\" #\( #\)) l-n)))
	      (setq person (make-person :name (make-name :first (or f-n name) :last (or l-n ""))
					:net (or (send zwei:address :send-if-handles :string-for-printing)
						 (princ-to-string zwei:address))
					))))
	  ;1; If this person existed but didn't have a net-address, add one.*
	  (when (or (null (person-net person)) (string= "" (person-net person)))
	    (setf (person-net person) (or (send zwei:address :send-if-handles :string-for-printing)
					  (princ-to-string zwei:address))))
	  (let* ((result (zwei:pop-up-edstring (person-note person) '(:mouse) nil 550 150
					       (format nil "2Edit the notes of3 ~A ~A* 3(*~A3)*.*"
						       (name-first (person-name person))
						       (name-last (person-name person))
						       zwei:address))))
	    (when result
	      (setf (person-note person) (string-right-trim '(#\Newline) result))
	      (pushnew person *phone-list* :test #'eq)
	      (setq *phone-list* (sort *phone-list* 'phone-list<))
	      (when (y-or-n-p "3~&Save Phone DB now? *")
		(let* ((default *default-phone-db-file*)
		       (file (prompt-and-read (list :PATHNAME :DEFAULTS default) "2~&Save db to what file? (default ~A) *"
					      default)))
		  (setq *default-phone-db-file* file)
		  (let* ((truename (write-phone-file file)))
		    (format t "2~&Saved phone db to file ~A.~%*" truename))))))
	  ))))
  DIS-NONE)

(zwei:set-comtab zwei:*read-mail-comtab*
		 '(#\Meta-A zwei:com-annotate-sender)
		 (zwei:make-command-alist '(zwei:com-annotate-sender zwei:com-who-from))
		 )


;1;; Use a graphic icon if we're running a desktop.*

(defvar 4*phone-db-icon**
	(make-array '(64 64) :element-type 'bit
	  :displaced-to
	  (make-array 128 :element-type '(unsigned-byte 32)
	    :initial-contents
	    '#(3 3221225472 1 2147483648 0 0 4294967280 268435455 3221258232 536870911 3221258232 536870911 2147549176
	       536870911 2147614712 536870911 131064 536870911 131064 536870911 131064 536870910 65528 536870910 65528
	       536870910 65528 536870908 65528 536870908 65528 536870904 65528 536870904 65528 536870904 131064 536870896
	       131064 536870896 262136 536870880 524280 536870880 262136 536870848 131064 536870848 268500984 536870848
	       604012536 536870784 587218936 536870784 1136664568 536870656 1139810296 536870656 2180792312 536870656
	       2181038072 536870400 16777208 536870401 2164260856 536869889 3229614072 536869891 3229614072 536868867
	       3766484984 536868871 3762290680 536868871 4030726136 536866831 4028628984 536866847 4162846712 536862751
	       4161798136 536862783 4228907000 536862783 4228907000 536854655 4261937144 536854655 4261937144 536838399
	       4278452216 536838399 4278452216 536805887 4286709752 536805887 4286709752 536806399 4290904056 536740863
	       4290904056 536741887 4293001208 536612863 4027711480 536615939 3221258224 268173312 2016 133955584 0 0 0 0
	       267911168 4088 268304384 16376 536862744 402915324 4294967280 268435455 0 0 1 2147483648 3 0)))
  "2Let your fingers do the walking.*")

2#+Comment*
(defvar 4*phone-db-icon**
	(make-array '(64 64) :element-type 'bit
	  :displaced-to
	  (make-array 128 :element-type '(unsigned-byte 32)
	    :initial-contents
	    '#(4294967295 4294967295 1 2147483648 1 2147483648 1 2147483648 1 2147483648 4294967041 2151677951 1431655809
	       2153076053 2863311553 2175445674 1431655793 2270516565 2864360121 2393550506 4294792541 2639618047 1433053869
	       2594876245 2864534869 2505399722 4293831341 2594880511 1431786837 2639615317 2863377069 2662001322 4294825301
	       2673205247 518829 3131830272 4294260057 3176552447 9900017 3086513280 2970943489 2952811789 3025600513
	       2952819789 37027841 2952812064 2962685953 2956752013 2970943489 2961134861 72810497 2965599296 2989817857
	       2978076205 2962685953 2978018445 18153473 2977977600 3025600513 2977985613 2989817857 2965394989 9895937
	       2959111296 4246011905 2955957567 72810497 2954392672 4264886273 2550945343 4294377473 2550560767 327681
	       2349027328 4294901761 2248376319 1431764993 2248373589 2863333377 2198039210 1431764993 2172876117 2863333377
	       2160290474 1431633921 2164151637 2863333377 2155637418 1431699457 2147497301 4294705153 2147491839 1
	       2147483648 4294967295 16777215 807473154 140510311 167772544 810061841 960048178 942812212 909388854
	       959982645 55 841279922 3321888768 167772192 3361736665 3321888768 3361736630 100663296 167772160 3523543695
	       3321888768 3321888768 3321888768 3388998167 3388997890 3388997700 3388997700 167772162 167772162 167772187
	       3388997634 3388997650 3388997634 3388997634)))
  "2A telephone.*")

(defmethod 4(phone-db-frame :make-icon)* ()
  (make-instance 'w:graphics-icon
		 :window-being-represented self
		 :picture *phone-db-icon*
		 :borders 1
		 :label (list :string w:name :font fonts:hl12b)
		 ))


;1;;; This is some conditional compilation noise - ignore it.*
(eval-when (eval compile)
  (setq *features* (delete :accelerators *features*)))


(compile-flavor-methods PHONE-DB-FRAME 
			SELECTED-PHONE-RECORD-WINDOW
			PHONE-QUERY-WINDOW
			PHONE-TYPEIN-WINDOW
			4PHONE-DB-*MAIN-MENU
			QUERY-PHONE-LIST-WINDOW
			MASTER-PHONE-LIST-WINDOW)
