;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:ZWEI; Vsp:0; Fonts:(CPTFONT HL12 TR12I COURIER ADOBE-COURIER14B HL12B CPTFONTBI) -*-

;1;; File "3NSA-FILTER*".*
;1;; Making the world just a little bit safer for peace and democracy.*
;1;;*
;1;; 5ChangeLog:**
;1;;*
;1;;   27 Feb 90*	1Jamie Zawinski*	1Created from a C program I found, author unknown.*
;1;;*   128 Mar 90*	1Jamie Zawinski *	1Added new command, Security Report Message for forwarding results.*
;1;;*

(defvar 4*security-keywords**
	'("2Security*" "2Intelligence*" "2LSD*" "2toxin*" "2Soviet*" "2USSR*" "2China*" "2Moscow*"
	  "2ABSCAM*" "2DES*" "2crypt*" "2oversea*" "2Libya*" "2Khadaffi*" "2nuclear*" "2atomic*"
	  "2secret*" "2meet me wednesday by the cadenza*" "2border*" "2alien*" "2UFO*"
	  "2Project Blue Book*" "2Velikovsky*" "2Hitler*" "2Nazi*" "2comsymp*" "2red*"
	  "2United Nations*" "2airplane*" "2X-15*" "2X-29*" "2Saudi*" "2Lebanon*" "2Embassy*"
	  "2United States*" "2Ottawa*" "2Cuba*" "2Havana*" "2Castro*" "2Lenin*" "2Marx*" "2Stalin*"
	  "2Gorbachev*" "2Chernenko*" "2Kruschev*" "2Brezhnev*" "2Kennedy*" "2FBI*" "2CIA*" "2NSA*"
	  "2NRA*" "2John Birch*" "2Iran*" "2Contra*" "2Israel*" "2hostage*" "2North*" "2Poindexter*"
	  "2drug*" "2IRS*" "2assassin*" "2dwarf*"))

(defvar 4*security-countercodes**
	'("2Closet Liberal*" "2Young Democrat*" "2Reactionary*" "2Dangerous Reactionary*"
	  "2Communist Agitator*"))

(defvar 4*security-dispositions**
	'("2Hold for Questioning*" "2Hold Indefinitely*" "2Electronic Surveillance*"
	  "2Terminate with Extreme Prejudice*" "2Monitor Future Net Access*"
	  "2Proceed with Income Tax Audit - Impound Personal Property*"
	  "2Hold Spouse for Questioning - Terminate Children*"))

(defun 4security-scan-line *(string &optional counts)
  (declare (string string) (optimize speed))
  (let (#+LISPM (SYS:ALPHABETIC-CASE-AFFECTS-STRING-COMPARISON nil) ;1 for the ucode*
	(len (length string)))
    (dotimes (i len)
      (declare (fixnum i))
      (dolist (keyword *security-keywords*)
	(declare (string keyword))
	(when (and #-LISPM (string-equal (the string string) (the string keyword) :start1 i :end1 (+ i (length keyword)))
		   #+LISPM (sys:%string-equal string i keyword 0 (length keyword))
		   (or (= len (+ i (length keyword)))
		       (not (alpha-char-p (char string (+ i (length keyword))))))
		   (or (zerop i)
		       (not (alpha-char-p (char string (1- i)))))
		   )
	  (let* ((cons (assoc (the string keyword) counts :test #'string-equal)))
	    (if cons
		(incf (cadr cons))
		(push (list keyword 1) counts)))))))
  counts)

(defun 4security-disposition *(codes)
  (string-append
    (format nil "3NSA File #~D - keywords caught - ~D*"
	    (logand #xFFF (get-internal-run-time))
	    (apply #'+ (mapcar #'second codes)))
    (if (null codes)
	(format nil "3~%Classification - Unclassified~%Disposition - Cleared for release*")
	(string-append
	  (format nil "3~%Keywords found:~%~:{~<~%~1,65:;~*~:3d  ~2:*~A~>~^~8,16t~}*" codes)
	  (format nil "3~%Classification - ~A~%Disposition - ~A*"
		  (nth (random (length *security-countercodes*)) *security-countercodes*)
		  (nth (random (length *security-dispositions*)) *security-dispositions*))
	  ))))

(defun 4security-scan-file *(pathname-or-stream)
  (let* ((stream (if (streamp pathname-or-stream)
		     pathname-or-stream
		     (open pathname-or-stream :direction :input :characters t)))
	 (counts '()))
    (unwind-protect
	(do* ((line (read-line stream nil nil)
		    (read-line stream nil nil)))
	     ((null line))
	  (declare (inline security-scan-line)
		   (optimize speed))
	  (setq counts (security-scan-line line counts)))
      (unless (streamp pathname-or-stream) (close stream)))
    (security-disposition counts)))


#+LISPM
(defun 4security-scan-interval *(start-bp &optional end-bp in-order-p)
  (get-interval start-bp end-bp in-order-p)
  (let* ((end-line (bp-line end-bp))
	 (counts '()))
    (do* ((line (bp-line start-bp) (line-next line)))
	 ((or (null line) (eq line end-line)))
      (declare (inline security-scan-line)
	       (optimize speed))
      (setq counts (security-scan-line line counts)))
    counts))

#+LISPM
(defun 4security-scan-mail-buffer *(buffer &optional quietly (once-only t) (popup t))
  (when (typep buffer 'zwei:mail-summary-buffer) (setq buffer (send buffer :sequence-buffer)))
  (let* ((msg (if (typep buffer 'zwei:message-node)
		  buffer
		  (aref (send buffer :message-array) (send buffer :current-message-index))))
	 (done-once (get msg 'SECURE)))
    (when (or (null done-once) (null once-only))
      (assure-message-parsed msg t)
      (let* ((codes (unless done-once (security-scan-interval (send msg :headers-end-bp) (interval-last-bp msg))))
	     (from (car (getf (or (zwei:get-message-header msg :from)
				  (zwei:get-message-header msg :sender))
			      :address-list))))
	(setf (get msg 'SECURE) t)
	(when (or codes (stringp done-once) (not quietly))
	  (and from (setq from (or (send from :send-if-handles :name)
				   (send from :send-if-handles :local-part)
				   (princ-to-string from))))
	  (when (consp from) (setq from (apply #'string-append from)))
	  (let* ((disposition (or (and (stringp done-once) done-once)
				  (if from
				      (string-append (string-trim '(#\Space #\Tab #\Newline #\" #\( #\)) from)
						     #\Newline #\Newline (security-disposition codes))
				      (security-disposition codes)))))
	    (setf (get msg 'SECURE) disposition)
	    (if popup
		(tv:mouse-confirm disposition "3Click here to acknowledge.*"
				  FONTS:CPTFONT FONTS:HL12I (* 81 (tv:font-char-width FONTS:CPTFONT)))
		disposition
		)))))))

#+LISPM
(let* ((process nil)
       (buf nil))
  (defun 4synchronous-security-check* (buffer)
    (unless (eq buf buffer)
      (when process (send process :kill))
      (setq buf buffer
	    process (process-run-function "3NSA Security Check*"
		      #'(lambda (b)
			  (unwind-protect (security-scan-mail-buffer b t)
			    (setq process nil)))
		      buffer)))
    ))

#+LISPM
(sys:advise zwei:make-message-current :after nsa nil
  (and zwei:*msg* (synchronous-security-check zwei:*msg*)))

#+LISPM
(defcom 4com-security-scan-message *"2I'm afraid that's on a need-to-know basis.*" ()
  (security-scan-mail-buffer *interval* nil nil)
  dis-none)

#+LISPM
(defcom 4com-security-report-message *"2Roger Tango Delta Charlie, Proceed Code Scorched Earth.*" ()
  (let* ((disposition (security-scan-mail-buffer *interval* nil nil nil)))
    (com-reply-to-all)
    (com-goto-end)
    (insert (point) disposition)
    (insert (point) "3  *")
    (replace-string (point) #.(string #\Newline) #.(string-append #\Newline "3  *"))
    (insert (interval-last-bp *interval*) #.(format nil "2~2%  <<Click here to acknowledge.>>~%*"))
    )
  dis-text)

#+LISPM
(set-comtab *read-mail-comtab* () (make-command-alist '(com-security-scan-message com-security-report-message)))
