;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:ZWEI -*-


;;; "Flame" program.  This has a chequered past.
;;;
;;; The original was on a Motorola 286 running Vanilla V.1,
;;; about 2 years ago.  It was couched in terms of a yacc (I think)
;;; script.  I pulled the data out of it and rewrote it as a piece
;;; of PL/1 on Multics.  Now I've moved it into an emacs-lisp
;;; form.  If the original author cares to contact me, I'd
;;; be very happy to credit you!
;;;
;;; Ian G. Batten, Batten@uk.ac.bham.multics
;;;
;;; Ported to Common Lisp and Zmacs by Jamie Zawinski <jwz@teak.berkeley.edu>.


(defparameter SENTENCE
  '(("how can you say that " STATEMENT "?")
    ("I can\'t believe how " ADJECTIVE " you are.")
    ("only a " DER-TERM " like you would say that " STATEMENT ".")
    (STATEMENT ", huh?")
    ("so, " STATEMENT "?")
    (STATEMENT ", right?")
    ("I mean, " SENTENCE)
    ("don't you realise that " STATEMENT "?")
    ("I firmly believe that " STATEMENT ".")
    ("let me tell you something, you " DER-TERM ", " STATEMENT ".")
    ("furthermore, you " DER-TERM ", " STATEMENT ".")
    ("I couldn't care less about your " THING ".")
    ("How can you be so " ADJECTIVE "?")
    ("you make me sick.")
    ("it's well known that " STATEMENT ".")
    (STATEMENT ".")
    ("it takes a " GROUP-ADJ " " DER-TERM " like you to say that " STATEMENT ".")
    ("I don't want to hear about your " THING ".")
    ("you're always totally wrong.")
    ("I've never heard anything as ridiculous as the idea that " STATEMENT ".")
    ("you must be a real " DER-TERM " to think that " STATEMENT ".")
    ("you " ADJECTIVE " " GROUP-ADJ " " DER-TERM "!")
    ("you're probably " GROUP-ADJ " yourself.")
    ("you sound like a real " DER-TERM ".")
    ("why, " STATEMENT "!")
    ("I have many " GROUP-ADJ " friends.")
    ("save the " THING "s!")
    ("no nukes!")
    ("ban " THING "s!")
    ("I'll bet you think that " THING "s are " ADJECTIVE ".")
    ("you know, " STATEMENT ".")
    ("your " QUALITY " reminds me of a " THING ".")
    ("you have the " QUALITY " of a " DER-TERM ".")
    (DER-TERM "!")
    (ADJECTIVE " " GROUP-ADJ " " DER-TERM "!")
    ("you're a typical " GROUP-ADJ " person, totally " ADJECTIVE ".")
    ("man, " SENTENCE)
    ))

(defparameter QUALITY
  '("ignorance" "stupidity" "worthlessness" "prejudice"
    "lack of intelligence" "lousiness" "bad grammar"
    "lousy spelling" "lack of common decency" "ugliness"
    "nastiness" "subtlety" "dishonesty"
    (ADJECTIVE " " QUALITY)))

(defparameter ADJECTIVE
  '("ignorant" "crass" "pathetic" "sick"
    "bloated" "malignant" "perverted" "sadistic"
    "stupid" "unpleasant" "lousy" "abusive" "bad"
    "braindamaged" "selfish" "improper" "nasty"
    "disgusting" "foul" "intolerable" "primitive"
    "depressing" "dumb" "phoney"
    (ADJECTIVE " and " ADJECTIVE)
    ("as " ADJECTIVE " as a " THING)
    ))


(defparameter DER-TERM
  '((ADJECTIVE " " DER-TERM) "sexist" "fascist"
    "weakling" "coward" "beast" "peasant" "racist"
    "cretin" "fool" "jerk" "ignoramus" "idiot"
    "wanker" "rat" "slimebag" "DAF driver"
    "Neanderthal" "sadist" "drunk" "capitalist"
    "wimp" "dogmatist" "wally" "maniac"
    "whimpering scumbag" "pea brain" "arsehole"
    "moron" "goof" "incompetant" "lunkhead" "Nazi"
    "SysThug" (DER-TERM " " DER-TERM)))


(defparameter THING
  '((ADJECTIVE " " THING) "computer"
    "Honeywell dps8" "whale" "operation"
    "sexist joke" "ten-incher" "dog" "MicroVAX II"
    "source license" "real-time clock"
    "mental problem" "sexual fantasy"
    "venereal disease" "Jewish grandmother"
    "cardboard cut-out" "punk haircut" "surfboard"
    "system call" "wood-burning stove"
    "graphics editor" "right wing death squad"
    "disease" "vegetable" "religion"
    "cruise missile" "bug fix" "lawyer" "copyright"
    "PAD"))


(defparameter GROUP-ADJ
  '("gay" "old" "lesbian" "young" "black"
    "Polish" ADJECTIVE "white"
    "mentally retarded" "Nicaraguan" "homosexual"
    "dead" "underpriviledged" "religious"
    (THING "-loving") "feminist" "foreign"
    "intellectual" "crazy" "working" "unborn"
    "Chinese" "short" ADJECTIVE "poor" "rich"
    "funny-looking" "Puerto Rican" "Mexican"
    "Italian" "communist" "fascist" "Iranian"
    "Moonie"))

(defparameter STATEMENT
  '(("your " THING " is great")
    (THING "s are fun")
    (PERSON " is a " DER-TERM)
    (GROUP-ADJ " people are " ADJECTIVE)
    ("every " GROUP-ADJ " person is a " DER-TERM)
    ("most " GROUP-ADJ " people have " THING "s")
    ("all " GROUP-ADJ " dudes should get " THING "s")
    (PERSON " is " GROUP-ADJ)
    ("trees are " ADJECTIVE)
    ("if you've seen one " THING ", you've seen them all")
    ("you're " GROUP-ADJ)
    ("you have a " THING)
    ("my " THING " is pretty good")
    ("the Martians are coming")
    ("the " PAPER " is always right")
    ("just because you read it in the " PAPER " that doesn't mean it's true")
    (PERSON " was " GROUP-ADJ)
    (PERSON "'s ghost is living in your " THING)
    ("you look like a " THING)
    ("the oceans are full of dirty fish")
    ("people are dying every day")
    ("a " GROUP-ADJ " man ain't got nothing in the world these days")
    ("women are inherently superior to men")
    ("the system staff is fascist")
    ("there is life after death")
    ("the world is full of " DER-TERM "s")
    ("you remind me of " PERSON)
    ("technology is evil")
    (PERSON " killed " PERSON)
    ("the Russians are tapping your phone")
    ("the Earth is flat")
    ("it's OK to run down " GROUP-ADJ " people")
    ("Multics is a really " ADJECTIVE " operating system")
    ("the CIA killed " PERSON)
    ("the sexual revolution is over")
    ("Lassie was " GROUP-ADJ)
    ("the " GROUP-ADJ "s have really got it all together")
    ("I was " PERSON " in a previous life")
    ("breathing causes cancer")
    ("it's fun to be really " ADJECTIVE)
    (QUALITY " is pretty fun")
    ("you're a " DER-TERM)
    ("the " GROUP-ADJ " culture is fascinating")
    ("when ya gotta go ya gotta go")
    (PERSON " is " ADJECTIVE)
    (PERSON "'s " QUALITY " is " ADJECTIVE)
    ("it's a wonderful day")
    ("everything is really a " THING)
    ("there's a " THING " in " PERSON "'s brain")
    (PERSON " is a cool dude")
    (PERSON " is just a figment of your imagination")
    ("the more " THING "s you have, the better")
    ("life is a " THING)
    ("life is " QUALITY)
    (PERSON " is " ADJECTIVE)
    (GROUP-ADJ " people are all " ADJECTIVE " " DER-TERM "s")
    (STATEMENT ", and " STATEMENT)
    (STATEMENT ", but " STATEMENT)
    ("I wish I had a " THING)
    ("you should have a " THING)
    ("you hope that " STATEMENT)
    (PERSON " is secretly " GROUP-ADJ)
    ("you wish you were " GROUP-ADJ)
    ("you wish you were a " THING)
    ("I wish I were a " THING)
    ("you think that " STATEMENT)
    (STATEMENT ", because " STATEMENT)
    (GROUP-ADJ " people don't get married to " GROUP-ADJ " people because " REASON)
    (GROUP-ADJ " people are all " ADJECTIVE " because " REASON)
    (GROUP-ADJ " people are " ADJECTIVE ", and " REASON)
    ("you must be a " ADJECTIVE " " DER-TERM " to think that " PERSON " said " STATEMENT)
    (GROUP-ADJ " people are inherently superior to " GROUP-ADJ " people")
    ("God is Dead")))


(defparameter PAPER
  '("Daily Mail" "Daily Express"
    "Centre Bulletin" "Sun" "Daily Mirror"
    "Daily Telegraph" "Beano" "Multics Manual"))


(defparameter PERSON
  '("Reagan" "Ken Thompson" "Dennis Ritchie"
    "JFK" "the Pope" "Gadaffi" "Napoleon"
    "Karl Marx" "Groucho" "Michael Jackson"
    "Caesar" "Nietzsche" "Heidegger"
    "Henry Kissinger" "Nixon" "Castro" "Thatcher"
    "Attilla the Hun" "Alaric the Visigoth" "Hitler"))


(defparameter REASON
  '("they don't want their children to grow up to be too lazy to steal"
    ("they can't tell them apart from " GROUP-ADJ " dudes")
    ("they're too " ADJECTIVE)
    (PERSON " wouldn't have done it")
    "they can't spray paint that small"
    ("they don't have " THING "s")
    "they don't know how"
    ("they can't afford " THING "s")))


(defun flatten (list)
  (cond ((atom list)
	 (list list))
	(t (apply 'append (mapcar 'flatten list)))))


(defun sentence-1 (&optional source (from sentence))
  (when (symbolp from) (setq from (symbol-value from)))
  (apply #'string-append
    (flatten
      (cond ((stringp source) source)
	    ((and source (symbolp source))
	     (sentence-1 nil source))
	    ((consp source) (mapcar #'sentence-1 source))
	    (t (sentence-1 (nth (random (length from)) from)))))))

(defun sentence ()
  (let* ((s (sentence-1)))
    (setf (char s 0) (char-upcase (char s 0)))
    s))


#+EXPLORER
(sys:advise ZWEI:INSERT-DEFAULT-HEADER-FIELDS :after :flame nil
  ;; Insert an X-Non-Sequitur: field in all outgoing mail which contains a random sentence.
  (random most-positive-fixnum (make-random-state t))
  (let* ((line (zwei:bp-line (car sys:arglist))))
    (do* () ((null (zwei:line-previous line))) (setq line (zwei:line-previous line)))
    (insert-header-field (zwei:create-bp line 0) :x-non-sequitur (sentence)))
  )

#+EXPLORER
(when (get 'zwei:default-post-news-mail-template :mail-template-function)
  (sys:advise (:property zwei:default-post-news-mail-template :mail-template-function) :after :flame nil
    ;; Insert an X-Non-Sequitur: field in all outgoing posts which contains a random sentence.
    (insert-header-field (zwei:copy-bp (zwei:interval-first-bp zwei:*interval*)) :x-non-sequitur (sentence))))

#+EXPLORER
(when (get 'zwei:default-reply-news-mail-template :mail-template-function)
  (sys:advise (:property zwei:default-reply-news-mail-template :mail-template-function) :after :flame nil
    ;; Insert an X-Non-Sequitur: field in all outgoing posts which contains a random sentence.
    (insert-header-field (zwei:copy-bp (zwei:interval-first-bp zwei:*interval*)) :x-non-sequitur (sentence))))


#+EXPLORER
(defcom com-non-sequitur
	"Insert a random sentence.  If this is a send-mail buffer, insert it in an X-Non-Sequitur: field."
	()
  (cond ((get *interval* :mail-template-type)
	 (do* ((line (bp-line (interval-first-bp *interval*))
		     (line-next line)))
	      ((or (null line)
		   (zerop (length line))
		   (string-equal line "X-Non-Sequitur:" :end1 (min (length line) 15)))
	       (when line
		 (if (zerop (length line))
		     (insert-header-field (create-bp line 0) :x-non-sequitur (in-current-font (sentence)))
		     (let* ((bp (create-bp line 0)))
		       (delete-interval bp (end-line bp))
		       (with-bp (bp2 bp :normal)
			 (insert-header-field bp :x-non-sequitur (in-current-font (sentence)) nil)
			 (move-bp (point) (forward-char bp2 16 t)))))))))
	(t
	 (insert-moving (point) (in-current-font (sentence)))))
  DIS-TEXT)


#+EXPLORER
(set-comtab *zmacs-comtab* () '(("Non-Sequitur" . com-non-sequitur)))
