;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:USER; Vsp:0; Fonts:(CPTFONT HL12 TR12I COURIER ADOBE-COURIER14B HL12B CPTFONTBI) -*-

;1;; File "3NATIONAL-DEBT*".*
;1;; Display a running total of the US national debt in the wholine.*
;1;; Based on a program for the Amiga by Ron Charlton.*
;1;; Numbers come from the Survey of Current Business, 1989.*
;1;;*
;1;; 5ChangeLog:**
;1;;*
;1;;    9 Oct 89*	1Jamie Zawinski*	1Created.*

(defconstant 4DEC-31-88-NATIONAL-DEBT *2707284000000 "2The US National Debt as of Dec 31, 1988.*")
(defconstant 4DEC-31-88-NATIONAL-DEBT-DELTA *7673.015L0
  "2The rate of increase of the US National Debt as of Dec 31, 1988 (in3 *dollars per second).*")

(defun 4national-debt-at *(universal-time)
  (let* ((dec-31-88 #.(encode-universal-time 0 0 24 31 12 1988))
	 (seconds-since-then (- universal-time dec-31-88))
	 (delta-since-then (truncate (* DEC-31-88-NATIONAL-DEBT-DELTA seconds-since-then))))
    (+ DEC-31-88-NATIONAL-DEBT delta-since-then)))

(defvar 4*wholine-national-debt-string* *(make-array 21 :element-type 'string-char :fill-pointer 0)
  "2A fill-pointer-string which is reused when computing the national debt.*")

(defvar 4*wholine-display-national-debt* *t
  "2Whether the wholine file-state sheet should display the current US national debt when there is nothing else to show.*")

(profile:define-profile-variable *wholine-display-national-debt* (:ucl) :cvv-type :boolean)


(defmethod 4(tv:who-line-file-sheet :after :update)* ()
  "2Display the national debt, if nothing else is there.*"
  (declare (optimize (speed 3)))  ;1 Turn on format-optimization.*
  (when (and *wholine-display-national-debt* (eq tv:who-line-item-state 'tv:null))
    (let ((string *wholine-national-debt-string*))
      (declare (string string))
      (setf (fill-pointer string) 1)
      (setf (schar string 0) #\$)
      (format string "3~:D*" (the integer (national-debt-at (get-universal-time))))
      (send self :clear-screen)
      (send self :string-out-explicit string (- (tv:sheet-inside-width) (send self :string-length string))))))
