;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:ZWEI; Vsp:0; Fonts:(CPTFONT HL12 TR12I COURIER CPTFONT HL12B HL12BI); Patch-File:T -*-

;1;; File "3MINOR-MODES-HACK*"*
;1;;*
;1;; Here is something which annoyed me a lot.*
;1;;*
;1;; I would have in **INITIAL-MINOR-MODES*1 a form like *((TEXT-MODE) AUTO-FILL-MODE)1 so*
;1;; that Auto-Fill mode would automatically come on when I was editing a text file.  Then, I*
;1;; would be editing a text file in which I did 6not* want Auto-Fill on.  So, I would say *
;1;; 5Meta-X Auto Fill* to turn it off.  Fine.  Then I would switch buffers.  When I came back *
;1;; to the buffer in which I had already 6explicitly* 6turned off* Auto-Fill mode, Auto-Fill*
;1;; would be back on again.  This I find infuriating.  If I turn it off, it should 6stay *off.*
;1;;*
;1;; This file modifies the *TURN-ON-MODE1 function so that the **INITIAL-MINOR-MODES*1 list*
;1;; is only consulted when a mode is being turned on in a buffer that was not on in that*
;1;; buffer the last time it was selected.*
;1;;*
;1;; This means that new buffers will have the defaults you specified, but if you turn a mode*
;1;; off, it will 6stay off.**
;1;;*
;1;; 5ChangeLog:**
;1;;*
;1;;    23 May 89*	1Jamie Zawinski*	1 Created.*
;1;;*


(DEFUN 4TURN-ON-MODE* (MODE-SYMBOL)
  "2Turn on mode MODE-SYMBOL.  Mode symbol is, for example, LISP-MODE.
Does nothing if the mode is already on.*"
  (SYS:WITH-SUGGESTIONS-MENUS-FOR ZWEI:TURN-ON-MODE
    (COND ((NULL (ASSOC MODE-SYMBOL *MODE-LIST* :TEST #'EQ))
	   (COND ((GET MODE-SYMBOL 'MAJOR-MODE-P)
		  (SETQ *MAJOR-MODE* MODE-SYMBOL)))
	   (PUSH (LIST MODE-SYMBOL (EVALUATE-FORMING-UNDO-LIST (GET MODE-SYMBOL 'MODE)))
		 *MODE-LIST*)))
    (COND ((NULL (MEMBER MODE-SYMBOL *MODE-NAME-LIST* :TEST #'EQ))
	   (PUSH MODE-SYMBOL *MODE-NAME-LIST*)))
    (COND ((and (GET MODE-SYMBOL 'MAJOR-MODE-P)
		(not (member mode-symbol					 ;1; When it's a major mode, and it was not on in*
			     (send *interval* :send-if-handles :saved-mode-list) ;1; this buffer the last time this buffer was current,*
			     :test #'eq :key #'car)))				 ;1; then turn on the associated minor modes.*
	   (DOLIST (MINOR *INITIAL-MINOR-MODES*)
	     (IF (ATOM MINOR)
		 (TURN-ON-MODE MINOR)
		 (IF (MEMBER MODE-SYMBOL (CAR MINOR) :TEST #'EQ)
		     (DOLIST (MINOR (CDR MINOR))
		       (TURN-ON-MODE MINOR)))))))
    (LET ((HOOK (GET MODE-SYMBOL 'MODE-HOOK-SYMBOL)))
      (AND HOOK
	   (BOUNDP HOOK)
	   (FUNCALL (SYMBOL-VALUE HOOK))))
    (SORT *MODE-NAME-LIST* #'(LAMBDA (X Y) (< (GET X 'MODE-LINE-POSITION)
					      (GET Y 'MODE-LINE-POSITION))))))
