;;; -*- Mode:Common-Lisp; Package:TV; Base:10; Patch-file:T -*-
;;;
;;;                           RESTRICTED RIGHTS LEGEND
;;;
;;; Use, duplication, or disclosure by the Government is subject to
;;; restrictions as set forth in subdivision (b)(3)(ii) of the Rights in
;;; Technical Data and Computer Software clause at 52.227-7013.
;;;
;;;                     TEXAS INSTRUMENTS INCORPORATED.
;;;                              P.O. BOX 2909
;;;                           AUSTIN, TEXAS 78769
;;;                                 MS 2151
;;;
;;; Copyright (C) 1985, Texas Instruments Incorporated. All rights reserved.
;;; Copyright (C) 1986, Texas Instruments Incorporated. All rights reserved.
;;;
;;; This file contains a new command for the Input Editor (rubout handler),
;;; CTRL-META-C, that is the opposite of META-C, and is meant to be used in
;;; conjunction with CTRL-C and META-C.  It traverses the kill ring in the
;;; opposite direction from META-C.
;;;
;;; Also included here is the analogous command for ZMACS, CTRL-META-Y,
;;; which works in conjuction with CTRL-Y and META-Y.
;;;
;;; I find these commands useful if I accidentally META-C past the text I wanted
;;; to yank.

;;; 8 Jul 85  Steve Ford       Created.
;;; 8 Aug 87  Jamie Zawinski   Ported to release 3.0.


(defcommand rh-com-yank-push-history-ring (n)
  '(:names (("Yank Push History Ring" :typein-name? nil))
    :keys  (#\C-M-C #\C-M-Y )
    :description "Inserts the next later kill ring entry."
    :documentation "This command is valid when preceded directly by either Yank-Input-Ring (CTRL-C),
Yank-Kill-Ring (CTRL-Y), Yank-Pop-History-Ring (META-C or META-Y), or itself.  It erases what was
just yanked and inserts the next later entry in the Zwei kill ring.  Try typing
      (1+ 1)
      (1+ 2)
      (1+ 3)
      Ctrl-C   
      Meta-C
      Meta-C
      Ctrl-Meta-C
CTRL-C will yank (1+ 3).  META-C will first yank (1+ 2), and then (1+ 1), going backward in time.
CTRL-META-C will then yank (1+ 2), going forward in time.  It is the opposite of META-C.
There is no limit to the number of times you can repeat this command, alone or in combination with META-C."
    :command-flavor rh-command)
  (declare (:self-flavor tv:stream-mixin))
  (when (typep *last-command-type* 'zwei:history)
    (and (not (eq n 0))
	 (rh-yank-from-history
	   (zwei:rotate-history-yank-pointer *last-command-type* (- (or n 1)))
	   t (eq *last-command-type* (rh-input-ring))))
    (setq *current-command-type* *last-command-type*))
  t)

(send rh-command-table :add-command (ucl:get-command 'rh-com-yank-push-history-ring))


ZWEI:
(defcom com-yank-push "Correct a Yank command to get something newer.
Replaces the last thing you yanked -- the text now in the region --
with another entry from the same history list.
By default, the next later entry is used, so that successive uses of this command
get newer and newer things from the history.
A numeric argument specifies how many entries forward or back to go;
negative means to yank older text.
An argument of zero means kill the yanked text and don't replace it with anything."
	()
  ;; Need not check for MARK-P, by special case.
  (or (typep *last-command-type* 'history) (barf))
  (funcall (history-yank-method *last-command-type*)
	   (and (not (zerop *numeric-arg*))
		(rotate-history-yank-pointer *last-command-type*
					     (- *numeric-arg*))))
  (setq *current-command-type* *last-command-type*)
  dis-text)

(zwei::command-store 'zwei::com-yank-push #\C-M-Y zwei::*standard-comtab*)
