;;; -*- Mode:Common-Lisp; Package:TV; Base:10 -*-

; Helix drawing program by John Nguyen  MIT  1989  johnn@hx.lcs.mit.edu
; Adapted from MacIntosh program written by Christopher Tate at Penn. State


(defvar *sins* (make-array 360))
(defvar *coss* (make-array 360))

(dotimes (i 360)
  (setf (aref *sins* i) (coerce (sin (/ (* i pi) 180)) 'single-float))
  (setf (aref *coss* i) (coerce (cos (/ (* i pi) 180)) 'single-float)))

(defun helix (&key
	      (radius1 300)
	      (radius2 200)
	      (d-angle 137)
	      (factor1 2)
	      (factor2 2)
	      (factor3 2)
	      (factor4 1)
	      (window w:selected-window))
  (send window :clear-screen)
  (let ((xmid (lsh (send window :width) -1))
	(ymid (lsh (send window :height) -1))
	(array (send window :screen-array)))
    (let ((x1 xmid)
	  (y1 (+ ymid radius2))
	  (x2 xmid)
	  (y2 (+ ymid radius1))
	  (angle 0)
	  (limit (1+ (floor 360 (gcd 360 d-angle)))))
      (dotimes (i limit)
	(setq x1 (round (+ xmid (* radius1 (aref *sins* (mod (* angle factor1) 360)))))
	      y1 (round (+ ymid (* radius2 (aref *coss* (mod (* angle factor2) 360))))))
	(tv:%draw-line x1 y1 x2 y2 w:normal t array)
	(send window :draw-line x1 y1 x2 y2)
	(setq x2 (round (+ xmid (* radius2 (aref *sins* (mod (* angle factor3) 360)))))
	      y2 (round (+ ymid (* radius1 (aref *coss* (mod (* angle factor4) 360))))))
	(tv:%draw-line x1 y1 x2 y2 w:normal t array)
	(incf angle d-angle)
	))))

(defun helix1 () (helix :radius1 290 :radius2 -100 :d-angle 143 :factors '(1 1 2 2)))

(defsubst random-factor () (* (if (zerop (random 7))
				  3
				  (1+ (random 2)))
			      (- (* (random 2) 2) 1)))

(defun helix-random (&optional (window w:selected-window))
  (do-forever
    (let (radius1 radius2
	  (radius (- (lsh (min (send window :width) (send window :height)) -1)
		     30))
	  (d-angle 0)
	  (factor1 2)
	  (factor2 2)
	  (factor3 2)
	  (factor4 2))
      (let ((divisor (* (1+ (random 3.0))
			(- (* (random 2) 2) 1))))
	(if (zerop (random 2))
	    (setq radius1 radius
		  radius2 (round radius divisor))
	    (setq radius2 radius
		  radius1 (round radius divisor)))
	(loop until (< (gcd 360 d-angle) 2) do
	      (setq d-angle (random 360)))
	(loop until (= (gcd factor1 factor2 factor3 factor4) 1)
	      do
	      (setq factor1 (random-factor)
		    factor2 (random-factor)
		    factor3 (random-factor)
		    factor4 (random-factor)))
	(helix :radius1 radius1 :radius2 radius2 :d-angle d-angle
	       :factor1 factor1
	       :factor2 factor2
	       :factor3 factor3
	       :factor4 factor4
	       :window window)))
    (sleep 5)
    (let ((height (send window :height))
	  (width (send window :width))
	  (array (send window :screen-array)))
      (dotimes (i (lsh height 1))
	(let ((line (random height)))
	  (tv:%draw-line 0 line width line w:erase t array)))
      (send window :clear-screen))
    (sleep 1)))

(when (boundp '*screen-saver-hacks-list*)
  (pushnew 'helix-random *screen-saver-hacks-list*))

(defun helix-ps (filename
		 &key
		 (radius1 -180)
		 (radius2 260)
		 (d-angle 323)
		 (factors '(-1 3 3 -2)))
  (with-open-file (s filename :direction :output)
    (format s "0 setgray .3 setlinewidth~%")
    (let ((xmid (* 72 4.25))
	  (ymid (* 72 5.5))
	  (factor1 (first factors))
	  (factor2 (second factors))
	  (factor3 (third factors))
	  (factor4 (fourth factors)))
      (let ((x1 (+ xmid radius1))
	    (y1 ymid)
	    (x2 (+ xmid radius2))
	    (y2 ymid)
	    (angle 0)
	    (limit (1+ (floor 360 (gcd 360 d-angle)))))
	(dotimes (i limit)
	  (format s "~d ~d moveto~%" x2 y2)
	  (setq x1 (+ xmid (* radius1 (aref *coss* (mod (* angle factor1) 360))))
		y1 (+ ymid (* radius2 (aref *sins* (mod (* angle factor2) 360)))))
	  (format s "~d ~d lineto~%" x1 y1)
	  (setq x2 (+ xmid (* radius2 (aref *coss* (mod (* angle factor3) 360))))
		y2 (+ ymid (* radius1 (aref *sins* (mod (* angle factor4) 360)))))
	  (format s "~d ~d lineto stroke~%" x2 y2)
	  (incf angle d-angle)
	)
	(format s "showpage~%")
	))))