;;; -*- Mode: Common-Lisp; Package: DOMAIN-NAME-SYSTEM; Base: 10.; Patch-File: T -*-
;;; Written 30-Jul-88 19:33:53 by Victor,
;;; Reason: Fixed describe-dns-packet & friends.
;;; while running on George Ballantine from band LOD2
;;; With IO 3.47, PATHNAME 3.17, FILE 3.16, SYSTEM 3.114, METER 3.7, SERIAL 3.2, CHAOSNET 3.25,
;;;  ETHERNET 3.4, GC 3.25, IMAGEN 3.0, MAIL-DAEMON 3.8, NETWORK-SUPPORT 3.21, PROFILE 3.7,
;;;  SUGGESTIONS 3.7, UCL 3.4, ZWEI 3.45, STREAMER-TAPE 3.20, DEBUG-TOOLS 3.7, FONT-EDITOR 3.2,
;;;  GLOSSARY 3.1, INPUT-EDITOR 3.0, MAIL-READER 3.23, NAMESPACE-EDITOR 3.7, NVRAM 3.6,
;;;  TELNET 3.8, TV 3.34, NAMESPACE 3.15, COMPILER 3.35, PRINTER 3.10, SYSLOG 3.1,
;;;  VT100 3.15, VISIDOC 1.0, IP 2.77, RPC 3.2, NFS 3.2, Experimental NFS-PATCHES 2.0,
;;;  Experimental SYSTEM-PATCHES 2.80, GRAPHICS-WINDOW 3.5, GED 3.5, TREE 3.0, VISIDOC-SERVER 1.0,
;;;  Experimental ICU-DOCS 10.0, Experimental TCP-IMAGEN 9.1, Experimental NAME-DRAGON 2.1,
;;;  Experimental ICU-LIBRARY 9.1, Experimental TEXINFO 4.1, Experimental SYSTEM-ENHANCEMENTS 14.4,
;;;  Experimental DOMAINS 2.0,  microcode 469, Band Name: 3.114 w Visidoc, 880503/Victor

#!C
; From file ACCESSORS.LISP#> VICTOR.NETWORK.DNS; JJ:
#10R DOMAIN-NAME-SYSTEM#:
(COMPILER-LET ((*PACKAGE* (FIND-PACKAGE "DOMAIN-NAME-SYSTEM"))
                          (SI:*LISP-MODE* :COMMON-LISP)
                          (*READTABLE* SYS:COMMON-LISP-READTABLE)
                          (SI:*READER-SYMBOL-SUBSTITUTIONS* SYS::*COMMON-LISP-SYMBOL-SUBSTITUTIONS*))
  (COMPILER#:PATCH-SOURCE-FILE "John: VICTOR.NETWORK.DNS; ACCESSORS.#"



(defun describe-dns-question-section (pkt &optional (stream *standard-output*))
  (let ((n (raw-header-question-count pkt)))
    (if (null stream)
	(with-output-to-string (s)
	  (dotimes (i n)
	    (format s "~&Name: ~s" (query-name pkt i))
	    (format s "~%Type: ~a" (type-string (query-type pkt i)))
	    (format s "~%Class: ~a" (class-string (query-class pkt i)))))
	(dotimes (i n pkt)
	  (format stream "~&Name: ~s" (query-name pkt i))
	  (format stream "~%Type: ~a" (type-string (query-type pkt i)))
	  (format stream "~%Class: ~a" (class-string (query-class pkt i)))))))

))

#!C
; From file ACCESSORS.LISP#> VICTOR.NETWORK.DNS; JJ:
#10R DOMAIN-NAME-SYSTEM#:
(COMPILER-LET ((*PACKAGE* (FIND-PACKAGE "DOMAIN-NAME-SYSTEM"))
                          (SI:*LISP-MODE* :COMMON-LISP)
                          (*READTABLE* SYS:COMMON-LISP-READTABLE)
                          (SI:*READER-SYMBOL-SUBSTITUTIONS* SYS::*COMMON-LISP-SYMBOL-SUBSTITUTIONS*))
  (COMPILER#:PATCH-SOURCE-FILE "John: VICTOR.NETWORK.DNS; ACCESSORS.#"



(defun describe-dns-answer-section (pkt &optional (stream *standard-output*))
  (let ((count (raw-header-answer-count pkt)))
    (if (null stream)
	(with-output-to-string (stream)
	  (dotimes (i count)
	    (format stream "~&Name: ~s" (answer-name pkt i))
	    (format stream "~%Type: ~a" (type-string (answer-type pkt i)))
	    (format stream "~%Class: ~a" (class-string (answer-class pkt i)))
	    (format stream "~%TTL: ~d" (answer-time-to-live pkt i))
	    (let ((len (answer-data-length pkt i))
		  (idx (answer-data-index pkt i)))
	      (format stream "~%Data length: ~d" len)
	      (format stream "~%Data: ~s"
		      (decode-data-for-describe pkt idx len (answer-type pkt i) (answer-class pkt i))))))
	(dotimes (i count pkt)
	  (format stream "~&Name: ~s" (answer-name pkt i))
	  (format stream "~%Type: ~a" (type-string (answer-type pkt i)))
	  (format stream "~%Class: ~a" (class-string (answer-class pkt i)))
	  (format stream "~%TTL: ~d" (answer-time-to-live pkt i))
	  (let ((len (answer-data-length pkt i))
		(idx (answer-data-index pkt i)))
	    (format stream "~%Data length: ~d" len)
	    (format stream "~%Data: ~s"
		    (decode-data-for-describe pkt idx len (answer-type pkt i) (answer-class pkt i))))))))

))

#!C
; From file ACCESSORS.LISP#> VICTOR.NETWORK.DNS; JJ:
#10R DOMAIN-NAME-SYSTEM#:
(COMPILER-LET ((*PACKAGE* (FIND-PACKAGE "DOMAIN-NAME-SYSTEM"))
                          (SI:*LISP-MODE* :COMMON-LISP)
                          (*READTABLE* SYS:COMMON-LISP-READTABLE)
                          (SI:*READER-SYMBOL-SUBSTITUTIONS* SYS::*COMMON-LISP-SYMBOL-SUBSTITUTIONS*))
  (COMPILER#:PATCH-SOURCE-FILE "John: VICTOR.NETWORK.DNS; ACCESSORS.#"



(defun describe-dns-authority-section (pkt &optional (stream *standard-output*))
  (let ((count (raw-header-authority-count pkt)))
    (if (null stream)
	(with-output-to-string (stream)
	  (dotimes (i count)
	    (format stream "~&Name: ~s" (authority-name pkt i))
	    (format stream "~%Type: ~a" (type-string (authority-type pkt i)))
	    (format stream "~%Class: ~a" (class-string (authority-class pkt i)))
	    (format stream "~%TTL: ~d" (authority-time-to-live pkt i))
	    (let ((len (authority-data-length pkt i))
		  (idx (authority-data-index pkt i)))
	      (format stream "~%Data length: ~d" len)
	      (format stream "~%Data: ~s"
		      (decode-data-for-describe pkt idx len (authority-type pkt i) (authority-class pkt i))))))
	(dotimes (i count pkt)
	  (format stream "~&Name: ~s" (authority-name pkt i))
	  (format stream "~%Type: ~a" (type-string (authority-type pkt i)))
	  (format stream "~%Class: ~a" (class-string (authority-class pkt i)))
	  (format stream "~%TTL: ~d" (authority-time-to-live pkt i))
	  (let ((len (authority-data-length pkt i))
		(idx (authority-data-index pkt i)))
	    (format stream "~%Data length: ~d" len)
	    (format stream "~%Data: ~s"
		    (decode-data-for-describe pkt idx len (authority-type pkt i) (authority-class pkt i))))))))

))

#!C
; From file ACCESSORS.LISP#> VICTOR.NETWORK.DNS; JJ:
#10R DOMAIN-NAME-SYSTEM#:
(COMPILER-LET ((*PACKAGE* (FIND-PACKAGE "DOMAIN-NAME-SYSTEM"))
                          (SI:*LISP-MODE* :COMMON-LISP)
                          (*READTABLE* SYS:COMMON-LISP-READTABLE)
                          (SI:*READER-SYMBOL-SUBSTITUTIONS* SYS::*COMMON-LISP-SYMBOL-SUBSTITUTIONS*))
  (COMPILER#:PATCH-SOURCE-FILE "John: VICTOR.NETWORK.DNS; ACCESSORS.#"



(defun describe-dns-additional-section (pkt &optional (stream *standard-output*))
  (let ((count (raw-header-additional-count pkt)))
    (if (null stream)
	(with-output-to-string (stream)
	  (dotimes (i count)
	    (format stream "~&Name: ~s" (additional-name pkt i))
	    (format stream "~%Type: ~a" (type-string (additional-type pkt i)))
	    (format stream "~%Class: ~a" (class-string (additional-class pkt i)))
	    (format stream "~%TTL: ~d" (additional-time-to-live pkt i))
	    (let ((len (additional-data-length pkt i))
		  (idx (additional-data-index pkt i)))
	      (format stream "~%Data length: ~d" len)
	      (format stream "~%Data: ~s"
		      (decode-data-for-describe pkt idx len (additional-type pkt i) (additional-class pkt i))))))
	(dotimes (i count pkt)
	  (format stream "~&Name: ~s" (additional-name pkt i))
	  (format stream "~%Type: ~a" (type-string (additional-type pkt i)))
	  (format stream "~%Class: ~a" (class-string (additional-class pkt i)))
	  (format stream "~%TTL: ~d" (additional-time-to-live pkt i))
	  (let ((len (additional-data-length pkt i))
		(idx (additional-data-index pkt i)))
	    (format stream "~%Data length: ~d" len)
	    (format stream "~%Data: ~s"
		    (decode-data-for-describe pkt idx len (additional-type pkt i) (additional-class pkt i))))))))

))

#!C
; From file ACCESSORS.LISP#> VICTOR.NETWORK.DNS; JJ:
#10R DOMAIN-NAME-SYSTEM#:
(COMPILER-LET ((*PACKAGE* (FIND-PACKAGE "DOMAIN-NAME-SYSTEM"))
                          (SI:*LISP-MODE* :COMMON-LISP)
                          (*READTABLE* SYS:COMMON-LISP-READTABLE)
                          (SI:*READER-SYMBOL-SUBSTITUTIONS* SYS::*COMMON-LISP-SYMBOL-SUBSTITUTIONS*))
  (COMPILER#:PATCH-SOURCE-FILE "John: VICTOR.NETWORK.DNS; ACCESSORS.#"



(defun decode-data-for-describe (pkt start len type class)
  (cond ((= type *type-canonical-name*)
	 (get-domain-name pkt start))
	((= type *type-host-info*)
	 (cons (get-character-string pkt start)
	       (get-character-string pkt (+ start (8b-ref pkt start) 1))))
	((= type *type-name-server*)
	 (get-domain-name pkt start))
	((= type *type-pointer*)
	 (get-domain-name pkt start))
	((= type *type-text*)
	 (do ((data nil)
	      (s start (+ s 1 (8b-ref pkt s)))
	      (e (+ start len)))
	     ((>= s e) (nreverse data))
	   (push (get-character-string pkt s) data)))
	((and (= type *type-address*)
	      (= class *class-internet*))
	 (format nil "~d.~d.~d.~d"
		 (8b-ref pkt start) (8b-ref pkt (+ start 1)) (8b-ref pkt (+ start 2)) (8b-ref pkt (+ start 3))))
	(t (subseq pkt start (+ start len)))))
))
