;;; -*- Mode:Lisp; Package:ZWEI; Vsp:0; Fonts:(CPTFONT HL12 TR12I COURIER CPTFONT HL12B HL12I TR12BI); Syntax:Common-Lisp -*-

;1;; File "*BOLD-LOCK-EXTENSIONS1"*
;1;; Some examples editor hacking that uses the 5bold-lock* code.*
;1;; Written and maintained by Jamie Zawinski.*
;1;;*
;1;; 5ChangeLog:**
;1;;*
;1;; * 2 Apr 891  Jamie Zawinski*	1 Created.*
;1;;*


(defun 4boldify *(bold-p italic-p bp1 &optional bp2 in-order-p)
  "2Change the font of the specified region to have the specified bold/italic state.
  This sets the state exactly; if one of the flags is NIL, then that attribute will be removed.
  The region may contain multiple fonts; they are dealt with individually.
  If the requested font is not in the font map of the buffer, the user is asked if he/she would like to add it.
  A negative response means that no change is made for that piece of text.*"
  (get-interval bp1 bp2 in-order-p)		; 1Normalize the BPs.*
  (let* ((buffer-fonts (send *interval* :get-attribute :fonts))
	 (font-number (char-font (bp-char bp1)))
	 (last-bp bp1))
    (charmap (bp1 bp2)
      ;1; Iterate over the characters in the region.*
      ;1; Deal with the current section if a font change has been passed, or if we are at the end of the region.*
      (let* ((this-font-number (char-font (charmap-char))))
	(when (or (and *this-is-the-last-line* (= index *last-index*))	;1 These are bound by *CHARMAP1.*
		  (/= this-font-number font-number))
	  (let* ((this-bp (charmap-bp-after))
		 (font (intern (string (nth font-number buffer-fonts)) "3FONTS*"))
		 (4*bold-lock-mode-tracks-keys-exactly** t)
		 (new-font (tv:font-evaluate (4font-with-face* font bold-p italic-p)))
		 (new-number (ensure-font-present new-font)))
	    (when new-number
	      (change-font-interval last-bp this-bp nil new-number))
	    (setq last-bp this-bp)))
	(setq font-number this-font-number)))))


(defcom 4com-boldify-region*
	"2Set the bold/italic state of the current region to be the current state of the 5Bold Lock* and 5Italic Lock* keys.*"
	()
  (let* ((bold-p (bold-lock-state))
	 (ital-p (italic-lock-state)))
    (region (bp1 bp2)
      (boldify bold-p ital-p bp1 bp2))))

(defcom 4com-fake-bold-lock* "2A substitute for the Bold Lock key; executing this command is just like pressing the Bold Lock key.*" (KM)
  (setf (bold-lock-state) (not (bold-lock-state)))
  DIS-NONE)

(defcom 4com-fake-italic-lock* "2A substitute for the Italic Lock key; executing this command is just like pressing the Italic Lock key.*" (KM)
  (setf (italic-lock-state) (not (italic-lock-state)))
  DIS-NONE)
