/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

$Id: server.c,v 1.19 1994/04/05 01:53:29 janssen Exp $
*/
/* Last tweaked by Mike Spreitzer December 17, 1993 8:54 pm PST */

#include "m3.h"

static boolean FirstItem = FALSE;

static void DeclareCalleeReturnValue (Type type, Context context)
{
  if (type_basic_type(type) != void_Type)
    {
      fprintf (context->file, "  VAR return_value_ : %s;\n", M3_TYPE_NAME(type));
    }
}

static void CalleeListArgument (Argument a, Context context)
{
  if (!FirstItem)
    fprintf (context->file, ", ");
  else
    FirstItem = FALSE;
  fprintf (context->file, "%s", m3_argument_name(a));
}

void ReadLocalArg (Argument arg, Context context)
{
  UnmarshallValue (context, arg->type, arg->def, m3_argument_name(arg), 8, TRUE);
}

static void DeclareLocalArgument (Argument arg, Context context)
{
  fprintf (context->file, "  VAR %s: %s;\n",
	   m3_argument_name(arg), M3_TYPE_NAME(arg->type));
}

static int ExceptionIndex = 0;

static void CatchAndSignalException (Exception e, Context context)
{
  Type type = exception_type(e);
  boolean validtype = (type != NULL && type_basic_type(type) != void_Type);

  fprintf (context->file, "      | %s ", M3_EXCEPTION_NAME(e));
  if (validtype)
    fprintf (context->file, "(x_) ");
  fprintf (context->file, "=>\n        TRY");
  fprintf (context->file, "          IluRuntime.BeginException(call_, %u, ", ExceptionIndex);
  if (validtype)
    SizeValue (type, "x_", context);
  else
    fprintf (context->file, "0");
  fprintf (context->file, ");\n");
  if (validtype)
    MarshallValue (type, "x_", context, 10);
  fprintf (context->file, "        FINALLY\n");
  fprintf (context->file, "          IluRuntime.FinishException(call_);\n");
  fprintf (context->file, "        END (* try-finally *);\n        RETURN;\n");
  ExceptionIndex += 1;
}

static void GenerateCalleeStub (Procedure m, Context context)
{
  boolean oldFirst;
  char *stn = M3_SHORT_TYPE_NAME(m->object);
  char *cstn = M3_SHORT_TYPE_NAME(context->class);

  fprintf (context->file, "PROCEDURE Server__%s_%s (call_: IluRuntime.Call) RAISES {} =\n",
	   cstn, M3_SHORT_METHOD_NAME(m));
  fprintf (context->file, "  VAR leader_ : IluRuntime.M3Obj;\n  VAR self_ : %s;\n",
	   M3_TYPE_NAME(m->object));
  list_enumerate (m->arguments, (EnumProc) DeclareLocalArgument, context);
  DeclareCalleeReturnValue(m->returnType, context);
  fprintf (context->file, "\n  BEGIN\n    TRY\n      TRY\n");
  fprintf (context->file, "        leader_ := IluRuntime.InputM3Object(call_, TRUE, %s_x.ObjectType_%s);\n",
	   m3_interface_name(context->class->interface), cstn);
  fprintf (context->file, "        self_ := %s.ILU_Qua_%s(leader_);\n",
	   m3_interface_name(m->object->interface), stn);
  list_enumerate (m->arguments, (EnumProc) ReadLocalArg, context);
  fprintf (context->file, "      FINALLY\n        IluRuntime.RequestRead(call_);\n      END (* try-finally *);\n");
  fprintf (context->file, "    EXCEPT\n");
  fprintf (context->file, "    | IluBasics.Failed (f) =>\n");
  fprintf (context->file, "      IluRuntime.HandleStubFailure1(call_, f);\n      RETURN\n");
  fprintf (context->file, "    | Thread.Alerted => IluRuntime.HandleStubAlert1(call_); RETURN\n");
  fprintf (context->file, "    END (* try-except unmarshalling procedures *);\n\n");
  fprintf (context->file, "    TRY\n      TRY\n        ");
  if (m->returnType != NULL AND type_basic_type(m->returnType) != void_Type)
    fprintf (context->file, "return_value_ := ");
  fprintf (context->file, "self_.%s(", M3_SHORT_METHOD_NAME(m));
  oldFirst = FirstItem;  FirstItem = TRUE;
  list_enumerate (m->arguments, (EnumProc) CalleeListArgument, context);
  FirstItem = oldFirst;
  fprintf (context->file, ");\n      EXCEPT\n");
  ExceptionIndex = 1;
  list_enumerate (m->exceptions, (EnumProc) CatchAndSignalException, context);
  fprintf (context->file, "      | Thread.Alerted =>\n");
  fprintf (context->file, "        IluRuntime.HandleServerProcAlert(call_);\n        RETURN\n");
  fprintf (context->file, "      | IluBasics.Failed (e) =>\n");
  fprintf (context->file, "        IluRuntime.HandleServerProcFail(call_,e);\n        RETURN\n");
  fprintf (context->file, "      END (* try-except errors from service proc *);\n");
  fprintf (context->file, "      IluRuntime.BeginReply (call_, %s, ",
	   (m->exceptions == NULL OR list_size(m->exceptions) == 0) ? "FALSE" : "TRUE");
  SizeValue (m->returnType, "return_value_", context);
  fprintf (context->file, ");\n");
  if (type_basic_type(m->returnType) != void_Type)
    {
      fprintf (context->file, "      TRY\n");
      MarshallValue (m->returnType, "return_value_", context, 8);
      fprintf (context->file, "      FINALLY\n        IluRuntime.FinishReply (call_);\n  END (* try-finally *);\n");
    }
  else
    fprintf (context->file, "      IluRuntime.FinishReply (call_);\n");
  fprintf (context->file, "    EXCEPT\n");
  fprintf (context->file, "    | IluBasics.Failed (f) => IluRuntime.HandleStubFailure2(call_,f);\n");
  fprintf (context->file, "    | Thread.Alerted => IluRuntime.HandleStubAlert2(call_);\n");
  fprintf (context->file, "    END (* try-except marshalling failures *);\n");
  fprintf (context->file, "  END Server__%s_%s;\n\n",
	     M3_SHORT_TYPE_NAME(context->class), M3_SHORT_METHOD_NAME(m));
}

static int MethodIndex;

static void InitializeStubPointer (Procedure method, Context context)
{
  fprintf (context->file, "  IluRuntime.SetMethodStub(%s_x.ObjectType_%s, %u, %u, Server__%s_%s);\n",
	   m3_interface_name(method->object->interface), M3_SHORT_TYPE_NAME(method->object),
	   MethodIndex++, method->id, M3_SHORT_TYPE_NAME(method->object), M3_SHORT_METHOD_NAME(method));
}

extern Class class_object();

static void SetupServerStubsInMethodTable2 (Type t, Context context)
{
  Class od;
  Type type;

  if (t == NULL || ((type = ultimateType(t)) == NULL) || type->marked
      || type_basic_type(type) != object_Type || (od = class_object(type)) == NULL)
    return;

  type->marked = TRUE;

  MethodIndex = 0;
  list_enumerate (od->methods, (EnumProc) InitializeStubPointer, context);
}

static void SetupServerStubsInMethodTable (Type t, Context context)
{
  context->class = t;
  UnmarkSupertypes (t);
  SetupServerStubsInMethodTable2(t, context);
}

static void ClassSetupStubs (Type t, Context context)
{
  Class od;
  Type class;

  if (t == NULL OR (class = ultimateType(t)) == NULL OR class->marked
      OR type_basic_type(class) != object_Type OR (od = class_object(class)) == NULL)
    return;
  t->marked = TRUE;

/*
  list_enumerate (od->superclasses, ClassSetupStubs, context);
*/

  if (list_size(od->methods) > 0)
    list_enumerate (od->methods, (EnumProc) GenerateCalleeStub, context);
}

static void generate_server_code_for_class (Type class, Context context)
{
  context->class = class;
  UnmarkSupertypes (class);
  ClassSetupStubs (class, context);
}

static void generate_server_includes (Context context)
{
  fprintf (context->file, "IMPORT Ilu; <*NOWARN*>\n");
  fprintf (context->file, "IMPORT IluBasics, IluRuntime, Thread;\n");
  fprintf (context->file, "IMPORT %s, %s_x; <*NOWARN*>\n", m3_interface_name(context->interface), m3_interface_name(context->interface));
  list_enumerate (context->interface->imports, (EnumProc) ImportInterface, context);
  fprintf (context->file, "\n");
}

void generate_server_code (Interface parse, FILE *file)
{
  struct context_s context;

  context.file = file;
  context.interface = parse;
  context.class = NULL;
  context.module = ServerModule;

  generate_boilerplate(file, parse);
  fprintf (file, "MODULE %s_s EXPORTS %s, %s_x;\n",
           m3_interface_name(parse), m3_interface_name(parse),
           m3_interface_name(parse));
  generate_server_includes (&context);

  list_enumerate (parse->classes, (EnumProc) generate_server_code_for_class, &context);

  fprintf (file, "BEGIN\n  %s_x.BeStarted();\n", m3_interface_name(parse));
  list_enumerate (parse->classes, (EnumProc) SetupServerStubsInMethodTable, &context);
  fprintf (file, "END %s_s.\n", m3_interface_name(parse));
}
