/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*/

/*
$Id: m3.c,v 1.11 1994/02/09 19:41:24 janssen Exp $
*/

#include <sys/param.h>		/* for MAXPATHLEN */
#include <sys/stat.h>		/* for lstat */
#include <stdlib.h>
#include <unistd.h>		/* for access W_OK */
#include "m3.h"

extern string m3_interface_name(Interface i);

char *OutputDirectory = ".";
char *NamesFile = NULL;

char *ProgramName;

extern boolean ReadSynonyms (string filename);	/* from names.c */

static void GenerateHeaders (Interface parse)
{
  char filename[1000];
  FILE *file;

  sprintf (filename, "%s/%s.i3", OutputDirectory, m3_interface_name(parse));
  if ((file = fopen (filename, "w")) == NULL)
    {
      fprintf (stderr, "Couldn't open output file %s.\n", filename);
      exit (1);
    }
  printf ("description of interface %s to %s...\n", m3_interface_name(parse), filename);
  generate_headers (parse, file);
  fclose (file);

  sprintf (filename, "%s/%s_x.i3", OutputDirectory, m3_interface_name(parse));
  if ((file = fopen (filename, "w")) == NULL)
    {
      fprintf (stderr, "Couldn't open output file %s.\n", filename);
      exit (1);
    }
  printf ("description of interface %s to %s...\n", m3_interface_name(parse), filename);
  generate_support_headers (parse, file);	/* support-code.c */
  fclose (file);
}

static void GenerateCode (Interface parse)
{
  char filename[1000];
  FILE *file;

  sprintf (filename, "%s/%s_y.m3", OutputDirectory, m3_interface_name(parse));
  if ((file = fopen (filename, "w")) == NULL)
    {
      fprintf (stderr, "Couldn't open support code output file %s.\n", filename);
      exit (1);
    }
  printf ("code for general support of %s types, to %s...\n", m3_interface_name(parse), filename);
  generate_support_code (parse, file);		/* support-code.c */
  fclose (file);

  sprintf (filename, "%s/%s_c.m3", OutputDirectory, m3_interface_name(parse));
  if ((file = fopen (filename, "w")) == NULL)
    {
      fprintf (stderr, "Couldn't open server stubs output file %s.\n", filename);
      exit (1);
    }
  printf ("code for client stubs of interface %s to %s...\n", m3_interface_name(parse), filename);
  generate_client_code (parse, file);		/* client.c */
  fclose (file);

  sprintf (filename, "%s/%s_s.m3", OutputDirectory, m3_interface_name(parse));
  if ((file = fopen (filename, "w")) == NULL)
    {
      fprintf (stderr, "Couldn't open server stubs output file %s.\n", filename);
      exit (1);
    }
  printf ("code for server stubs of interface %s to %s...\n", m3_interface_name(parse), filename);
  generate_server_code (parse, file);		/* server.c */
  fclose (file);
}

static boolean makedir (char *dirname)
{
  struct stat s;

  if (stat (dirname, &s) == 0)
    {
      return (S_ISDIR(s.st_mode) AND (access(dirname, W_OK) == 0));
    }
  else
    {
      char buf[1000];
      sprintf (buf, "mkdir %s", dirname);
      return ((system(buf) >> 8) == 0);
    }
}

static void GenerateStubs (Interface parse)
{
  if (! makedir (OutputDirectory))
    {
      fprintf (stderr, "Couldn't create output directory %s.\n", OutputDirectory);
      exit (1);
    }

  GenerateHeaders (parse);
  GenerateCode (parse);
}

static void PrintUsage (void)
{
  fprintf (stderr, "Usage:  %s [-dir OUTPUTDIRECTORY] [-classes] [-renames NAMESFILE] ISLFILE [ISLFILE ...]\n", ProgramName);
}

static boolean ParseArgs (int *pac, char ***pav)
{
  int ac = *pac;
  char **av = *pav;

  ac--;
  av++;
  while (*av[0] == '-')
    {
      if (strcmp(*av, "-dir") == 0)
	OutputDirectory = *++av;
      else if (strcmp(*av, "-renames") == 0)
	NamesFile = *++av;
      else
	{
	  fprintf (stderr, "%s:  Invalid switch \"%s\".\n", ProgramName, *av);
	  PrintUsage();
	  return (FALSE);
	}
      ac--;
      av++;
    }

  *pac = ac;
  *pav = av;
  return (TRUE);
}

#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <sys/errno.h>

int main (int ac, char **av, char **envp)
{
  list s;
  char **filename;
  extern Interface GetInterface(string, string);

  ProgramName = iluparser_GetProgramName(av[0]);

  if (ac < 2)
    {
      PrintUsage();
      exit(1);
    }

  if (!ParseArgs (&ac, &av))
    exit(1);

  if (NamesFile != NULL)
    {
      if (!ReadSynonyms (NamesFile))
	{
	  fprintf (stderr, "Couldn't read names file %s.\n", NamesFile);
	  exit (1);
	};
    };      

  for (filename = av;  *filename != NULL;  filename += 1)
    {
      if ((s = ParseFile(*filename)) == NULL)
	{
	  fprintf (stderr, "Couldn't find or parse %s.\n", *filename);
	  exit (1);
	}
      list_enumerate (s, (void (*) (void *, void *)) GenerateStubs, NULL);
    }
  exit(0);
}
