/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*/

/*
$Id: code.c,v 1.22 1994/03/28 22:27:35 janssen Exp $
*/

#include "m3.h"

static boolean FirstItem = FALSE;

static void generate_support_includes (Context context)
{
  fprintf (context->file, "IMPORT Fmt; <*NOWARN*>\nIMPORT Thread; <*NOWARN*>\nIMPORT Ilu, IluBasics, IluKernel, IluRuntime, M3toC;\n");
  fprintf (context->file, "IMPORT %s; <*NOWARN*>\n", m3_interface_name(context->interface));
  list_enumerate (context->interface->imports, (EnumProc) ImportInterface, context);
  fprintf (context->file, "\n");
}

static void ListException3 (Exception e, Context context)
{
  if (NOT FirstItem)
    fprintf (context->file, ", ");
  else
    FirstItem = FALSE;
  fprintf (context->file, "%s", M3_EXCEPTION_NAME(e));
}

static void GenerateExceptionCatch (Exception e, Context context)
{
  Type type = exception_type(e);

  fprintf (context->file, "    ELSIF exn = %s%sException_Reps.%s THEN\n",
	   (e->importInterfaceName != NULL) ? m3_string(e->importInterfaceName) : "",
	   (e->importInterfaceName != NULL) ? "_x." : "",
	   M3_SHORT_EXCEPTION_NAME(e));
  if (type != NULL && type_basic_type(type) != void_Type)
    {
      if (IsBulkyData(type))
	{
	  fprintf (context->file, "      VAR v_ : %s;\n", M3_TYPE_NAME(type));
	  fprintf (context->file, "      BEGIN\n");
	  UnmarshallValue (context, type, 0, "v_", 10, FALSE);
	  fprintf (context->file, "        RAISE %s(v_);\n", M3_EXCEPTION_NAME(e));
	  fprintf (context->file, "      END\n");
	}
      else
	{
	  fprintf (context->file, "      RAISE %s(", M3_EXCEPTION_NAME(e));
	  UnmarshallValue (context, type, type->def, NULL, 0, FALSE);
	  fprintf (context->file, ");\n");
	}
    }
  else
    fprintf (context->file, "      RAISE %s;\n", M3_EXCEPTION_NAME(e));
}

static void ListException4 (Exception e, Context context)
{
  if (NOT FirstItem)
    fprintf (context->file, ",");
  else
    FirstItem = FALSE;
  fprintf (context->file, "\n        %s%sException_Reps.%s",
	   (e->importInterfaceName != NULL) ? m3_string(e->importInterfaceName) : "",
	   (e->importInterfaceName != NULL) ? "_x." : "",
	   M3_SHORT_EXCEPTION_NAME(e));
}

static void GenerateSupportForMethod (Procedure m, Context context)
{
  boolean oldFirst;

  if (m->exceptions == NULL OR list_size(m->exceptions) == 0 OR m->object->interface != context->interface)
    return;

  fprintf (context->file, "      ExceptionVector__%s_%s := ARRAY [0..%u] OF IluRuntime.Exception {",
	   M3_SHORT_TYPE_NAME(context->class), M3_SHORT_METHOD_NAME(m), list_size(m->exceptions) - 1);
  oldFirst = FirstItem;  FirstItem = TRUE;
  list_enumerate (m->exceptions, (EnumProc) ListException4, context);
  FirstItem = oldFirst;
  fprintf (context->file, "};\n");
}

static void GenerateMethodTableEntry (Procedure m, Context context)
{
  if (NOT FirstItem)
    fprintf (context->file, ",\n");
  else
    FirstItem = FALSE;
  fprintf (context->file, "        IluKernel.Method_Rec{\n");
  fprintf (context->file, "          name := M3toC.TtoS(\"%s\"), id := %u,\n",
	   name_base_name(m->name), m->id);
  fprintf (context->file, "          cacheable := %s, asynchronous := %s,\n",
	   m->functional ? "1" : "0", m->asynch ? "1" : "0");
  if (list_size(m->exceptions) == 0)
    fprintf (context->file, "          exceptionVector := NIL,\n");
  else
    fprintf (context->file, "          exceptionVector := ADR(%s%sExceptionVector__%s_%s[0]),\n",
	     (m->object->interface != context->interface) ? m3_interface_name(m->object->interface) : "",
	     (m->object->interface != context->interface) ? "_x." : "",
	     M3_SHORT_TYPE_NAME(m->object), M3_SHORT_METHOD_NAME(m));
  fprintf (context->file, "          exceptionCount := %u}",
	   list_size(m->exceptions));
}

static void GenerateMethodExceptionVectors (Type st, Context context)
{
  Type t;
  Class od;

  if (st == NULL OR (t = ultimateType(st)) == NULL OR t->marked
      OR type_basic_type(t) != object_Type OR (od = class_object(t)) == NULL)
    return;
  t->marked = TRUE;
  list_enumerate (od->methods, (EnumProc) GenerateSupportForMethod, context);
}

static void GenerateMethodTable (Type st, Context context)
{
  Type t;
  Class od;

  if (st == NULL OR (t = ultimateType(st)) == NULL
      OR type_basic_type(t) != object_Type OR (od = class_object(t)) == NULL)
    return;
  list_enumerate (od->methods, (EnumProc) GenerateMethodTableEntry, context);
}

static cardinal SuperTypeIndex = 0;

static void GenerateSuperTypesArray (Type t, Context context)
{
  extern char *ModulePrefix(Type, Context);
  char *tn = M3_SHORT_TYPE_NAME(context->class);

  fprintf (context->file, "      SuperTypes__%s[%u] := %sObjectType_%s;\n",
	   tn, SuperTypeIndex, ModulePrefix(t, context), M3_SHORT_TYPE_NAME(t));
  fprintf (context->file, "      SuperIds__%s[%u] := SuperTypes__%s[%u].unique_id;\n",
	   tn, SuperTypeIndex, tn, SuperTypeIndex);
  SuperTypeIndex++;
}

static void GenerateSupportForClass (Type c, Context context)
{
  Class od;
  boolean oldFirst;
  char *name = M3_SHORT_TYPE_NAME(c);

  if (c == NULL OR type_basic_type(c) != object_Type)
    return;

  context->class = c;

  fprintf (context->file, "      (* Initialize support for class %s *)\n\n", name);

  od = type_description(c)->structuredDes.object;
  oldFirst = FirstItem;  FirstItem = TRUE;
  UnmarkSupertypes (c);
  GenerateMethodExceptionVectors (c, context);
  FirstItem = oldFirst;

  fprintf (context->file, "      Methods__%s := ARRAY MethodNames__%s OF IluRuntime.Method_Rec {\n", name, name);
  oldFirst = FirstItem;  FirstItem = TRUE;
  UnmarkSupertypes (c);
  GenerateMethodTable (c, context);
  FirstItem = oldFirst;
  fprintf (context->file, "};\n");

  /* generate supertypes and superids */
  SuperTypeIndex = 0;
  list_enumerate(od->superclasses, (EnumProc) GenerateSuperTypesArray, context);

  fprintf (context->file, "      ObjectType_%s :=\n        NEW(IluKernel.ObjectType,\n", name);
  fprintf (context->file, "          name := M3toC.TtoS(\"%s.%s\"),\n",
	   name_base_name(context->interface->name), name_base_name(c->name));
  fprintf (context->file, "          brand := M3toC.TtoS(\"%s\"),\n",
	   od->brand == NULL ? "" : od->brand);
  fprintf (context->file, "          unique_id := M3toC.TtoS(\"%s\"),\n", c->uid);
  fprintf (context->file, "          singleton := %s, collectible := %s,\n",
	   od->singleton ? "1" : "0", od->collectible ? "1" : "0");
  fprintf (context->file, "          authentication := %s%s%s,\n",
	   od->authentication == NULL ? "" : "\"",
	   od->authentication == NULL ? "NIL" : od->authentication,
	   od->authentication == NULL ? "" : "\"");
  if (list_size(od->methods) < 1)
    fprintf (context->file, "          methods := NIL,\n");
  else
    fprintf (context->file, "          methods := ADR(Methods__%s[FIRST(MethodNames__%s)]),\n", name, name);
  fprintf (context->file, "          method_count := %u,\n",
	   list_size(od->methods));
  fprintf (context->file, "          superclass_count := %u,\n", list_size(od->superclasses));
  if (list_size(od->superclasses) < 1)
    {
      fprintf (context->file, "          superclasses := NIL,\n");
      fprintf (context->file, "          superclass_ids := NIL);\n");
    }
  else
    {
      fprintf (context->file, "          superclasses := ADR(SuperTypes__%s[0]),\n", name);
      fprintf (context->file, "          superclass_ids := ADR(SuperIds__%s[0]));\n", name);
    }
  fprintf (context->file, "        <*FATAL IluBasics.Failed*>\n");
  fprintf (context->file, "      BEGIN\n");
  fprintf (context->file, "        IluRuntime.RegisterObjectType(\n");
  fprintf (context->file, "          ObjectType_%s,\n", name);
  fprintf (context->file, "          NEW(IluRuntime.ObjectCreator, apply := Create_Lead__%s));\n",name);
  fprintf (context->file, "      END; (* block for fatal pragma *)\n\n");
}

static void SetupExceptionReps (Exception e, Context context)
{
  if (e->importInterfaceName == NULL)
    fprintf (context->file, "      Exception_Reps.%s := M3toC.TtoS(\"%s\");\n",
	     M3_SHORT_EXCEPTION_NAME(e), name_base_name(e->name));
}

static void GenerateClassRecordAccessors (Type c, Context context)
{
  char *tn = M3_SHORT_TYPE_NAME(c);

  if (c->importInterfaceName == NULL)
    {
      fprintf (context->file, "PROCEDURE ILU_Get_Type_%s (<*UNUSED*> self : Ilu.Object) : Ilu.ObjectType =\n", tn);
      fprintf (context->file, "  BEGIN\n    RETURN ObjectType_%s;\n  END ILU_Get_Type_%s;\n\n", tn, tn);

      fprintf (context->file, "PROCEDURE ILU_Qua_%s (x: Ilu.Object): %s =\n", tn, tn);
      fprintf (context->file, "  VAR ans := x.ILU_Qua_Type(ObjectType_%s);\n", tn);
      fprintf (context->file, "  BEGIN\n    RETURN NARROW(ans, %s);\n  END ILU_Qua_%s;\n\n", tn, tn);
    }
}

static void GenerateExceptionVectorVarForMethod (Procedure m, Context context)
{
  if (m->exceptions == NULL OR list_size(m->exceptions) < 1 OR m->object->interface != context->interface)
    return;

  fprintf (context->file, "VAR ExceptionVector__%s_%s: ARRAY [0..%u] OF IluRuntime.Exception;\n",
	   M3_SHORT_TYPE_NAME(m->object), M3_SHORT_METHOD_NAME(m), list_size(m->exceptions) - 1);
}

static void DeclareVarsForClass (Type c, Context context)
{
  cardinal len;

  list_enumerate (class_object(c)->methods, (EnumProc) GenerateExceptionVectorVarForMethod, context);

  if ((len = list_size(class_object(c)->superclasses)) < 1)
    return;

  fprintf (context->file, "  SuperTypes__%s := ARRAY [0..%u] OF IluRuntime.ObjectType{NIL, ..};\n",
	   M3_SHORT_TYPE_NAME(c), len-1);
  fprintf (context->file, "  SuperIds__%s := ARRAY [0..%u] OF IluRuntime.C_String{NIL, ..};\n",
	   M3_SHORT_TYPE_NAME(c), len-1);
}

static void StartImportedInterface (Imported import, Context context)
{
  Interface i;

  if ((i = GetInterface(import->name, import->filename)) == NULL)
    {
      fprintf (stderr, "Error:  Couldn't find imported interface %s.\n", import->name);
      exit(1);
    }
  else if (ilu_strcasecmp(import->name, "ilu") == 0)
    {
      /* ignore the ILU module */
    }
  else
    fprintf (context->file, "  %s_x.BeStarted();\n", m3_interface_name(i));
}

void generate_support_code (Interface i, FILE *file)
{
  struct context_s context;
  extern void generate_type_io_code(Type type, Context context);
  char *iname = m3_interface_name(i);
  boolean oldFirst;

  context.file = file;
  context.interface = i;
  context.class = NULL;
  context.module = InternalModule;

  generate_boilerplate(file, i);

  fprintf (file, "UNSAFE MODULE %s_y EXPORTS %s, %s_x;\n", iname, iname, iname);
  generate_support_includes(&context);

  list_enumerate (i->types, (EnumProc) generate_type_io_code, &context);		/* io-support-code.c */

  list_enumerate (i->classes, (EnumProc) GenerateClassRecordAccessors, &context);

  fprintf (file, "\nVAR\n  started := FALSE;\n\n");
  list_enumerate (i->classes, (EnumProc) DeclareVarsForClass, &context);

  fprintf (file, "\nPROCEDURE BeStarted() =\n  BEGIN\n    IF NOT started THEN\n      started := TRUE;\n\n");
  if (i->exceptions != NULL AND list_size(i->exceptions) > 0)
    list_enumerate (i->exceptions, (EnumProc) SetupExceptionReps, &context);
  fprintf (file, "\n");
  list_enumerate (i->classes, (EnumProc) GenerateSupportForClass, &context);
  fprintf (file, "    END; (* IF started *)\n");
  fprintf (file, "  END BeStarted;\n\n");

  if (i->exceptions != NULL AND list_size(i->exceptions) > 0)
    {
      fprintf (file, "PROCEDURE ReSignal_Exception (call_: IluRuntime.Call; scode: INTEGER)\n");
      fprintf (file, "  RAISES {IluBasics.Failed, Thread.Alerted");

      oldFirst = FirstItem;  FirstItem = FALSE;
      list_enumerate (i->exceptions, (EnumProc) ListException3, &context);
      FirstItem = oldFirst;

      fprintf (file, "} =\n");
      fprintf (file, "  VAR exn: IluRuntime.Exception;\n");
      fprintf (file, "  BEGIN\n    IF scode < 0 OR scode > call_.method.exceptionCount THEN\n");
      fprintf (file, "      RAISE IluBasics.Failed(NEW(IluBasics.Failure, info := \"unknown exception code \" & Fmt.Int(scode)))\n    END;\n");
      fprintf (file, "    exn := IluKernel.ilu_ExceptionOfMethod(call_.method, scode);\n");
      fprintf (file, "    IF exn = NIL THEN\n");
      fprintf (file, "      RAISE IluBasics.Failed(NEW(IluBasics.Failure, info := \"bogus exception code \" & Fmt.Int(scode)));\n");
      list_enumerate (i->exceptions, (EnumProc) GenerateExceptionCatch, &context);
      fprintf (file, "    ELSE\n      RAISE\n         IluBasics.Failed(NEW(IluBasics.Failure, info := \"bogus exception code \" & Fmt.Int(scode)));\n");
      fprintf (file, "    END (* case exn *);\n  END ReSignal_Exception;\n\n");
    }

  fprintf (file, "BEGIN\n");
  list_enumerate (context.interface->imports, (EnumProc) StartImportedInterface, &context);
  fprintf (file, "END %s_y.\n", iname);
}
