/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*/

/*
$Id: lisp.c,v 1.11 1994/05/05 23:19:17 janssen Exp $
*/

#include <sys/types.h>
#include <sys/stat.h>		/* for lstat */
#include <sys/param.h>		/* for MAXPATHLEN */
#include <stdlib.h>
#include <unistd.h>		/* for access W_OK */

#include "lisp.h"

typedef int Boolean;

#define EOS  '\0'
#define DOT	'.'

extern string lisp_interface_name(Interface i);

char *OutputDirectory = NULL;
char *ProgramName = NULL;
boolean GenerateSysdcl = FALSE;
boolean GenerateServerSkeleton = FALSE;
boolean GenerateServerStubs = FALSE;
boolean GenerateBasics = FALSE;
boolean GenerateClassRecord = FALSE;

extern void GenerateCRecord(Type class, FILE *file);
extern void GenerateSStubs(Interface interface, FILE *file);
extern void GenerateTypeStubs();
extern void GenerateClassStubs();
extern void set_default_interface(Interface i);
static void generate_boilerplate(FILE *file, Interface parse);
static void generate_c_boilerplate(FILE *file, Interface parse);
extern void ExportPackage (Interface, FILE *);
extern void GenerateTypeDefinitions (Interface, FILE *);
extern void GenerateTypeCode (Interface, FILE *);
extern void GenerateExceptionDefinitions (Interface, FILE *);
extern void GenerateExceptionCode (Interface, FILE *);
extern void GenerateSystemDeclaration (Interface, char *directory_name);

static void DoClasses (Interface parse)
{
  char filename[1000];
  FILE *file;

  if (GenerateBasics)
    {
      sprintf (filename, "%s/%s-basics.lisp", OutputDirectory, lisp_interface_name(parse));
      if ((file = fopen (filename, "w")) == NULL)
	{
	  fprintf (stderr, "Couldn't open output file %s.\n", filename);
	  exit (1);
	}
      printf ("basics file for interface %s to %s...\n", interface_name(parse), filename);
      generate_boilerplate (file, parse);
      ExportPackage (parse, file);
      GenerateTypeDefinitions (parse, file);
      GenerateTypeCode (parse, file);
      GenerateExceptionDefinitions (parse, file);
      GenerateExceptionCode (parse, file);
      fclose (file);
    }

  if (GenerateClassRecord && (list_size(parse->classes) > 0))
    {
      sprintf (filename, "%s/%s-class-records.c", OutputDirectory, lisp_interface_name(parse));
      if ((file = fopen (filename, "w")) == NULL)
	{
	  fprintf (stderr, "Couldn't open output file %s.\n", filename);
	  exit (1);
	}
      printf ("class records for interface %s to %s...\n", interface_name(parse), filename);
      generate_c_boilerplate (file, parse);
      fprintf (file, "#include <rpc/types.h>\n#include <ilu.h>\n\n");

      list_enumerate (parse->classes, (EnumProc) GenerateCRecord, file);
      fclose (file);
    }

  if (GenerateServerStubs && (list_size(parse->classes) > 0))
    {
      sprintf (filename, "%s/%s-server-procs.lisp", OutputDirectory, lisp_interface_name(parse));
      if ((file = fopen (filename, "w")) == NULL)
	{
	  fprintf (stderr, "Couldn't open output file %s.\n", filename);
	  exit (1);
	}
      printf ("server stubs for interface %s to %s...\n", interface_name(parse), filename);
      generate_boilerplate (file, parse);
      GenerateSStubs (parse, file);
      fclose (file);
    }
}

static boolean makedir (char *dirname)
{
  struct stat s;

  if (stat (dirname, &s) == 0)
    {
      return (S_ISDIR(s.st_mode) AND (access(dirname, W_OK) == 0));
    }
  else
    {
      char buf[1000];
      sprintf (buf, "mkdir %s", dirname);
      return ((system(buf) >> 8) == 0);
    }
}

static void GenerateStubs (Interface parse)
{
  set_default_interface (parse);

  if (! makedir (OutputDirectory))
    {
      fprintf (stderr, "Couldn't create output directory %s.\n", OutputDirectory);
      exit (1);
    }

  DoClasses(parse);

  if (GenerateSysdcl)
    GenerateSystemDeclaration(parse, OutputDirectory);

/*
  if (GenerateClassRecord)
    CompileC (parse);
*/
}

static void PrintUsage (void)
{
  fprintf (stderr, "Usage:  %s [-dir OUTPUTDIRECTORY] [-sysdcl] [-serverskeleton] [-serverstubs] [-basics] [-classrecord] ISLFILE [ISLFILE ...]\n", ProgramName);
}

static boolean ParseArgs (int *pac, char ***pav)
{
  int ac = *pac;
  char **av = *pav;

  ac--;
  av++;
  while (*av[0] == '-')
    {
      if (strcmp(*av, "-dir") == 0)
	OutputDirectory = *++av;
      else if (strcmp(*av, "-sysdcl") == 0)
	GenerateSysdcl = TRUE;
      else if (strcmp(*av, "-serverskeleton") == 0)
	GenerateServerSkeleton = TRUE;
      else if (strcmp(*av, "-serverstubs") == 0)
	GenerateServerStubs = TRUE;
      else if (strcmp(*av, "-basics") == 0)
	GenerateBasics = TRUE;
      else if (strcmp(*av, "-classrecord") == 0)
	GenerateClassRecord = TRUE;
      else
	{
	  fprintf (stderr, "%s:  Invalid switch \"%s\".\n", ProgramName, *av);
	  PrintUsage();
	  return (FALSE);
	}
      ac--;
      av++;
    }

  if (OutputDirectory == NULL)
    {
      char dir[1000];

      getcwd(dir, sizeof(dir));
      OutputDirectory = ilu_strdup(dir + ((strncmp(dir, "/tmp_mnt", 8) == 0) ? 8 : 0));
    }

  if (!(GenerateServerSkeleton || GenerateSysdcl || GenerateClassRecord || GenerateBasics || GenerateServerStubs))
    {
      GenerateBasics = TRUE;
      GenerateClassRecord = TRUE;
      GenerateServerStubs = TRUE;
      GenerateSysdcl = TRUE;
    }

  *pac = ac;
  *pav = av;
  return (TRUE);
}

int main (int ac, char **av, char **envp)
{
  list s;
  char **filename;
  extern Interface GetInterface(string, string);

  ProgramName = iluparser_GetProgramName(av[0]);

  if (ac < 2)
    {
      PrintUsage();
      exit(1);
    }

  if (!ParseArgs (&ac, &av))
    exit(1);

  for (filename = av;  *filename != NULL;  filename += 1)
    {
      if ((s = ParseFile(*filename)) == NULL)
	{
	  fprintf (stderr, "Couldn't find or parse %s.\n", *filename);
	  exit (1);
	}
      list_enumerate(s, (EnumProc) GenerateStubs, NULL);
    }
  exit(0);
}

#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>

extern Interface GetInterface(string, string);

static char *ModTime (char *path)
{
  static char timebuf[30];
  struct stat statbuf;

  stat (path, &statbuf);
  strcpy (timebuf, ctime(&statbuf.st_mtime));
  timebuf[24] = '\0';
  return (timebuf);
}

static char *GoodGetLogin (void)
{
  char *name;
  struct passwd *pw;

  if (((name = cuserid(NULL)) == NULL)
      && (name = (char *) getlogin()) == NULL
      && (name = (char *) (((pw = getpwuid(getuid())) == NULL) ? NULL : pw->pw_name)) == NULL
      && (name = (char *) getenv("USER")) == NULL)
    return "nobody";
  else
    return name;
}

static void PrintImportedFileInfo (Imported s, FILE *file)
{
  Interface i = GetInterface (s->name, s->filename);
  fprintf (file, ",\n;;; and \"%s\" of %s GMT", i->filename, ModTime(i->filename));	   
}

static void generate_boilerplate (FILE *file, Interface parse)
{
  time_t clock = time(0);
  char *now;

  now = ilu_strdup(asctime(localtime(&clock)));
  now[strlen(now) - 1] = '\0';
  
  fprintf (file, ";;; -*- Mode:Lisp;  Package: %s;  Syntax: COMMON-LISP;  Base: 10 -*-\n",
	   lisp_interface_name(parse));
  fprintf (file, ";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;\n");
  fprintf (file, ";;; this file was automatically generated\n;;; at %s GMT by %s\n;;; running \"%s\" of %s GMT\n",
	   now, GoodGetLogin(), ProgramName, ModTime(ProgramName));
  fprintf (file, ";;; on \"%s\" of %s GMT", parse->filename, ModTime(parse->filename));
  if (list_size(parse->imports) > 0)
    list_enumerate (parse->imports, (EnumProc) PrintImportedFileInfo, file);
  fprintf (file, ".\n;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;\n\n");
}

static void PrintImportedFileInfoForC (Imported s, FILE *file)
{
  Interface i = GetInterface (s->name, s->filename);
  fprintf (file, ",\n * and \"%s\" of %s (GMT)", i->filename, ModTime(i->filename));	   
}

static void generate_c_boilerplate (FILE *file, Interface parse)
{
  time_t clock = time(0);
  char *now;

  now = ilu_strdup(asctime(localtime(&clock)));
  now[strlen(now) - 1] = '\0';
  
  fprintf (file, "/* this file was automatically generated\n * at %s (GMT) by %s\n * running \"%s\" of %s (GMT)\n",
	   now, GoodGetLogin(), ProgramName, ModTime(ProgramName));
  fprintf (file, " * on \"%s\" of %s (GMT)", parse->filename, ModTime(parse->filename));
  if (list_size(parse->imports) > 0)
    list_enumerate (parse->imports, (EnumProc) PrintImportedFileInfoForC, file);
  fprintf (file, ".\n */\n\n");
}

