/*
 *======================================================================
 *
 *Copyright 1992 Sun Microsystems, Inc.
 *
 *The Interface Definition Language Compiler Front End (CFE) is made
 *available for use provided that this legend is included on all media and
 *documentation and as a part of the software program in whole or part.
 *Users may copy and extend functionality (but may not remove
 *functionality) of the Interface Definition Language CFE without charge,
 *but are not authorized to license or distribute it to anyone else except
 *as part of a product or program developed by the user or with the express
 *written consent of Sun Microsystems, Inc.
 *
 *The names of Sun Microsystems, Inc. and any of its subsidiaries may not
 *be used in advertising or publicity pertaining to distribution of
 *Interface Definition Language CFE as permitted herein.
 *
 *The Interface Definition Language CFE may not be exported outside the
 *United States without first obtaining the appropriate government
 *approvals.
 *
 *INTERFACE DEFINITION LANGUAGE CFE IS PROVIDED AS IS WITH NO WARRANTIES
 *OF ANY KIND INCLUDING THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND
 *FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR ARISING FROM A
 *COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 *Interface Definition Language CFE is provided with no support and
 *without any obligation on the part of Sun Microsystems, Inc. or any of
 *its subsidiaries or affiliates to assist in its use, correction,
 *modification or enhancement.
 *
 *SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR AFFILIATES SHALL
 *HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT OF COPYRIGHTS, TRADE
 *SECRETS OR ANY PATENTS BY INTERFACE DEFINITION LANGUAGE CFE OR ANY PART
 *THEREOF.
 *
 *IN NO EVENT WILL SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR
 *AFFILIATES BE LIABLE FOR ANY LOST REVENUE OR PROFITS OR OTHER SPECIAL,
 *INDIRECT AND CONSEQUENTIAL DAMAGES, EVEN IF SUN HAS BEEN ADVISED OF THE
 *POSSIBILITY OF SUCH DAMAGES.
 *
 *SunSoft, Inc.  
 *2550 Garcia Avenue 
 *Mountain View, California  94043
 *
 *
 *
 *
 *======================================================================
 *
 * Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  
 *
 * Unlimited use, reproduction, and distribution of this software is
 * permitted.  Any copy of this software must include both the above
 * copyright notice of Xerox Corporation and this paragraph.  Any
 * distribution of this software must comply with all applicable United
 * States export control laws.  This software is made available AS IS,
 * and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
 * PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
 * THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
 * CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
 * XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 *
 *======================================================================
 */

#ifndef _BE_GENERATOR_BE_GENERATOR_HH
#define _BE_GENERATOR_BE_GENERATOR_HH

#pragma ident "%@(#)be_generator.h	1.20% %92/06/10% Sun Microsystems"
// $Id: be_generator.hh,v 1.4 1993/09/23 17:46:57 severson Exp $

// be_generator.hh
//
// Defines BE class for generator
//
// This defines the same protocol as the AST_Generator class but actually
// is implemented to create nodes of AST classes subclassed in this BE

/*
** DEPENDENCIES: AST_Generator.h
**
** USE: Included from be.h
*/

class	be_generator : public AST_Generator {
public:
  // Operations
  virtual AST_PredefinedType
    *create_predefined_type(AST_PredefinedType::PredefinedType t,
			    UTL_ScopedName *n,
			    UTL_StrList *p);

  virtual AST_Module	*create_module(UTL_ScopedName *n, UTL_StrList *p);
  virtual AST_Root	*create_root(UTL_ScopedName *n, UTL_StrList *p);
  virtual AST_Interface	*create_interface(UTL_ScopedName *n,
					  AST_Interface **ih,
					  long nih,
					  UTL_StrList *p);
  virtual AST_InterfaceFwd *create_interface_fwd(UTL_ScopedName *n,
						 UTL_StrList *p);
  virtual AST_Exception	*create_exception(UTL_ScopedName *n, UTL_StrList *p);
  virtual AST_Structure	*create_structure(UTL_ScopedName *n, UTL_StrList *p);
  virtual AST_Enum	*create_enum(UTL_ScopedName *n, UTL_StrList *p);
  virtual AST_Operation	*create_operation(AST_Type *rt,
					  AST_Operation::Flags fl,
					  UTL_ScopedName *n,
					  UTL_StrList *p);
  virtual AST_Field	*create_field(AST_Type *ft, UTL_ScopedName *n,
				      UTL_StrList *p);
  virtual AST_Argument	*create_argument(AST_Argument::Direction d,
					 AST_Type *ft,
					 UTL_ScopedName *n,
					 UTL_StrList *p);
  virtual AST_Attribute	*create_attribute(boolean ro,
					  AST_Type *ft,
					  UTL_ScopedName *n,
					  UTL_StrList *p);
  virtual AST_Union	*create_union(AST_ConcreteType *dt,
				      UTL_ScopedName *n,
				      UTL_StrList *p);
  virtual AST_UnionBranch *create_union_branch(AST_UnionLabel *lab,
					       AST_Type *ft,
					       UTL_ScopedName *n,
					       UTL_StrList *p);
  virtual AST_UnionLabel *create_union_label(AST_UnionLabel::UnionLabel ul,
					     AST_Expression *lv);
  virtual AST_Constant	*create_constant(AST_Expression::ExprType et,
					 AST_Expression *ev,
					 UTL_ScopedName *n,
					 UTL_StrList *p);

  virtual AST_Expression	*create_expr(UTL_ScopedName *n);
  virtual AST_Expression	*create_expr(AST_Expression *v,
					     AST_Expression::ExprType t);
  virtual AST_Expression	*create_expr(AST_Expression::ExprComb c,
					     AST_Expression *v1,
					     AST_Expression *v2);
  virtual AST_Expression	*create_expr(long v);
  virtual AST_Expression	*create_expr(long v,
					     AST_Expression::ExprType t);
  virtual AST_Expression	*create_expr(unsigned long v);
  virtual AST_Expression	*create_expr(String *s);
  virtual AST_Expression	*create_expr(char c);
  virtual AST_Expression	*create_expr(double d);

  virtual AST_EnumVal	*create_enum_val(unsigned long v,
					 UTL_ScopedName *n,
					 UTL_StrList *p);
  virtual AST_Array	*create_array(UTL_ScopedName *n,
				      unsigned long ndims,
				      UTL_ExprList *dims);
  virtual AST_Sequence	*create_sequence(AST_Expression *v, AST_Type *bt);
  virtual AST_String	*create_string(AST_Expression *v);
  virtual AST_Typedef	*create_typedef(AST_Type *bt,
					UTL_ScopedName *n,
					UTL_StrList *p);
};

#endif           // _BE_GENERATOR_BE_GENERATOR_HH
