/*
 *======================================================================
 *
 *Copyright 1992 Sun Microsystems, Inc.
 *
 *The Interface Definition Language Compiler Front End (CFE) is made
 *available for use provided that this legend is included on all media and
 *documentation and as a part of the software program in whole or part.
 *Users may copy and extend functionality (but may not remove
 *functionality) of the Interface Definition Language CFE without charge,
 *but are not authorized to license or distribute it to anyone else except
 *as part of a product or program developed by the user or with the express
 *written consent of Sun Microsystems, Inc.
 *
 *The names of Sun Microsystems, Inc. and any of its subsidiaries may not
 *be used in advertising or publicity pertaining to distribution of
 *Interface Definition Language CFE as permitted herein.
 *
 *The Interface Definition Language CFE may not be exported outside the
 *United States without first obtaining the appropriate government
 *approvals.
 *
 *INTERFACE DEFINITION LANGUAGE CFE IS PROVIDED AS IS WITH NO WARRANTIES
 *OF ANY KIND INCLUDING THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND
 *FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR ARISING FROM A
 *COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 *Interface Definition Language CFE is provided with no support and
 *without any obligation on the part of Sun Microsystems, Inc. or any of
 *its subsidiaries or affiliates to assist in its use, correction,
 *modification or enhancement.
 *
 *SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR AFFILIATES SHALL
 *HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT OF COPYRIGHTS, TRADE
 *SECRETS OR ANY PATENTS BY INTERFACE DEFINITION LANGUAGE CFE OR ANY PART
 *THEREOF.
 *
 *IN NO EVENT WILL SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR
 *AFFILIATES BE LIABLE FOR ANY LOST REVENUE OR PROFITS OR OTHER SPECIAL,
 *INDIRECT AND CONSEQUENTIAL DAMAGES, EVEN IF SUN HAS BEEN ADVISED OF THE
 *POSSIBILITY OF SUCH DAMAGES.
 *
 *SunSoft, Inc.  
 *2550 Garcia Avenue 
 *Mountain View, California  94043
 *
 *
 *
 *
 *======================================================================
 */

#pragma ident "%@(#)utl_list.cc	1.34% %92/06/10% Sun Microsystems"

// utl_list.cc
//
// Implementation of generic single-linked lists

#include	<idl.hh>
#include	<idl_extern.hh>

/*
 * Constructor(s)
 */

UTL_List::UTL_List(UTL_List *c)
	: pd_cdr_data(c) 
{
}

/*
 * Private operations
 */

// Compute list length
long
UTL_List::list_length(long n)
{
  if (pd_cdr_data == NULL)
    return n;
  else
    return pd_cdr_data->list_length(n+1);
}

/*
 * Public operations
 */

// Smash last cdr with l
void
UTL_List::nconc(UTL_List *l)
{
  if (pd_cdr_data == NULL)
    pd_cdr_data = l;
  else
    pd_cdr_data->nconc(l);
}

/*
 * Override this operation to copy lists of other types
 */
// Copy a list
UTL_List *
UTL_List::copy()
{
  if (pd_cdr_data == NULL)
    return new UTL_List(NULL);
  return new UTL_List(pd_cdr_data->copy());
}

// Get next list
UTL_List *
UTL_List::tail()
{
  return pd_cdr_data;
}

// Set next list
void
UTL_List::set_tail(UTL_List *l)
{
  pd_cdr_data = l;
}

// Compute list length
long
UTL_List::length()
{
  return list_length(1);
}

/*
 * Redefinition of inherited virtual operations
 */

// UTL_List active iterator

/*
 * Constructor
 */

UTL_ListActiveIterator::UTL_ListActiveIterator(UTL_List *s)
		      : source(s)
{
}

/*
 * Private operations
 */

/*
 * Public operations
 */

// Is iterator done?
long
UTL_ListActiveIterator::is_done()
{
  return (source == NULL) ? TRUE : FALSE;
}

// Advance to next item
void
UTL_ListActiveIterator::next()
{
  if (source != NULL)
    source = source->tail();
}

/*
 * Redefinition of inherited operations
 */

