/*
 *======================================================================
 *
 *Copyright 1992 Sun Microsystems, Inc.
 *
 *The Interface Definition Language Compiler Front End (CFE) is made
 *available for use provided that this legend is included on all media and
 *documentation and as a part of the software program in whole or part.
 *Users may copy and extend functionality (but may not remove
 *functionality) of the Interface Definition Language CFE without charge,
 *but are not authorized to license or distribute it to anyone else except
 *as part of a product or program developed by the user or with the express
 *written consent of Sun Microsystems, Inc.
 *
 *The names of Sun Microsystems, Inc. and any of its subsidiaries may not
 *be used in advertising or publicity pertaining to distribution of
 *Interface Definition Language CFE as permitted herein.
 *
 *The Interface Definition Language CFE may not be exported outside the
 *United States without first obtaining the appropriate government
 *approvals.
 *
 *INTERFACE DEFINITION LANGUAGE CFE IS PROVIDED AS IS WITH NO WARRANTIES
 *OF ANY KIND INCLUDING THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND
 *FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR ARISING FROM A
 *COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 *Interface Definition Language CFE is provided with no support and
 *without any obligation on the part of Sun Microsystems, Inc. or any of
 *its subsidiaries or affiliates to assist in its use, correction,
 *modification or enhancement.
 *
 *SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR AFFILIATES SHALL
 *HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT OF COPYRIGHTS, TRADE
 *SECRETS OR ANY PATENTS BY INTERFACE DEFINITION LANGUAGE CFE OR ANY PART
 *THEREOF.
 *
 *IN NO EVENT WILL SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR
 *AFFILIATES BE LIABLE FOR ANY LOST REVENUE OR PROFITS OR OTHER SPECIAL,
 *INDIRECT AND CONSEQUENTIAL DAMAGES, EVEN IF SUN HAS BEEN ADVISED OF THE
 *POSSIBILITY OF SUCH DAMAGES.
 *
 *SunSoft, Inc.  
 *2550 Garcia Avenue 
 *Mountain View, California  94043
 *
 *
 *
 *
 *======================================================================
 */

#pragma ident "%@(#)utl_global.cc	1.19% %92/06/10% Sun Microsystems"

// utl_global.cc - Implementation of class IDL_GlobalData
//

#include	<idl.hh>
#include	<idl_extern.hh>

// Define an increment for the size of the array used to store names of
// included files
#undef		INCREMENT
#define		INCREMENT	64

// Get or set scopes stack
UTL_ScopeStack *
IDL_GlobalData::scopes()
{
  return pd_scopes;
}
void
IDL_GlobalData::set_scopes(UTL_ScopeStack *s)
{
  pd_scopes = s;
}

// Get or set root of AST
AST_Root *
IDL_GlobalData::root()
{
  return pd_root;
}
void
IDL_GlobalData::set_root(AST_Root *r)
{
  pd_root = r;
}

// Get or set generator object
AST_Generator *
IDL_GlobalData::gen()
{
  return pd_gen;
}
void
IDL_GlobalData::set_gen(AST_Generator *g)
{
  pd_gen = g;
}

// Get or set error object
UTL_Error *
IDL_GlobalData::err()
{
  return pd_err;
}
void
IDL_GlobalData::set_err(UTL_Error *e)
{
  pd_err = e;
}

// Get or set error count
long
IDL_GlobalData::err_count()
{
  return pd_err_count;
}
void
IDL_GlobalData::set_err_count(long c)
{
  pd_err_count = c;
}

// Get or set line number
long
IDL_GlobalData::lineno()
{
  return pd_lineno;
}
void
IDL_GlobalData::set_lineno(long n)
{
  pd_lineno = n;
}

// Get or set file name being read now
String *
IDL_GlobalData::filename()
{
  return pd_filename;
}
void
IDL_GlobalData::set_filename(String *f)
{
  pd_filename = f;
}

// Get or set main file name
String *
IDL_GlobalData::main_filename()
{
  return pd_main_filename;
}
void
IDL_GlobalData::set_main_filename(String *n)
{
  pd_main_filename = n;
}

// Get or set indicator whether we're reading the main file now
boolean
IDL_GlobalData::in_main_file()
{
  return pd_in_main_file;
}
void
IDL_GlobalData::set_in_main_file(boolean is_in)
{
  pd_in_main_file = is_in;
}

// Get or set cache value for argv[0]
char *
IDL_GlobalData::prog_name()
{
  return pd_prog_name;
}
void
IDL_GlobalData::set_prog_name(char *pn)
{
  pd_prog_name = pn;
}

// Get or set location to find C preprocessor
char *
IDL_GlobalData::cpp_location()
{
  return pd_cpp_location;
}
void
IDL_GlobalData::set_cpp_location(char *l)
{
  pd_cpp_location = l;
}

// Get or set IDL compiler flags
long
IDL_GlobalData::compile_flags()
{
  return pd_compile_flags;
}
void
IDL_GlobalData::set_compile_flags(long cf)
{
  pd_compile_flags = cf;
}

// Get or set BE to be used
char *
IDL_GlobalData::be()
{
  return pd_be;
}
void
IDL_GlobalData::set_be(char *nbe)
{
  pd_be = nbe;
}

// Get or set local escapes string. This provides additional mechanism
// to pass information to a BE.
char *
IDL_GlobalData::local_escapes()
{
  return pd_local_escapes;
}
void
IDL_GlobalData::set_local_escapes(char *e)
{
  pd_local_escapes = e;
}

// Get or set indent object
UTL_Indenter *
IDL_GlobalData::indent()
{
  return pd_indent;
}
void
IDL_GlobalData::set_indent(UTL_Indenter *i)
{
  pd_indent = i;
}

// Get or set list of pragmas being parsed
UTL_StrList *
IDL_GlobalData::pragmas()
{
  UTL_StrList *p = pd_pragmas;

  pd_pragmas = NULL;
  return p;
}
void
IDL_GlobalData::set_pragmas(UTL_StrList *p)
{
  pd_pragmas = p;
}

// Get or set indicator whether we're reading from stdin
boolean
IDL_GlobalData::read_from_stdin()
{
  return pd_read_from_stdin;
}
void
IDL_GlobalData::set_read_from_stdin(boolean r)
{
  pd_read_from_stdin = r;
}

// Have we seen this include file name before?
long
IDL_GlobalData::seen_include_file_before(String *n)
{
  unsigned long i;

  for (i = 0; i < pd_n_include_file_names; i++)
    if (n->compare(pd_include_file_names[i]))
      return TRUE;
  return FALSE;
}

// Store a name of an #include file
void
IDL_GlobalData::store_include_file_name(String *n)
{
  String	**o_include_file_names;
  unsigned long	  o_n_alloced_file_names,
		  i;

  /*
   * Check if we need to store it at all or whether we've seen it already
   */
  if (seen_include_file_before(n))
    return;
  /*
   * OK, need to store. Make sure there's space for one more string
   */
  if (pd_n_include_file_names == pd_n_alloced_file_names) {
    if (pd_n_alloced_file_names == 0) {
      pd_n_alloced_file_names = INCREMENT;
      pd_include_file_names = new String *[pd_n_alloced_file_names];
    } else {
      o_include_file_names = pd_include_file_names;
      o_n_alloced_file_names = pd_n_alloced_file_names;
      pd_n_alloced_file_names += INCREMENT;
      pd_include_file_names = new String *[pd_n_alloced_file_names];
      for (i = 0; i < o_n_alloced_file_names; i++)
        pd_include_file_names[i] = o_include_file_names[i];
      delete o_include_file_names;
    }
  }
  /*
   * Store it
   */
  pd_include_file_names[pd_n_include_file_names++] = n;
}

void
IDL_GlobalData::set_include_file_names(String **ns)
{
  pd_include_file_names = ns;
}

String **
IDL_GlobalData::include_file_names()
{
  return pd_include_file_names;
}

void
IDL_GlobalData::set_n_include_file_names(unsigned long n)
{
  pd_n_include_file_names = n;
}

unsigned long
IDL_GlobalData::n_include_file_names()
{
  return pd_n_include_file_names;
}

void
IDL_GlobalData::set_parse_state(ParseState ps)
{
  pd_parse_state = ps;
}

IDL_GlobalData::ParseState
IDL_GlobalData::parse_state()
{
  return pd_parse_state;
}

/*
 * Convert a PredefinedType to an ExprType
 */
AST_Expression::ExprType
IDL_GlobalData::PredefinedTypeToExprType(AST_PredefinedType::PredefinedType pt)
{
  switch (pt) {
  case AST_PredefinedType::PT_long:
    return AST_Expression::EV_long;
  case AST_PredefinedType::PT_ulong:
    return AST_Expression::EV_ulong;
  case AST_PredefinedType::PT_short:
    return AST_Expression::EV_short;
  case AST_PredefinedType::PT_ushort:
    return AST_Expression::EV_ushort;
  case AST_PredefinedType::PT_float:
    return AST_Expression::EV_float;
  case AST_PredefinedType::PT_double:
    return AST_Expression::EV_double;
  case AST_PredefinedType::PT_char:
    return AST_Expression::EV_char;
  case AST_PredefinedType::PT_octet:
    return AST_Expression::EV_octet;
  case AST_PredefinedType::PT_boolean:
    return AST_Expression::EV_bool;
  default:
    return AST_Expression::EV_any;
  }
}
