/*
 *======================================================================
 *
 *Copyright 1992 Sun Microsystems, Inc.
 *
 *The Interface Definition Language Compiler Front End (CFE) is made
 *available for use provided that this legend is included on all media and
 *documentation and as a part of the software program in whole or part.
 *Users may copy and extend functionality (but may not remove
 *functionality) of the Interface Definition Language CFE without charge,
 *but are not authorized to license or distribute it to anyone else except
 *as part of a product or program developed by the user or with the express
 *written consent of Sun Microsystems, Inc.
 *
 *The names of Sun Microsystems, Inc. and any of its subsidiaries may not
 *be used in advertising or publicity pertaining to distribution of
 *Interface Definition Language CFE as permitted herein.
 *
 *The Interface Definition Language CFE may not be exported outside the
 *United States without first obtaining the appropriate government
 *approvals.
 *
 *INTERFACE DEFINITION LANGUAGE CFE IS PROVIDED AS IS WITH NO WARRANTIES
 *OF ANY KIND INCLUDING THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND
 *FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR ARISING FROM A
 *COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 *Interface Definition Language CFE is provided with no support and
 *without any obligation on the part of Sun Microsystems, Inc. or any of
 *its subsidiaries or affiliates to assist in its use, correction,
 *modification or enhancement.
 *
 *SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR AFFILIATES SHALL
 *HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT OF COPYRIGHTS, TRADE
 *SECRETS OR ANY PATENTS BY INTERFACE DEFINITION LANGUAGE CFE OR ANY PART
 *THEREOF.
 *
 *IN NO EVENT WILL SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR
 *AFFILIATES BE LIABLE FOR ANY LOST REVENUE OR PROFITS OR OTHER SPECIAL,
 *INDIRECT AND CONSEQUENTIAL DAMAGES, EVEN IF SUN HAS BEEN ADVISED OF THE
 *POSSIBILITY OF SUCH DAMAGES.
 *
 *SunSoft, Inc.  
 *2550 Garcia Avenue 
 *Mountain View, California  94043
 *
 *
 *
 *
 *======================================================================
 */

#pragma ident "%@(#)nr_narrowk.cc	1.1% %92/06/15% Sun Microsystems"

#include	<idl.hh>
#include	<idl_extern.hh>

// Narrowing functions for AST

/*
 * Convert a UTL_Scope node into an AST_Decl node if possible
 */
AST_Decl *
ScopeAsDecl(UTL_Scope *s)
{
  switch (s->scope_node_type()) {
  case AST_Decl::NT_module:
    return AST_Module::narrow_from_scope(s);
  case AST_Decl::NT_interface:
    return AST_Interface::narrow_from_scope(s);
  case AST_Decl::NT_op:
    return AST_Operation::narrow_from_scope(s);
  case AST_Decl::NT_except:
    return AST_Exception::narrow_from_scope(s);
  case AST_Decl::NT_union:
    return AST_Union::narrow_from_scope(s);
  case AST_Decl::NT_struct:
    return AST_Structure::narrow_from_scope(s);
  case AST_Decl::NT_enum:
    return AST_Enum::narrow_from_scope(s);
  default:
    return NULL;
  }
}

/*
 * Convert an AST_Decl to a UTL_Scope if possible
 */
UTL_Scope *
DeclAsScope(AST_Decl *d)
{
   switch (d->node_type()) {
   case AST_Decl::NT_interface_fwd:
      /*
       * Resolve forward declared interface by looking at full_definition()
       * field and iterating
       */
      d = (AST_InterfaceFwd::narrow_from_decl(d))->full_definition();
      /*
       * Fall through
       */
   case AST_Decl::NT_interface:
      return AST_Interface::narrow_from_decl(d);
   case AST_Decl::NT_module:
      return AST_Module::narrow_from_decl(d);
   case AST_Decl::NT_except:
      return AST_Exception::narrow_from_decl(d);
   case AST_Decl::NT_union:
      return AST_Union::narrow_from_decl(d);
   case AST_Decl::NT_struct:
      return AST_Structure::narrow_from_decl(d);
   case AST_Decl::NT_enum:
      return AST_Enum::narrow_from_decl(d);
   case AST_Decl::NT_op:
      return AST_Operation::narrow_from_decl(d);
   default:
      return NULL;
   }
}
