/*
 *======================================================================
 *
 *Copyright 1992 Sun Microsystems, Inc.
 *
 *The Interface Definition Language Compiler Front End (CFE) is made
 *available for use provided that this legend is included on all media and
 *documentation and as a part of the software program in whole or part.
 *Users may copy and extend functionality (but may not remove
 *functionality) of the Interface Definition Language CFE without charge,
 *but are not authorized to license or distribute it to anyone else except
 *as part of a product or program developed by the user or with the express
 *written consent of Sun Microsystems, Inc.
 *
 *The names of Sun Microsystems, Inc. and any of its subsidiaries may not
 *be used in advertising or publicity pertaining to distribution of
 *Interface Definition Language CFE as permitted herein.
 *
 *The Interface Definition Language CFE may not be exported outside the
 *United States without first obtaining the appropriate government
 *approvals.
 *
 *INTERFACE DEFINITION LANGUAGE CFE IS PROVIDED AS IS WITH NO WARRANTIES
 *OF ANY KIND INCLUDING THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND
 *FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR ARISING FROM A
 *COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 *Interface Definition Language CFE is provided with no support and
 *without any obligation on the part of Sun Microsystems, Inc. or any of
 *its subsidiaries or affiliates to assist in its use, correction,
 *modification or enhancement.
 *
 *SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR AFFILIATES SHALL
 *HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT OF COPYRIGHTS, TRADE
 *SECRETS OR ANY PATENTS BY INTERFACE DEFINITION LANGUAGE CFE OR ANY PART
 *THEREOF.
 *
 *IN NO EVENT WILL SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR
 *AFFILIATES BE LIABLE FOR ANY LOST REVENUE OR PROFITS OR OTHER SPECIAL,
 *INDIRECT AND CONSEQUENTIAL DAMAGES, EVEN IF SUN HAS BEEN ADVISED OF THE
 *POSSIBILITY OF SUCH DAMAGES.
 *
 *SunSoft, Inc.  
 *2550 Garcia Avenue 
 *Mountain View, California  94043
 *
 *
 *
 *
 *======================================================================
 */

#ifndef _FE_DECLARATOR_FE_DECLARATOR_HH
#define _FE_DECLARATOR_FE_DECLARATOR_HH

#pragma ident "%@(#)FE_Declarator.h	1.30% %92/06/10% Sun Microsystems"

// FE_Declarator.h
//
// FE internal class for storing interim declaration statements

/*
** DEPENDENCIES: utl_scoped_name.hh, ast_decl.hh
**
** USE: Included from fe.hh
*/

class	FE_Declarator
{
public:
  // Enum to denote types of declarators
  enum DeclaratorType {
        FD_simple		// Simple declarator
      , FD_complex		// Complex declarator (complex_part field used)
  };

  // Operations

  // Constructor(s)
  FE_Declarator(UTL_ScopedName *n, DeclaratorType dt, AST_Decl *cp);

  // Data Accessors
  AST_Decl *complex_part();
  UTL_ScopedName *name();
  DeclaratorType decl_type();

  // Other Operations

  // Compose an FE_Declarator into an AST_Type once all the needed information
  // is available
  AST_Type		*compose(AST_Type *tc);

private:
  // Data
  AST_Decl		*pd_complex_part;	// If a complex declarator
  UTL_ScopedName	*pd_name;		// The name if complex
  DeclaratorType	pd_decl_type;		// Whether complex or simple
};

#endif           // _FE_DECLARATOR_FE_DECLARATOR_HH
