/*
 *======================================================================
 *
 *Copyright 1992 Sun Microsystems, Inc.
 *
 *The Interface Definition Language Compiler Front End (CFE) is made
 *available for use provided that this legend is included on all media and
 *documentation and as a part of the software program in whole or part.
 *Users may copy and extend functionality (but may not remove
 *functionality) of the Interface Definition Language CFE without charge,
 *but are not authorized to license or distribute it to anyone else except
 *as part of a product or program developed by the user or with the express
 *written consent of Sun Microsystems, Inc.
 *
 *The names of Sun Microsystems, Inc. and any of its subsidiaries may not
 *be used in advertising or publicity pertaining to distribution of
 *Interface Definition Language CFE as permitted herein.
 *
 *The Interface Definition Language CFE may not be exported outside the
 *United States without first obtaining the appropriate government
 *approvals.
 *
 *INTERFACE DEFINITION LANGUAGE CFE IS PROVIDED AS IS WITH NO WARRANTIES
 *OF ANY KIND INCLUDING THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND
 *FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR ARISING FROM A
 *COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 *Interface Definition Language CFE is provided with no support and
 *without any obligation on the part of Sun Microsystems, Inc. or any of
 *its subsidiaries or affiliates to assist in its use, correction,
 *modification or enhancement.
 *
 *SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR AFFILIATES SHALL
 *HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT OF COPYRIGHTS, TRADE
 *SECRETS OR ANY PATENTS BY INTERFACE DEFINITION LANGUAGE CFE OR ANY PART
 *THEREOF.
 *
 *IN NO EVENT WILL SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR
 *AFFILIATES BE LIABLE FOR ANY LOST REVENUE OR PROFITS OR OTHER SPECIAL,
 *INDIRECT AND CONSEQUENTIAL DAMAGES, EVEN IF SUN HAS BEEN ADVISED OF THE
 *POSSIBILITY OF SUCH DAMAGES.
 *
 *SunSoft, Inc.  
 *2550 Garcia Avenue 
 *Mountain View, California  94043
 *
 *
 *
 *
 *======================================================================
 */

#ifndef _AST_INTERFACE_AST_INTERFACE_HH
#define _AST_INTERFACE_AST_INTERFACE_HH

#pragma ident "%@(#)AST_Interface.h	1.37% %92/06/10% Sun Microsystems"

// Representation of interface:
//
// NOTE: add(AST_EnumValue *) is defined here because enums can
// be defined manifest locally; the constants defined in these
// enums are inserted in the enclosing scope.

/*
** DEPENDENCIES: ast_type.hh, utl_scope.hh, ast_decl.hh, utl_strlist.hh
**
** USE: Included from ast.hh
*/

class	AST_Interface : public virtual AST_Type, public virtual UTL_Scope
{
public:
  // Operations

  // Constructor(s)
  AST_Interface();
  AST_Interface(UTL_ScopedName *n,
		AST_Interface **ih,
		long nih,
		UTL_StrList *p);

  // Scope Management Protocol

  virtual AST_Constant		*add_constant(AST_Constant	*c);
  virtual AST_Exception		*add_exception(AST_Exception	*e);
  virtual AST_Attribute		*add_attribute(AST_Attribute	*a);
  virtual AST_Operation		*add_operation(AST_Operation	*o);
  virtual AST_Union		*add_union(AST_Union		*u);
  virtual AST_Structure		*add_structure(AST_Structure	*s);
  virtual AST_Enum		*add_enum(AST_Enum		*e);
  virtual AST_EnumVal		*add_enum_val(AST_EnumVal	*v);
  virtual AST_Typedef		*add_typedef(AST_Typedef	*t);

  // Data Accessors
  AST_Interface	**inherits();
  void set_inherits(AST_Interface **i);
  long n_inherits();
  void set_n_inherits(long i);

  // Is this interface defined? This predicate returns FALSE when an
  // interface was forward declared but not defined yet, and TRUE in
  // all other cases.
  boolean is_defined()
  {
    return (pd_n_inherits < 0) ? FALSE : TRUE;
  }

  // Narrowing
  DEF_NARROW_METHODS2(AST_Interface, AST_Type, UTL_Scope);
  DEF_NARROW_FROM_DECL(AST_Interface);
  DEF_NARROW_FROM_SCOPE(AST_Interface);

  // AST Dumping
  virtual void			dump(ostream &o);

private:
  // Data
  AST_Interface			**pd_inherits;	// Inherited interfaces
						// This is an array of pointers
						// to the inherited interfaces
  long				pd_n_inherits;	// How many of them?
};

#endif           // _AST_INTERFACE_AST_INTERFACE_HH
