/*
 *======================================================================
 *
 *Copyright 1992 Sun Microsystems, Inc.
 *
 *The Interface Definition Language Compiler Front End (CFE) is made
 *available for use provided that this legend is included on all media and
 *documentation and as a part of the software program in whole or part.
 *Users may copy and extend functionality (but may not remove
 *functionality) of the Interface Definition Language CFE without charge,
 *but are not authorized to license or distribute it to anyone else except
 *as part of a product or program developed by the user or with the express
 *written consent of Sun Microsystems, Inc.
 *
 *The names of Sun Microsystems, Inc. and any of its subsidiaries may not
 *be used in advertising or publicity pertaining to distribution of
 *Interface Definition Language CFE as permitted herein.
 *
 *The Interface Definition Language CFE may not be exported outside the
 *United States without first obtaining the appropriate government
 *approvals.
 *
 *INTERFACE DEFINITION LANGUAGE CFE IS PROVIDED AS IS WITH NO WARRANTIES
 *OF ANY KIND INCLUDING THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND
 *FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR ARISING FROM A
 *COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 *Interface Definition Language CFE is provided with no support and
 *without any obligation on the part of Sun Microsystems, Inc. or any of
 *its subsidiaries or affiliates to assist in its use, correction,
 *modification or enhancement.
 *
 *SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR AFFILIATES SHALL
 *HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT OF COPYRIGHTS, TRADE
 *SECRETS OR ANY PATENTS BY INTERFACE DEFINITION LANGUAGE CFE OR ANY PART
 *THEREOF.
 *
 *IN NO EVENT WILL SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR
 *AFFILIATES BE LIABLE FOR ANY LOST REVENUE OR PROFITS OR OTHER SPECIAL,
 *INDIRECT AND CONSEQUENTIAL DAMAGES, EVEN IF SUN HAS BEEN ADVISED OF THE
 *POSSIBILITY OF SUCH DAMAGES.
 *
 *SunSoft, Inc.  
 *2550 Garcia Avenue 
 *Mountain View, California  94043
 *
 *
 *
 *
 *======================================================================
 */

#pragma ident "%@(#)ast_check.cc	1.46% %92/06/11% Sun Microsystems"

/*
 * ast_check.cc - Check AST nodes representing fwd declared interfaces
 *		  after parse of AST is completed.
 *
 * The check ensures that for every forward declared interface we also
 * saw a full definition of that interface.
 */

#include	<idl.hh>
#include	<idl_extern.hh>

/*
 * Static storage for remembering nodes
 */
static AST_InterfaceFwd	**ast_fwds = NULL;
static long		ast_n_fwds_used = 0;
static long		ast_n_fwds_alloc = 0;

#undef	INCREMENT
#define	INCREMENT	64

/*
 * Store a node representing a forward declared interface
 */
void
AST_record_fwd_interface(AST_InterfaceFwd *n)
{
  AST_InterfaceFwd	**o_ast_fwds;
  long			o_ast_n_fwds_alloc;
  long			i;

  /*
   * Make sure there's space to store one more
   */
  if (ast_n_fwds_used == ast_n_fwds_alloc) {
    if (ast_n_fwds_alloc == 0) {
      ast_n_fwds_alloc = INCREMENT;
      ast_fwds = new AST_InterfaceFwd *[ast_n_fwds_alloc];
    } else {
      o_ast_fwds = ast_fwds;
      o_ast_n_fwds_alloc = ast_n_fwds_alloc;

      ast_n_fwds_alloc += INCREMENT;
      ast_fwds = new AST_InterfaceFwd *[ast_n_fwds_alloc];

      for (i = 0; i < o_ast_n_fwds_alloc; i++)
        ast_fwds[i] = o_ast_fwds[i];

      delete o_ast_fwds;
    }
  }
  /*
   * Insert new node
   */
  ast_fwds[ast_n_fwds_used++] = n;
}

/*
 * Check that all forward declared interfaces were also defined
 */
void
AST_check_fwd_interface()
{
  long			i;
  AST_InterfaceFwd	*d;
  AST_Interface		*itf;

  for (i = 0; i < ast_n_fwds_used; i++) {
    d = ast_fwds[i];
    itf = d->full_definition();
    if (!(itf->is_defined()))
      idl_global->err()->fwd_decl_not_defined(itf);
  }
}
