/*
 *======================================================================
 *
 *Copyright 1992 Sun Microsystems, Inc.
 *
 *The Interface Definition Language Compiler Front End (CFE) is made
 *available for use provided that this legend is included on all media and
 *documentation and as a part of the software program in whole or part.
 *Users may copy and extend functionality (but may not remove
 *functionality) of the Interface Definition Language CFE without charge,
 *but are not authorized to license or distribute it to anyone else except
 *as part of a product or program developed by the user or with the express
 *written consent of Sun Microsystems, Inc.
 *
 *The names of Sun Microsystems, Inc. and any of its subsidiaries may not
 *be used in advertising or publicity pertaining to distribution of
 *Interface Definition Language CFE as permitted herein.
 *
 *The Interface Definition Language CFE may not be exported outside the
 *United States without first obtaining the appropriate government
 *approvals.
 *
 *INTERFACE DEFINITION LANGUAGE CFE IS PROVIDED AS IS WITH NO WARRANTIES
 *OF ANY KIND INCLUDING THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND
 *FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR ARISING FROM A
 *COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 *Interface Definition Language CFE is provided with no support and
 *without any obligation on the part of Sun Microsystems, Inc. or any of
 *its subsidiaries or affiliates to assist in its use, correction,
 *modification or enhancement.
 *
 *SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR AFFILIATES SHALL
 *HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT OF COPYRIGHTS, TRADE
 *SECRETS OR ANY PATENTS BY INTERFACE DEFINITION LANGUAGE CFE OR ANY PART
 *THEREOF.
 *
 *IN NO EVENT WILL SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR
 *AFFILIATES BE LIABLE FOR ANY LOST REVENUE OR PROFITS OR OTHER SPECIAL,
 *INDIRECT AND CONSEQUENTIAL DAMAGES, EVEN IF SUN HAS BEEN ADVISED OF THE
 *POSSIBILITY OF SUCH DAMAGES.
 *
 *SunSoft, Inc.  
 *2550 Garcia Avenue 
 *Mountain View, California  94043
 *
 *
 *
 *
 *======================================================================
 */

#pragma ident "%@(#)ast_argument.cc	1.46% %92/06/11% Sun Microsystems"

/*
 * ast_argument.cc - Implementation of class AST_Argument.cc
 *
 * AST_Argument nodes denote arguments to an operation. They
 * are AST_Fields with directions. Thus, they have a name
 * (an UTL_ScopedName) and a type (a subclass of AST_Type).
 * Additionally they have a direction field which takes values
 * from the enum AST_Argument::Direction.
 */

#include	<idl.hh>
#include	<idl_extern.hh>

/*
 * Static functions
 */

/*
 * Convert an enum Direction value to a char *
 */
static char *
direction_to_string(AST_Argument::Direction d)
{
  switch (d) {
  case AST_Argument::dir_IN:
    return "in";
  case AST_Argument::dir_OUT:
    return "out";
  case AST_Argument::dir_INOUT:
    return "inout";
  }
}

/*
 * Constructor(s) and destructor
 */

AST_Argument::AST_Argument()
	    : pd_direction(dir_IN)
{
}

AST_Argument::AST_Argument(Direction d, AST_Type *ft, UTL_ScopedName *n,
			   UTL_StrList *p)
	   : AST_Field(AST_Decl::NT_argument, ft, n, p),
	     AST_Decl(AST_Decl::NT_argument, n, p),
	     pd_direction(d)
{
}

/*
 * Private operations
 */

/*
 * Public operations
 */

/*
 * Redefinition of inherited virtual operations
 */

/*
 * Dump this AST_Argument node to the ostream o
 */
void
AST_Argument::dump(ostream &o)
{
  o << direction_to_string(pd_direction) << " ";
  AST_Field::dump(o);
}

/*
 * Data accessors
 */

const AST_Argument::Direction
AST_Argument::direction()
{
  return pd_direction;
}

/*
 * Narrowing operations
 */
IMPL_NARROW_METHODS1(AST_Argument, AST_Field)
IMPL_NARROW_FROM_DECL(AST_Argument)
