/*
** Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.
**
** Unlimited use, reproduction, and distribution of this software is
** permitted.  Any copy of this software must include both the above
** copyright notice of Xerox Corporation and this paragraph.  Any
** distribution of this software must comply with all applicable United
** States export control laws.  This software is made available AS IS,
** and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
** INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
** AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
** PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
** THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
** CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
** XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*/
 

#include "cstubber.h"

extern void 	encodeArgument( );
extern boolean 	IsCacheableMethod( );

extern cardinal MethodRecordID;

static void generateInstanceFromSBH(
    Type 	type,
    Context 	context )
{
    boolean 	singleton;
    char 	*tn;

 
    tn = c_type_name( context->class );
    singleton = ( class_object( context->class ))->singleton;
    fprintf(context->file, "%s %s__CreateFromSBH (char *sbh, char *typeId )\n{\n", tn, tn);
    fprintf (context->file, "  return (%s) (ILU_C_SBHToObject(sbh, (typeId == NULL) ? _%s__ILUClassRecord.cl_unique_id : typeId, &_%s__ILUClassRecord));\n}\n\n",
	     tn, tn, tn);
}

static void declareCallerReturnValue(Type type, Context context)
{
    if ( type_basic_type( type ) != void_Type ) {
        fprintf (context->file, "  %s _retvalue;\n", c_return_type( type ));
    }
}

int dereferenceArg(
    Argument 	arg )
{
    enum PrimitiveTypes         t = type_basic_type( arg->type );

    if ( t == sequence_Type || TypeIsNonObjectStruct( arg->type ) || 
		TypeIsArray( arg->type ))
	return( False );
    if ( arg->direction == In )
	return( False );
    return( True );
}

static void listArgument(
    Argument 	arg,
    Context 	context )
{
  fprintf (context->file, ", %s %s",
	   c_parameter_type(arg->type, arg->direction),
	   c_argument_name(arg));
}

void generateProcHeader (Procedure m, Context c, boolean external)
{
  fprintf (c->file, "%s%s %s%s_%s( %s _handle, ILU_C_ENVIRONMENT *_status",
	   external ? "" : "static ",
	   (type_basic_type(m->returnType) == void_Type) ? "void" : c_return_type (m->returnType),
	   external ? "" : "_", c_type_name( c->class ), c_simple_name( m->name ), c_type_name( c->class ));
  list_enumerate (m->arguments, (void ( * )( )) listArgument, c);
  fprintf (c->file, ")\n{\n");
}

int methodNdxOf (Procedure p, Type t)
{
    list	m;
    int 	mNdx;
    listElement *ptr;

    mNdx = 0;
    m = ( class_object( t ))->methods; 
    if ( m == NULL || m->count < 1 )
      return( 0 );
    ptr = m->head;
    while( ptr ) {
	if ( ptr->data == p )
	    return( mNdx );
	mNdx++;
	ptr = ptr->next;
    }
    return( mNdx );
}

static void sizeArgument (Argument arg, Context context)
{
  char b[1000];

  if ( arg->direction == Out )
    return;
  else if (arg->direction == InOut)	/* all args are passed by ref in this case */
    {
      enum PrimitiveTypes t;

      t = type_basic_type(arg->type);
      if (t != sequence_Type AND
	  t != union_Type AND
	  t != array_Type AND
	  t != record_Type)
	{
	  *b = '*';
	  strcpy (b+1, c_argument_name(arg));
	}
      else
	strcpy (b, c_argument_name(arg));
    }
  else
    strcpy (b, c_argument_name(arg));
  fprintf (context->file, "\n     +");
  SizeValue (context, arg->type, b);
}

static void outputArgument (Argument arg, Context context)
{
  char b[1000];

  if ( arg->direction == Out )
    return;
  else if (arg->direction == InOut)
    {
      enum PrimitiveTypes t;

      t = type_basic_type(arg->type);
      if (t != sequence_Type AND
	  t != union_Type AND
	  t != array_Type AND
	  t != record_Type) {
	*b = '*';
	strcpy (b+1, c_argument_name(arg));
      }
      else
	strcpy (b, c_argument_name(arg));
    }
  else
    strcpy (b, c_argument_name(arg));
  MarshallValue (context, arg->type, b, 2);
}

static void inputArgument(
    Argument 	arg,
    Context 	context )
{
  if ( arg->direction == In )
    return;

  UnmarshallValue (context, arg->type, arg->def, ( char * ) c_argument_name( arg ), 6, True, FALSE);
}

static void TypeIsObj (Type t, boolean *objarg)
{
  if (type_basic_type(t) == object_Type)
    *objarg = TRUE;
}

static void scanForObjectArg (Argument a, boolean *objarg)
{
  type_recurse (a->type, (void (*) (Type, refany)) TypeIsObj, objarg);
}

static void generateMethodCode (Procedure m, Context context)
{
  boolean objarg;
  enum PrimitiveTypes 	t = type_basic_type(m->returnType);
 
  if ( methodInList( c_simple_name( m->name )))
    {
      MethodRecordID++;
      return;
    }
  addMethodToList (c_simple_name(m->name));

  generateProcHeader(m, context, FALSE);

  /* declare local variables */
  declareCallerReturnValue( m->returnType, context );
  fprintf(context->file, "  ilu_Call _call;\n  ilu_Object _kobj;\n");
  if (BlockingCall(m))
    fprintf(context->file, "  ilu_ProtocolException _perror;\n  ilu_cardinal _scode;\n\n");

  /* 
   ** if method is functional, see if it is cached, 
   ** and if so, return the cached value 
   */
  
  if ( IsCacheableMethod( m )) {

    /*
     ** eventually...
     */
  }

  /* start code */
  fprintf (context->file, "  if ((_call = ilu_BeginCall(_handle->server)) == NULL ) {\n" );
  fprintf (context->file, "    ILU_C_RAISE_SYSTEM(_status,COMM_FAILURE,0,NO);\n");
  if (t != void_Type)
    fprintf (context->file, "    return _retvalue;\n  };\n");
  else
    fprintf (context->file, "    return;\n  };\n");

  fprintf (context->file, "  if ((_kobj = _ILU_C_KernelObjOfObj(_handle)) == NULL) {\n");
  fprintf (context->file, "    ILU_C_RAISE_SYSTEM(_status,INV_OBJREF,0,NO);\n");
  if (t != void_Type)
    fprintf (context->file, "    return _retvalue;\n  };\n");
  else
    fprintf (context->file, "    return;\n  };\n");

  /* now Inside the server of the discriminator.  See if we have to leave. */
  objarg = FALSE;
  list_enumerate (m->arguments, (void (*)(void *, void *)) scanForObjectArg, &objarg);
  if (NOT objarg)
    {
      fprintf (context->file, "  if (! ilu_BeginRequest(_call, &_%s__ILUClassRecord,\n    &_%s__ILUClassRecord.cl_methods[%d],\n",
	       c_type_name(m->object), c_type_name(m->object), methodNdxOf(m, m->object));
      if (SINGLETON(context->class))
	fprintf (context->file, "    (0");
      else
	fprintf(context->file, "    (ilu_SizeOfObjectID(_call, _kobj, ilu_TRUE, &_%s__ILUClassRecord)",
		c_type_name( context->class ));
      list_enumerate( m->arguments, (void ( * )()) sizeArgument, context );
      fprintf (context->file, "))) {\n" );
      fprintf (context->file, "    ILU_C_RAISE_SYSTEM(_status,COMM_FAILURE,0,NO);\n");
      if (t != void_Type)
	fprintf (context->file, "    return _retvalue;\n  };\n");
      else
	fprintf (context->file, "    return;\n  };\n");

      /* marshall the parameters */
      if (SINGLETON(context->class))
	fprintf (context->file, "  ilu_ExitServer (_kobj->ob_server, _kobj->ob_class);\n");
      else
	fprintf(context->file, "  ilu_OutputObjectID(_call, _kobj, ilu_TRUE, &_%s__ILUClassRecord);\n",
		c_type_name(context->class));
    }
  else
    {
      fprintf (context->file, "  {\n    unsigned long _size = 0;\n");
      if (NOT SINGLETON(context->class))
      fprintf (context->file, "    _size += ilu_SizeOfObjectID(_call, _kobj, ilu_TRUE, &_%s__ILUClassRecord);\n",
	       c_type_name(context->class));
      fprintf (context->file, "    ilu_ExitServer (_kobj->ob_server, _kobj->ob_class);\n");
      fprintf (context->file, "    _size = _size");
      list_enumerate( m->arguments, (void ( * )()) sizeArgument, context );
      fprintf (context->file, ";\n");
      if (NOT SINGLETON(context->class))
	{
	  fprintf (context->file, "    if ((_kobj = _ILU_C_KernelObjOfObj (_handle)) == NULL) {\n");
	  fprintf (context->file, "      ILU_C_RAISE_SYSTEM(_status,INV_OBJREF,0,NO);\n");
	  if (t != void_Type)
	    fprintf (context->file, "      return _retvalue;\n    };\n");
	  else
	    fprintf (context->file, "      return;\n    };\n");
	}
      fprintf (context->file,
	       "    if (! ilu_BeginRequest(_call, &_%s__ILUClassRecord, &_%s__ILUClassRecord.cl_methods[%d], _size)) {\n",
	       c_type_name(m->object), c_type_name(m->object), methodNdxOf(m, m->object));
      fprintf (context->file, "      ILU_C_RAISE_SYSTEM(_status,COMM_FAILURE,0,NO);\n");
      if (t != void_Type)
	fprintf (context->file, "      return _retvalue;\n    };\n");
      else
	fprintf (context->file, "      return;\n    };\n");

      if (NOT SINGLETON(context->class))
	fprintf (context->file, "    ilu_OutputObjectID(_call, _kobj, ilu_TRUE, &_%s__ILUClassRecord);\n",
		 c_type_name(context->class));
      fprintf (context->file, "  }\n");
    }
  list_enumerate(m->arguments, (void ( * )()) outputArgument, context );
  fprintf (context->file, "  if (! ilu_FinishRequest(_call)) {\n" );
  fprintf (context->file, "    ILU_C_RAISE_SYSTEM(_status,COMM_FAILURE,0,MAYBE);\n");
  if (t != void_Type)
    fprintf (context->file, "    return _retvalue;\n  };\n");
  else
    fprintf (context->file, "    return;\n  };\n");

  if ( BlockingCall( m )) {	/* that is, we have to read a response */
    fprintf(context->file, "  if (( _perror = ilu_GetReply (_call, &_scode)) == ilu_ProtocolException_Success ) {\n");
    fprintf (context->file, "    if (_scode == 0) {\n");
    fprintf (context->file, "      _status->returnCode = NULL;\n");
    fprintf (context->file, "      _status->_major = ILU_C_NO_EXCEPTION;\n" );
    if ( t == void_Type )
      fprintf (context->file, "	/* nothing to read from remote side */\n");
    else
      {
	char retbuf[1000];

	sprintf (retbuf, "%s%s", (t == object_Type OR t == array_Type) ? "" : "&", "_retvalue");
	UnmarshallValue(context, m->returnType, m->def, retbuf, 6, TRUE, (t == array_Type));
	if ( IsCacheableMethod( m )) {

	  /*
	   ** eventually...
	   */
	}
      }
    list_enumerate( m->arguments, (void ( * )()) inputArgument, context );
    fprintf (context->file, "    }" );
    if ( list_size( m->exceptions ) > 0 )
      fprintf(context->file, "\n    else\n      _%s_CatchException (_call, _status, _scode);\n",
	      c_interface_name( context->interface ));
    else
      fprintf (context->file, ";\n /* no else clause -- no exceptions to catch */\n" );
    fprintf (context->file, "  }\n  else {\n" );
    fprintf (context->file, "    _ILU_C_SetProtocolError(_status, _perror);\n");
    fprintf (context->file, "  }\n");
  }
  else
    fprintf (context->file, "	/* no response, so finish and return */\n\n");
    
  fprintf (context->file, "  ilu_FinishCall(_call);\n" );
  if ( type_basic_type( m->returnType ) != void_Type )
    fprintf (context->file, "  return(_retvalue);\n" );
  fprintf (context->file, "}\n\n" );
}

static void mkPrototype(
    Procedure   m,
    Context     c )
{
    void		listArgumentTypes( );
    enum PrimitiveTypes t = type_basic_type( m->returnType );
 
    fprintf(
            c->file,
            "%s _%s_%s( %s, ILU_C_ENVIRONMENT *",
            ( !m->returnType ) ? "void" :
                (( t == array_Type ) ?
                        c_return_type( m->returnType )
                    :
                        c_type_name( m->returnType )),
            c_type_name( m->object ),
            c_simple_name( m->name ),
            c_type_name( m->object ));
    list_enumerate( m->arguments, listArgumentTypes, c );
    fprintf( c->file, ");\n" );
}
 
static void generatePrototypes(
    Type        t,
    Context     context )
{
    Class       c;
 
    if ( t == NULL ||
                type_basic_type( t ) != object_Type ||
                ( c = class_object( t )) == NULL )
        return;
    list_enumerate( c->methods, (void (*)(refany, refany)) mkPrototype, context );
}

static void generateMethodPtrs(
    Procedure	p,
    Context	c )
{
  fprintf (c->file, "    (void(*)()) _%s_%s,\n", c_type_name( p->object ), c_simple_name( p->name ));
}

static void generateClsPtrs (Type t, Context c)
{
  if (class_object (t)->superclasses != NULL)
    list_enumerate (class_object( t )->superclasses, (void (*)(refany, refany)) generateClsPtrs, c);
  fprintf (c->file, "  (_ILU_C_MethodBlock *) &_%s__MethodBlock,\n", c_type_name(t));
}

static void generateMiMethodPtrs (Type t, Context c)
{
/*
  if (class_object(t)->superclasses != NULL)
    list_enumerate (class_object( t )->superclasses, (void (*)(refany, refany)) generateMiMethodPtrs, c);
*/
  if (methodInList(c_type_name(t)))
    return;
  addMethodToList( c_type_name( t ));
  if (OriginalInterface(t) != c->interface)
    return;
  generatePrototypes( t, c );
  fprintf (c->file, "struct _%s__MethodBlock_s _%s__MethodBlock = {\n",
	   c_type_name(t), c_type_name(t));
  fprintf (c->file, "  &_%s__ILUClassRecord,\n  {\n" , c_type_name(t));
  list_enumerate (class_object(t)->methods, (void ( * )( )) generateMethodPtrs, c);
  fprintf( c->file, "  }\n};\n\n" );
}

static void generateClassTable (Type t, Context c)
{
  char *tn = c_type_name(t);

  clearMethodList();
  generateMiMethodPtrs (t, c);
  fprintf (c->file, "static _ILU_C_MethodBlock *_%s__SurrogateTypeVector[] = {\n", tn);

    /*
    ** this class's data must be first
    ** in the list. some runtime machinery
    ** depends on this
    */

  fprintf (c->file, "  (_ILU_C_MethodBlock *) &_%s__MethodBlock,\n", tn);
  if (class_object(t)->superclasses != NULL)
    list_enumerate (class_object(t)->superclasses, (void (*)(refany, refany)) generateClsPtrs, c);
  fprintf (c->file, "  NULL\n};\n\n");
}

static void generateMethods(
    Type	class,
    Context	context )
{
    if ( !class )
	return;

    list_enumerate(class_object(class)->methods, ( void ( * )( )) generateMethodCode, context);
}

static void generateClassCode(
    Type 	type,
    Context 	context )
{
    context->class = type;
    MethodRecordID = 0;
    clearMethodList( );
    generateMethods( type, context );
    generateClassTable( type, context );
    generateInstanceFromSBH( type, context );
}

void RegisterSurrogateTypes (Type t, Context c)
{
  if (OriginalInterface(t) == c->interface)
    {
      fprintf (c->file, "  _ILU_C_RegisterSurrogateCType (&_%s__ILUClassRecord, _%s__SurrogateTypeVector);\n",
	       c_type_name(t), c_type_name(t));
    }
}

void generateClientCode(
    Interface   interface,
    FILE        *file )
{
  struct context_s context;
 
  context.file = file;
  context.interface = interface;
  fprintf (file, "#include \"%s.h\"\n\n", c_interface_name(interface));
  clearMethodList();
  list_enumerate (interface->classes, (void (*)(refany, refany)) generateClassCode, &context);

  fprintf (file, "void %s__Initialize()\n{\n", c_interface_name(interface));
  fprintf (file, "  extern void _%s__GeneralInitialization(void);\n\n", c_interface_name(interface));
  fprintf (file, "  static int initialized = ilu_FALSE;\n  if (initialized) return;\n  initialized = ilu_TRUE;\n\n");
  fprintf (file, "  _%s__GeneralInitialization();\n", c_interface_name(interface));
  list_enumerate (interface->classes, (EnumProc) RegisterSurrogateTypes, &context);
  fprintf (file, "}\n");
}
