#ifndef _ILU_EXPORTS_
#define _ILU_EXPORTS_

/* ==================================== from call.c */

/* note that "handlerProc" is a proc that accepts 3 args: an _ilu_Partner, an errno value, and a i/o direction (1 for output, 2 for input), and returns void.  It is called for LostServer or TimeOut errors. */

void ilu_SetCommunicationsErrorHandler (/* handlerProc */);

void ilu_OutputInteger (/* ilu_Call call,
			   ilu_integer i */);

void ilu_OutputCardinal (/* ilu_Call call,
			    ilu_cardinal i */);

void ilu_OutputShortInteger (/* ilu_Call call,
				ilu_shortinteger i */);

void ilu_OutputShortCardinal (/* ilu_Call call,
				 ilu_shortcardinal i */);

void ilu_OutputEnum (/* ilu_Call call,
			ilu_cardinal i */);

void ilu_OutputReal (/* ilu_Call call,
			double d */);

void ilu_OutputShortReal (/* ilu_Call call,
			      float f */);

void ilu_OutputString (/* ilu_Call call,
			  ilu_string s,
			  ilu_cardinal len */);

void ilu_OutputByte (/* ilu_Call call,
			ilu_byte b */);

void ilu_OutputOpaque (/* ilu_Call call,
			  ilu_bytes o,
			  ilu_cardinal len */);

void ilu_OutputBytes (/* ilu_Call call,
			 ilu_bytes o,
			 ilu_cardinal len */);

void ilu_OutputObjectID (/* ilu_Call call,
			    ilu_Object obj,
			    ilu_boolean descriminator_p,
			    ilu_Class putative_class */);

void ilu_InputInteger (/* ilu_Call call,
			  ilu_integer *i */);
			  
void ilu_InputCardinal (/* ilu_Call call,
			   ilu_cardinal *i */);

void ilu_InputShortInteger (/* ilu_Call call,
			       ilu_shortinteger *i */);
			  
void ilu_InputShortCardinal (/* ilu_Call call,
				ilu_shortcardinal *i */);

void ilu_InputEnum (/* ilu_Call call,
		       ilu_cardinal *i */);

void ilu_InputReal (/* ilu_Call call,
		       double *d */);

void ilu_InputShortReal (/* ilu_Call call,
			     float *f */);

void ilu_InputString (/* ilu_Call call,
			 ilu_string *s,
			 ilu_cardinal *len */);

void ilu_InputByte (/* ilu_Call call,
		       ilu_byte *b */);

void ilu_InputOpaque (/* ilu_Call call,
			 ilu_bytes *o,
			 ilu_cardinal len */);

void ilu_InputBytes (/* ilu_Call call,
			ilu_bytes *o,
			ilu_cardinal *len */);

void ilu_InputObjectID (/* ilu_Call call,
			   ilu_Object obj,
			   ilu_boolean descriminator_p,
			   ilu_string *classnames */);

ilu_cardinal ilu_SizeOfInteger (/* ilu_Call call, ilu_cardinal i */);

ilu_cardinal ilu_SizeOfCardinal (/* ilu_Call call, ilu_cardinal i */);

ilu_cardinal ilu_SizeOfShortInteger (/* ilu_Call call, ilu_shortinteger i */);

ilu_cardinal ilu_SizeOfShortCardinal (/* ilu_Call call, ilu_shortcardinal i */);

ilu_cardinal ilu_SizeOfByte (/* ilu_Call call, ilu_byte i */);

ilu_cardinal ilu_SizeOfReal (/* ilu_Call call, double d */);

ilu_cardinal ilu_SizeOfShortReal (/* ilu_Call call, float d */);

ilu_cardinal ilu_SizeOfEnumeration (/* ilu_Call call, ilu_cardinal i */);

ilu_cardinal ilu_SizeOfString (/* ilu_Call call, ilu_string i,
				  ilu_cardinal l */);

ilu_cardinal ilu_SizeOfOpaque (/* ilu_Call call, ilu_bytes o,
				  ilu_cardinal l */);

ilu_cardinal ilu_SizeOfBytes (/* ilu_Call call, ilu_bytes o,
				 ilu_cardinal l */);

ilu_cardinal ilu_SizeOfObjectID (/* ilu_Call call,
				    ilu_Object obj,
				    ilu_boolean descriminator_p,
				    ilu_Class putative_class */);

ilu_Call ilu_BeginCall (/* ilu_Connection conn */);

void ilu_FinishCall (/* ilu_Call call */);

ilu_boolean ilu_BeginRequest (/* ilu_Call call,
				 ilu_Object obj,
				 ilu_Method method,
				 ilu_cardinal argSize */);

ilu_boolean ilu_FinishRequest (/* ilu_Call call */);

ilu_boolean ilu_BeginReply (/* ilu_Call call,
			       ilu_boolean exceptions,
			       ilu_cardinal argSize */);

ilu_boolean ilu_FinishReply (/* ilu_Call call */);

ilu_boolean ilu_BeginException (/* ilu_Call call,
			    ilu_cardinal evalue,
			    ilu_cardinal argSize */);

ilu_boolean ilu_FinishException (/* ilu_Call call */);

ilu_Connection ilu_ConnectionOfCall (/* ilu_Call call */);

ilu_cardinal ilu_SerialNumberOfCall (/* ilu_Call call */);

/* ==================================== from object.c */

ilu_boolean ilu_ParseStringBindingHandle (/* ilu_string sbh,
				      ilu_string *oid,
				      ilu_string *serverhandle */);

ilu_Object ilu_ObjectOfSBH (/* ilu_string StringBindingHandle */);

ilu_string ilu_SBHOfObject (/* ilu_Object obj */);

void ilu_SetFindObjectHook (/* iluObject (*hook)(ilu_string SBH) */);

ilu_Connection ilu_ConnectionOfObject (/* ilu_Object obj */);

ilu_boolean ilu_TrueInstanceP (/* ilu_Object obj */);

void ilu_RegisterLanguageSpecificObject (/* ilu_Object obj,
					    ilu_refany lso */);

ilu_refany ilu_GetLanguageSpecificObject (/* ilu_Object obj */);

ilu_Method ilu_FindMethodByID (/* ilu_Object obj,
				  ilu_cardinal ID */);

ilu_Object ilu_CreateObject (/* ilu_string oid,
				ilu_Server server,
				ilu_Class class,
				ilu_refany languageSpecificObject */);

void ilu_DestroyObject (/* ilu_Object obj */);

void ilu_RegisterClass (/* ilu_Class class */);

ilu_Class ilu_FindClassFromName (/* char *classname */);

ilu_Class ilu_FindClassFromID (/* char *unique_id */);

/* ==================================== from port.c */

ilu_Port ilu_GetDefaultPort();

void ilu_SetDefaultPort (/* ilu_Port port */);

ilu_Connection ilu_HandleNewConnection (/* ilu_Port port */);

ilu_Port ilu_CreatePort (/* ilu_string protocolName, ilu_string transportInfo */);

void ilu_ExportInstance (/* ilu_Port port, ilu_Object instance */);

/* ==================================== from server.c */

ilu_string ilu_GetServerID();

void ilu_SetServerID (/* ilu_string id */);

/* ==================================== from connection.c */

ilu_bytes ilu_ReadPacket (/* ilu_Connection conn,
			     ilu_cardinal *len,
			     ilu_PacketType *type,
			     ilu_cardinal *serialNumber */);

ilu_Call ilu_BuildCall (/* ilu_cardinal serialNumber,
			   ilu_Connection connection,
			   ilu_Object object,
			   ilu_Method method */);

ilu_boolean ilu_DataPresent (/* ilu_Connection conn */);

void ilu_DropConnection (/* ilu_Connection conn */);

int ilu_FileDescriptorOfConnection (/* ilu_Connection conn */);

ilu_boolean ilu_BlockingWaitForInputOnConnection (/* ilu_Connection conn */);

/* ==================================== from locks.c */

ilu_private ilu_CreateLock ();

ilu_boolean ilu_AcquireLock (/* ilu_private lock */);	/* blocks until acquisition succeeds */

ilu_boolean ilu_ReleaseLock (/* ilu_private lock */);	/* releases held lock */

void ilu_DestroyLock (/* ilu_private lock */);

void ilu_RegisterCreateLock (/* ilu_private (*fn)() */);

void ilu_RegisterAcquireLock (/* ilu_boolean (*fn)(ilu_private lock) */);

void ilu_RegisterReleaseLock (/* ilu_boolean (*fn)(ilu_private lock) */);

void ilu_RegisterDestroyLock (/* ilu_boolean (*fn)(ilu_private lock) */);

/*============ from pipe.c =========================*/

ilu_string ilu_Pipe_Type (/* ilu_Pipe pipe */);

ilu_boolean ilu_Pipe_OtherEndGone (/* ilu_Pipe pipe *);

ilu_boolean ilu_Pipe_WillBlock (/* ilu_Pipe pipe *);

void ilu_Pipe_Destroy (/* ilu_Pipe pipe */);

ilu_Pipe ilu_Pipe_Create (/* ilu_string contact_info, ilu_string iluTypeName, ilu_boolean sink_p */);

ilu_boolean ilu_Pipe_Open (/* ilu_Pipe pipe */);

ilu_Call ilu_Pipe_Call (/* ilu_Pipe pipe */);

/* ================================================== sunrpc.c ========== */

ilu_cardinal ilu_sunrpc_SetMaxStringSize (/* ilu_cardinal max_string_size */);

#endif /* _ILU_EXPORTS_ */

