/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*/

/*
$Id: headers.c,v 1.30 1994/04/06 01:40:49 severson Exp $
*/

#include "cplusplus.h"

extern void declare_object_type(Type type, Context c);
extern void UnmarkSupertypes (Type t);

static void typedef_status_block (Context c)
{
  fprintf (c->file, "typedef struct _%s_Status_struct %sStatus;\n\n",
	   cplusplus_interface_name(c->interface), cplusplus_interface_name(c->interface));
}

static boolean MatchPointer (refany p1, refany p2)
{
  return (p1 == p2);
}

static void sort_types_for_declaration (Type type, list sorted);

static void SortArgTypes (Argument arg, list sorted)
{
  sort_types_for_declaration (arg->type, sorted);  
}

static void SortMethodTypes (Procedure m, list sorted)
{
  if (!m->returnOptional)
    sort_types_for_declaration (m->returnType, sorted);
  list_enumerate (m->arguments, (iluparser_EnumProc) SortArgTypes, sorted);
}

static void sort_types_for_declaration (Type type, list sorted)
{
  enum PrimitiveTypes t;
  static list pending = NULL;

  if (type == NULL)
    return;

  if (pending == NULL)
    pending = new_list();

  t = type_basic_type(type);

  if (list_find (sorted, MatchPointer, type) != NULL || list_find (pending, MatchPointer, type) != NULL)
    return;
  else
    {
      list_insert (pending, type);
      if (type->importInterfaceName == NULL &&
	  (t == record_Type || t == array_Type || t == union_Type || t == sequence_Type || t == object_Type))
	{
	  switch (t)
	    {
	    case record_Type:
	      
	      list_enumerate(type_description(type)->structuredDes.record, (iluparser_EnumProc) SortArgTypes, sorted);
	      break;
	      
	    case union_Type:
	      
	      list_enumerate(type_description(type)->structuredDes.uniond.types, (iluparser_EnumProc) SortArgTypes, sorted);
	      break;
	      
	    case array_Type:
	      
	      if (!type_description(type)->structuredDes.array.optional)
		sort_types_for_declaration (type_description(type)->structuredDes.array.type, sorted);
	      break;

	    case sequence_Type:

	      sort_types_for_declaration (type_description(type)->structuredDes.sequence.type, sorted);
	      break;

	    case object_Type:

	      if (type->marked)
		break;
	      list_enumerate(class_object(type)->superclasses, (iluparser_EnumProc) sort_types_for_declaration, sorted);
	      list_enumerate(class_object(type)->methods, (iluparser_EnumProc) SortMethodTypes, sorted);
	      type->marked = TRUE;
	      break;

	    default:
	      break;
	    }
	}
      if (list_find(sorted, MatchPointer, type) == NULL)
	list_insert(sorted, type);
      list_remove (pending, type);
    }
}

static void GenerateRecordField (Argument a, Context context)
{
  fprintf (context->file, "\t%s %s;\n",
	   (type_basic_type(a->type) == object_Type) ? cplusplus_return_type(a->type)
	      : cplusplus_type_name(a->type),
	   cplusplus_simple_name(a->name));
}

static void GenerateRecordDeclaration (Type t, Context context)
{
  TypeDescription type_description();

  fprintf (context->file, "struct _%s_record {\n", cplusplus_type_name(t));
  list_enumerate (type_description(t)->structuredDes.record, (iluparser_EnumProc) GenerateRecordField, context);
  fprintf (context->file, "};\n");
}

static void GenerateUnionField (Argument a, Context context)
{
  if (type_basic_type(a->type) == object_Type)
    fprintf (context->file, "\t\tclass %s *%s;\n", cplusplus_type_name(a->type), cplusplus_string(type_name(a->type)));
  else
    fprintf (context->file, "\t\t%s %s;\n",
	     cplusplus_type_name(a->type),
	     cplusplus_string(type_name(a->type)));
}

struct double_s {
  Type t;
  Context c;
};

static void GenerateUnionTypeDescriminator (Argument a, struct double_s *s)
{
  fprintf (s->c->file, ",\n\t%s_%s", cplusplus_type_name(s->t), type_name(a->type));
}

static void GenerateUnionDeclaration (Type t, Context context)
{
  list e = type_description(t)->structuredDes.uniond.types;
  struct double_s s;

  fprintf (context->file, "enum %s_allowableTypes {\n", cplusplus_type_name(t));
  s.c = context;
  s.t = t; 
  fprintf (context->file, "\t%s_%s", cplusplus_type_name(t), cplusplus_string(type_name(((Argument)list_car(e))->type)));
  list_enumerate (list_cdr(e), (iluparser_EnumProc) GenerateUnionTypeDescriminator, &s);
  fprintf (context->file, "};\nstruct _%s_union {\n", cplusplus_type_name(t));
  fprintf (context->file, "\tenum %s_allowableTypes descriminator;\n\tunion {\n", cplusplus_type_name(t));
  list_enumerate (e, (iluparser_EnumProc) GenerateUnionField, context);
  fprintf (context->file, "\t} value;\n};\n");
}

static void PrintEnumField (EnumField e, Context context)
{
  fprintf (context->file, ", %s_%s", cplusplus_type_name(context->class), cplusplus_string(e->name));
  if (e->id >= 0)
    fprintf (context->file, " = %d", e->id);  
}

static void PrintFirstEnumField (EnumField e, Context context)
{
  fprintf (context->file, "%s_%s", cplusplus_type_name(context->class), cplusplus_string(e->name));
  if (e->id >= 0)
    fprintf (context->file, " = %d", e->id);  
}

static void GenerateEnumerationTypedefDeclaration (Type t, Context context)
{
  list e;
  EnumField ef;

  fprintf (context->file, "typedef enum _%s_enum {", cplusplus_type_name(t));
  e = (type_description (t))->structuredDes.enumeration;
  ef = (EnumField) list_car(e);
  context->class = t;
  PrintFirstEnumField (ef, context);
  if (list_size(e) > 1)
    list_enumerate (list_cdr(e), (iluparser_EnumProc) PrintEnumField, context);
  fprintf (context->file, "} %s;\n", cplusplus_type_name(t));
}

void GenerateSequenceDeclaration (Type seq, FILE *file)
{
  char *tn, *stp, *spn, *srt;
  Type sequenceType;

  if (type_basic_type(seq) != sequence_Type)
    return;

  sequenceType = type_description(seq)->structuredDes.sequence.type;

  if (type_basic_type(sequenceType) == shortcharacter_Type)
    {
      /* no declaration, already handled in typedef */
    }

  else {
    
    tn = cplusplus_type_name(seq);
    stp = (type_basic_type(sequenceType) == object_Type) ? cplusplus_parameter_type(sequenceType) : cplusplus_type_name(sequenceType);
    spn = cplusplus_parameter_type(sequenceType);
    srt = cplusplus_return_type(sequenceType);

    fprintf (file, "  class _%s_sequence {\n", tn);
    fprintf (file, "   private:\n");
    fprintf (file, "    ilu_Cardinal _maximum;\n");
    fprintf (file, "    ilu_Cardinal _length;\n");
    fprintf (file, "    %s *_buffer;\n", stp);
    fprintf (file, "   public:\n");
    fprintf (file, "    _%s_sequence ();\n", tn);
    fprintf (file, "    virtual ~_%s_sequence ();\n", tn);
    fprintf (file, "    static class _%s_sequence *Create (ilu_Cardinal initial_size, %s *initial_data);\n", tn, stp);
    fprintf (file, "    virtual void Clear(ilu_Boolean free_contents);\n");
    fprintf (file, "    virtual ilu_Cardinal Length();\n");
    fprintf (file, "    virtual void Append(%s);\n", spn);
    fprintf (file, "    virtual %s RemoveHead();\n", srt);
    fprintf (file, "    virtual %s RemoveTail();\n", srt);
    fprintf (file, "    virtual ilu_Cardinal RemoveAll(ilu_Boolean (*matchproc)(%s, void *), void *arg);\n", spn);
    fprintf (file, "    virtual %s Find(ilu_Boolean (*matchproc)(%s, void *), void *arg);\n", srt, spn);
    fprintf (file, "    virtual void Enumerate(void (*enumproc)(%s, void *), void *arg);\n", srt);
    fprintf (file, "    virtual %s * Array();\n", stp);
    fprintf (file, "    virtual %s Nth(ilu_Cardinal index);\n", srt);
    fprintf (file, "  };\n\n");
  }
}

void declare_type (Type t, Context context)
{
/*
  printf ("%s %d%s  file is 0x%x\n", type_name(t), list_size(t->refs),
	  t->builtIn ? " builtin" : "", context->file);
*/
  if (t->builtIn)
    return;

  if (t->importInterfaceName != NULL)
    return;

  switch (type_basic_type(t))
    {
    case void_Type:
    case integer_Type:
    case cardinal_Type:
    case shortinteger_Type:
    case shortcardinal_Type:
    case longinteger_Type:
    case longcardinal_Type:
    case character_Type:
    case shortcharacter_Type:
    case real_Type:
    case shortreal_Type:
    case longreal_Type:
    case boolean_Type:
    case byte_Type:
    case array_Type:
      return;

    case object_Type:
      declare_object_type (t, context);		/* see declare-object.c */
      break;

    case record_Type:
      GenerateRecordDeclaration (t, context);
      break;

    case union_Type:
      GenerateUnionDeclaration (t, context);
      break;

    case sequence_Type:
      GenerateSequenceDeclaration (t, context->file);
      break;

    case enumeration_Type:
      /* already done in typedef */
      break;

    case optional_Type:
      /* already done */
      break;

    default:
      fprintf (stderr, "Error:  Can't cope with declaration of type %s yet.\n", cplusplus_type_name(t));
      SEGFAULT;
    }
}

static void GenerateUnionTypedef (Type t, Context context)
{
  fprintf (context->file, "typedef struct _%s_union %s;\n",
	   cplusplus_type_name(t), cplusplus_type_name(t));
}

static void OutputDim (long int d, Context context)
{
  fprintf (context->file, "[%lu]", d);
}

static void GenerateArrayTypedef (Type t, Context context)
{
  TypeDescription d = type_description(t);

  fprintf (context->file, "typedef %s %s", cplusplus_type_name(d->structuredDes.array.type),
	   cplusplus_type_name(t));
  list_enumerate (d->structuredDes.array.dimensions, (iluparser_EnumProc) OutputDim, context);
  fprintf (context->file, ";\n");
}

static void GenerateSequenceTypedef (Type t, Context context)
{
  TypeDescription d = type_description(t);

  if (type_basic_type(d->structuredDes.sequence.type) == shortcharacter_Type)
    fprintf (context->file, "typedef char * %s;\n", cplusplus_type_name(t));
  else
    fprintf (context->file, "typedef class _%s_sequence * %s;\n", cplusplus_type_name(t), cplusplus_type_name(t));
}

static void GenerateRecordTypedef (Type t, Context context)
{
  TypeDescription type_description();

  fprintf (context->file, "typedef struct _%s_record %s;\n", cplusplus_type_name(t), cplusplus_type_name(t));
}

void typedef_type (Type t, Context context)
{
  if (t->builtIn)
    return;

  if (t->importInterfaceName != NULL)
    return;

  switch (type_basic_type(t))
    {
    case void_Type:
      break;

    case integer_Type:
      fprintf (context->file, "typedef ilu_Integer %s;\n", cplusplus_type_name(t));
      break;

    case cardinal_Type:
      fprintf (context->file, "typedef ilu_Cardinal %s;\n", cplusplus_type_name(t));
      break;

    case shortinteger_Type:
      fprintf (context->file, "typedef ilu_ShortInteger %s;\n", cplusplus_type_name(t));
      break;

    case shortcardinal_Type:
      fprintf (context->file, "typedef ilu_ShortCardinal %s;\n", cplusplus_type_name(t));
      break;

    case longinteger_Type:
      fprintf (context->file, "typedef ilu_LongInteger %s;\n", cplusplus_type_name(t));
      break;

    case longcardinal_Type:
      fprintf (context->file, "typedef ilu_LongCardinal %s;\n", cplusplus_type_name(t));
      break;

    case real_Type:
      fprintf (context->file, "typedef ilu_Real %s;\n", cplusplus_type_name(t));
      break;

    case shortreal_Type:
      fprintf (context->file, "typedef ilu_ShortReal %s;\n", cplusplus_type_name(t));
      break;

    case longreal_Type:
      fprintf (context->file, "typedef ilu_LongReal %s;\n", cplusplus_type_name(t));
      break;

    case boolean_Type:
      fprintf (context->file, "typedef ilu_Boolean %s;\n", cplusplus_type_name(t));
      break;

    case byte_Type:
      fprintf (context->file, "typedef ilu_Byte %s;\n", cplusplus_type_name(t));
      break;

    case character_Type:
      fprintf (context->file, "typedef ilu_Character %s;\n", cplusplus_type_name(t));
      break;

    case shortcharacter_Type:
      fprintf (context->file, "typedef ilu_ShortCharacter %s;\n", cplusplus_type_name(t));
      break;

    case optional_Type:
      fprintf (context->file, "typedef %s %s %s;\n", cplusplus_return_type(type_description(t)->structuredDes.optional),
	       PassedByRef(type_description(t)->structuredDes.optional) ? "" : "*",
	       cplusplus_type_name(t));
      break;

    case array_Type:
      GenerateArrayTypedef (t, context);
      break;

    case record_Type:
      GenerateRecordTypedef (t, context);
      break;

    case object_Type:
      /* objects don't go in this file */
      break;

    case union_Type:
      GenerateUnionTypedef (t, context);
      break;

    case sequence_Type:
      GenerateSequenceTypedef (t, context);
      break;

    case enumeration_Type:
      GenerateEnumerationTypedefDeclaration (t, context);
      break;

    default:
      fprintf (stderr, "Error:  Can't cope with typedef of type %s yet.\n", cplusplus_type_name(t));
      exit (1);
    }
}

static void ListException (Exception e, Context context)
{
  if (type_basic_type (e->type) == void_Type)
    return;
  else
    fprintf (context->file, "\t\t%s %s_Value;\n", cplusplus_return_type(e->type), cplusplus_exception_name(e));
}

static void declare_status_struct (Interface i, Context c)
{
  fprintf (c->file, "#define %sReply_Success\t\t((ilu_Exception) NULL)\n\n", cplusplus_interface_name(i));
  fprintf (c->file, "struct _%s_Status_struct { ilu_Exception returnCode;\n\tunion {\n\t\tilu_Cardinal anyvalue;\n",cplusplus_interface_name(i));
  list_enumerate (i->exceptions, (iluparser_EnumProc) ListException, c);
  fprintf (c->file, "\t} values;\n};\n\n");
}

static void GenerateExceptionTable (Exception e, Context context)
{
  if (e->interface == context->interface AND e->importInterfaceName == NULL)
    fprintf (context->file, "\tilu_Exception %s;\n", cplusplus_simple_name(e->name));
}

static void generate_exception_table (Interface i, Context c)
{
  fprintf (c->file, "struct %s_Exceptions_s {\n", cplusplus_interface_name(i));
  if (list_size(i->exceptions) > 0)
    list_enumerate (i->exceptions, (iluparser_EnumProc) GenerateExceptionTable, c);
  else
    fprintf (c->file, "\tilu_CString dummyException;\n");
  fprintf (c->file, "};\n\n");
}

static void GenerateInputOutputSizeDeclaration (Type type, Context context)
{
  enum PrimitiveTypes t = type_basic_type(type);

  if (type->importInterfaceName == NULL AND
      (    TypeIsNonObjectStruct(type)
       OR (TypeIsArray(type)
	   AND (((type_basic_type(type_description(type)->structuredDes.array.type) != byte_Type)
		 AND (type_basic_type(type_description(type)->structuredDes.array.type) != shortcharacter_Type))
		OR
		list_size(type_description(type)->structuredDes.array.dimensions) > 1))
       OR (t == sequence_Type
	   AND (type_basic_type(type_description(type)->structuredDes.sequence.type) != shortcharacter_Type))))
    {
      fprintf (context->file, "  static void Output_%s (ilu_Call call, %s val);\n",
	       cplusplus_simple_name(type->name), cplusplus_parameter_type(type));
      fprintf (context->file, "  static %s Input_%s (ilu_Call call, %s ref);\n",
	       cplusplus_return_type(type), cplusplus_simple_name(type->name), cplusplus_return_type(type));
      fprintf (context->file, "  static ilu_Cardinal SizeOf_%s (ilu_Call call, %s val);\n\n",
	       cplusplus_simple_name(type->name), cplusplus_parameter_type(type));
    }
}

static void generate_interface_wide_class (Interface i, Context c)
{
  char *name = (char *) cplusplus_interface_name(i);

  fprintf (c->file, "class %s_G {\n\n", name);
  fprintf (c->file, " public:\n\n");
  fprintf (c->file, "  static struct %s_Exceptions_s *Exceptions();\n", name);
  fprintf (c->file, "  static void RaiseException (%sStatus *status, ilu_Exception exception...);\n\n",
	   name);
  list_enumerate (i->types, (iluparser_EnumProc) GenerateInputOutputSizeDeclaration, c);

  fprintf (c->file, "/* Note:  SendException should only be used by generated code, not by user code. */\n");
  fprintf (c->file, "  static int SendException (ilu_Call call, %sStatus *status);\n", name);

  fprintf (c->file, "};\n\n");
}

static void declare_exception (Exception e, Context context)
{
  if (e->interface == context->interface)
    fprintf (context->file, "#define %s\t\t(%s_G::Exceptions()->%s)\n",
	     cplusplus_exception_name(e), cplusplus_interface_name(context->interface), cplusplus_simple_name(e->name));
}

void generate_headers (Interface interface, FILE *file)
{
  struct context_s context;
  list sorted = new_list();

  context.file = file;
  context.interface = interface;
  context.class = NULL;

  fprintf (file, "#ifndef __%s_H_\n#define __%s_H_ 1\n#ifndef __ilu_H_\n#include <ilu.H>\n#endif /* ndef __ilu_H_ */\n\n",
	   cplusplus_interface_name(interface),
	   cplusplus_interface_name(interface));

  GenerateNecessaryIncludes (&context);

/*
  list_enumerate (interface->constants, declare_constant, &context);
*/
  fprintf (file, "\n");

  typedef_status_block(&context);

  list_enumerate (interface->types, (iluparser_EnumProc) typedef_type, &context);
  list_enumerate (interface->types, (iluparser_EnumProc) UnmarkSupertypes, NULL);
  list_enumerate (interface->types, (iluparser_EnumProc) sort_types_for_declaration, sorted);
  fprintf (file, "\n");

  list_enumerate (sorted, (iluparser_EnumProc) declare_type, &context);
  fprintf (file, "\n");

  generate_interface_wide_class (interface, &context);

  declare_status_struct (interface, &context);

  generate_exception_table (interface, &context);

  list_enumerate (interface->exceptions, (iluparser_EnumProc) declare_exception, &context);

  fprintf (file, "\n#endif /* ndef __%s_H_ */\n",
	   cplusplus_interface_name(interface));
}
