/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*/

/*
$Id: client.c,v 1.29 1994/04/08 03:46:02 janssen Exp $
*/

#include "cplusplus.h"

#ifdef MACOS
#pragma segment client
#endif

extern void SizeArgument(Argument arg, Context context);
extern void EncodeArgument(Argument arg, Context context);

static boolean IncludeComma = FALSE;

extern void UnmarkSupertypes (Type t);

static boolean hasMethods (Type t)
{
  return (list_size(class_object(t)->methods) > 0);
}

static void GenerateMethodLine (Procedure m, Context context)
{
  fprintf (context->file, "%s\n\t{ \"%s\", %u, %s, %s,  NULL, 0, NULL }",
	   IncludeComma ? "," : "", procedure_name(m), m->id,
	   m->functional ? "ilu_kernelTRUE" : "ilu_kernelFALSE",
	   m->asynch ? "ilu_kernelTRUE" : "ilu_kernelFALSE");
}

Type ultimateType (Type t)
{
  Type st;

  for (st = t;  st != NULL && st->supertype != NULL;  st = st->supertype)
    ;
  return (st);
}

static void GenerateMethods (Type t, Context context)
{
  Class od;

  if (t == NULL || type_basic_type(t) != object_Type || (od = class_object(t)) == NULL
      OR list_size(od->methods) == 0)
    return;

  GenerateMethodLine (list_car(od->methods), context);
  IncludeComma = TRUE;
  if (list_size(od->methods) > 1)
    list_enumerate (list_cdr(od->methods), (iluparser_EnumProc) GenerateMethodLine, context);
}

extern cardinal MethodRecordID;
extern void DefineMethods(Type class, Context context);

static void generate_methods_table (Type class, Context context)
{
  if (hasMethods(class))
    {
      fprintf (context->file, "static struct _ilu_Method_s MethodsOf%s[] = {\n", cplusplus_type_name(class));
      fprintf (context->file, "\t/* name, id, cacheable, asynchronous, evector, ecount, stubproc */\n");
      IncludeComma = FALSE;
      GenerateMethods (class, context);
      fprintf (context->file, "\n};\n\n");
    }

  MethodRecordID = 0;
  DefineMethods (class, context);
}

static boolean FirstInList = FALSE;

static void PrintTypeID (Type type, Context context)
{
  Type st;

  for (st = type;  st->supertype != NULL;  st = st->supertype)
    ;
  fprintf (context->file, "%s\t\"%s\"", (FirstInList ? "" : ",\n"), st->uid);
  FirstInList = FALSE;
}

static void generate_superclass_records (Type type, Context context)
{
  fprintf (context->file, "static ilu_Class Superclasses_for_%s[%lu];\n",
	   cplusplus_type_name(type), list_size(class_object(type)->superclasses));

  fprintf (context->file, "static ilu_CString Superclass_IDs_for_%s[%lu] = {\n", cplusplus_type_name(type),
	   list_size(class_object(type)->superclasses));
  FirstInList = TRUE;
  list_enumerate (class_object(type)->superclasses, (iluparser_EnumProc) PrintTypeID, context);
  fprintf (context->file, "\n\t};\n\n");
}

static void generate_class_table (Type class, Context context)
{
  char *tn = cplusplus_type_name(class);
  Class o = class_object(class);

  UnmarkSupertypes (class);

  if (list_size(o->superclasses) > 0)
    generate_superclass_records (class, context);

  fprintf (context->file, "struct _ilu_Class_s %s::ILUClassRecord[1] = {\n", tn);
  fprintf (context->file, "\t\"%s.%s\",\t/* ILU name */\n\t\"%s\",\t/* Brand */\n",
	   name_base_name(context->interface->name), name_base_name(class->name), o->brand == NULL ? "" : o->brand);
  fprintf (context->file, "\t\"%s\",\t/* id */\n\t%s,\t/* singleton? */\n\t%s,\t/* collectible? */\n",
	   class->uid,
	   o->singleton ? "ilu_kernelTRUE" : "ilu_kernelFALSE",
	   o->collectible ? "ilu_kernelTRUE" : "ilu_kernelFALSE");
  fprintf (context->file, "\t%s%s%s,\t/* authentication */\n",
	   o->authentication == NULL ? "" : "\"",
	   o->authentication == NULL ? "NULL" : o->authentication,
	   o->authentication == NULL ? "" : "\"");

  if (hasMethods(class))
    {
      fprintf (context->file, "\tMethodsOf%s,\t/* methods table */\n", tn);
      fprintf (context->file, "\tsizeof(MethodsOf%s)/sizeof(struct _ilu_Method_s),\t/* number of methods */\n", tn);
    }
  else
    fprintf (context->file, "\tNULL,\t/* no methods */\n\t0,\t/* zero methods */\n");

  if (o->superclasses == NULL OR list_size(o->superclasses) == 0)
    fprintf (context->file, "\t0,\t/* number of superclasses */\n\tNULL,\t/* superclass link */\n\tNULL\t/* superclass unique_id */\n};\n\n");
  else
    {
      fprintf (context->file, "\t%lu,\t/* number of superclasses */\n", list_size(o->superclasses));
      fprintf (context->file, "\tSuperclass_IDs_for_%s,\t/* IDs of superclasses */\n", tn);
      fprintf (context->file, "\tSuperclasses_for_%s,\t/* superclasses */\n", tn);
      fprintf (context->file, "\tilu_kernelFALSE};\n\n", tn);
    }
}

static void listSuper (Type t, Context context)
{
  Type st;

  if (t == NULL)
    return;

  for (st = t;  st->supertype != NULL;  st = st->supertype)
    ;

  if (st->marked)
    return;

  fprintf (context->file, "\telse if (cast_to == %s::ILUClassRecord)\n\t\treturn ((void *)((class %s *) this));\n",
	   cplusplus_type_name(st), cplusplus_type_name(st));
  st->marked = TRUE;
  list_enumerate (class_object(st)->superclasses, (iluparser_EnumProc) listSuper, context);
}

static void generate_CastDown (Type type, Context context)
{
  char *tn = cplusplus_type_name(type);

  fprintf (context->file, "class %s * %s::ILUQuaT (class iluObject *from)\n", tn, tn);
  fprintf (context->file, "{\n\treturn((class %s *) (from->ILUCastDown (%s::ILUClassRecord)));\n}\n\n", tn, tn);

  fprintf (context->file, "void * %s::ILUCastDown (ilu_Class cast_to)\n", tn);
  fprintf (context->file, "{\n\tif (cast_to == NULL)\n\t\treturn((void *)((class iluObject *) this));\n");
  fprintf (context->file, "\telse if (cast_to == %s::ILUClassRecord)\n\t\treturn ((void *) this);\n", tn);
  UnmarkSupertypes (type);
  type->marked = TRUE;
  list_enumerate (class_object(type)->superclasses, (iluparser_EnumProc) listSuper, context);
  fprintf (context->file, "\telse return (NULL);\n}\n\n");
}

static void generate_InstanceFromSBH (Type type, Context context)
{
  char *tn;
  boolean singleton;

  tn = cplusplus_type_name(context->class);
  singleton = (class_object(context->class))->singleton;

  fprintf (context->file, "class %s * %s::ILUCreateFromSBH (ilu_CString sbh, ilu_CString typeid)\n{\n", tn, tn);
  fprintf (context->file, "\treturn (%s *) ilu::SBHToObject(sbh, typeid, %s::ILUClassRecord);\n}\n\n", tn, tn);
}

static void generate_staticCreate (Type type, Context context)
{
  char *tn = cplusplus_type_name (type);

  fprintf (context->file, "static void * Create_%s(ilu_KernelObject obj) {\n",
	   tn);
  fprintf (context->file, "\tclass %s *nobj = new %s;\n", tn, tn);
  fprintf (context->file, "\tnobj->ILUSetRPCObject(obj);\n");
  fprintf (context->file, "\tilu::SetLanguageSpecificObject(obj, (class iluObject *) nobj);\n");
  fprintf (context->file, "\treturn ((void *) nobj);\n}\n\n");
}

unsigned MethodIndex = 0;
char * ArrayName = NULL;
unsigned ExceptionIndex = 0;

static void FillException (Exception e, Context context)
{
  fprintf (context->file, "\t%s.me_exceptionVector[%u] = %s;\n",
	   ArrayName, ExceptionIndex, cplusplus_exception_name(e));
  ExceptionIndex += 1;
}

static void SetupMethodExceptions (Procedure m, Context context)
{
  if (m->exceptions != NULL && list_size(m->exceptions) > 0)
    {
      char buf[1000];

      sprintf (buf, "MethodsOf%s[%d]", cplusplus_type_name(context->class), MethodIndex);
      fprintf (context->file, "\t%s.me_exceptionVector = (ilu_Exception *) malloc(sizeof(ilu_Exception) * %lu);\n",
	       buf, list_size(m->exceptions));
      fprintf (context->file, "\t%s.me_exceptionCount = %lu;\n", buf, list_size(m->exceptions));
      ExceptionIndex = 0;
      ArrayName = buf;
      list_enumerate (m->exceptions, (iluparser_EnumProc) FillException, context);
      fprintf (context->file, "\n");
    }
  MethodIndex += 1;
}

static void GenerateMethodExceptions (Type t, Context context)
{
  Class od;

   if (t == NULL || type_basic_type(t) != object_Type || (od = class_object(t)) == NULL)
    return;
  MethodIndex = 0;
  list_enumerate (od->methods, (iluparser_EnumProc) SetupMethodExceptions, context);
}

static void generate_exceptionLinking (Type type, Context context)
{
  char *tn = cplusplus_type_name (type);

  fprintf (context->file, "static void SetupExceptionVectors_%s()\n{\n", tn);
  context->class = type;
  GenerateMethodExceptions (type, context);
  fprintf (context->file, "}\n\n");
}

static void InitializeCacheSlot (Procedure m, Context context)
{
  if (IsCacheableMethod(m))
    fprintf (context->file, "\tCached_Value_for__%s__Bound = ilu_FALSE;\n", class_procedure_name(m));
}

static void generate_constructor_destructor (Type type, Context context)
{
  string tn = cplusplus_type_name(context->class);
  Class od = class_object(context->class);

  fprintf (context->file, "%s::%s ()\n{\n",
	   tn, tn);
  fprintf (context->file, "\tthis->ILUInstanceClassRecord = %s::ILUClassRecord;\n", tn);
  fprintf (context->file, "\tthis->ILUSetMostSpecificObject((void *) this);\n");
  list_enumerate (od->methods, (iluparser_EnumProc) InitializeCacheSlot, context);
  fprintf (context->file, "}\n\n");

  fprintf (context->file, "%s::~%s ()\n{\n", tn, tn);
  fprintf (context->file, "}\n\n");
}

void DeclareCallerReturnValue (Type type, Context context)
{
  if (type_basic_type(type) != void_Type)
    {
      fprintf (context->file, "\t%s _retvalue;\n", cplusplus_return_type(type));
    }
}

static void ListArgument (Argument arg, Context context)
{
  fprintf (context->file, ", %s %s", cplusplus_parameter_type(arg->type), cplusplus_argument_name(arg));
}

extern boolean IsCacheableMethod(Procedure m);

static void generate_method_code (Procedure m, Context context)
{
  enum PrimitiveTypes t = type_basic_type(m->returnType);

  /* print out formal params */

  fprintf (context->file, "%s %s::%s (%sStatus *_status",
	   cplusplus_return_type(m->returnType),
	   cplusplus_type_name(context->class), class_procedure_name(m),
	   cplusplus_interface_name(context->interface));
  list_enumerate (m->arguments, (iluparser_EnumProc) ListArgument, context);
  fprintf (context->file, ")\n{\n");

  /* declare local variables */
  DeclareCallerReturnValue(m->returnType, context);
  fprintf (context->file, "\tilu_Call _call;\n");
  fprintf (context->file, "\tilu_KernelObject _kobj;\n");
  if (BlockingCall(m))
    fprintf (context->file, "\tilu_ProtocolException _perror;\n\tilu_Cardinal _scode;\n");

  /* if method is functional, see if it is cached, and if so, return the cached value */

  if (IsCacheableMethod(m))
    {
      fprintf (context->file, "\tif (this->Cached_Value_for__%s__Bound)\n\t   {\n", class_procedure_name(m));
      fprintf (context->file, "\t    _status->returnCode = NULL;\n\t    return (this->Cached_Value_for__%s);\n\t   };\n\n",
	       class_procedure_name(m));
    }

  /* start code */
  fprintf (context->file, "\t_kobj = this->ILUGetRPCObject();\n");
  fprintf (context->file, "\tif ((_call = ilu::BeginCall (_kobj)) == NULL)\n");
  fprintf (context->file, "\t{\n\t\t_status->returnCode = ilu::ProtocolError;\n");
  fprintf (context->file, "\t\t_status->values.anyvalue = (ilu_Cardinal) ilu_ProtocolException_LostConnection;\n");
  fprintf (context->file, "\treturn");
  if (t == void_Type)
    fprintf (context->file, ";\n\t};\n");
  else
    fprintf (context->file, " ((%s) 0);\n\t};\n", cplusplus_return_type(m->returnType));
  fprintf (context->file, "\tilu::BeginRequest (_call, %s::ILUClassRecord, MethodRecord_%s_%s, (0",
	   cplusplus_type_name(m->object),
	   cplusplus_type_name(context->class), class_procedure_name(m));
  list_enumerate (m->arguments, (iluparser_EnumProc) SizeArgument, context);
  if (!context->class->description->structuredDes.object->singleton)
    fprintf (context->file, "+ilu::SizeOfObjectID(_call, _kobj, ilu_TRUE, NULL)");
  fprintf (context->file, "));\n");
  if (!context->class->description->structuredDes.object->singleton)
    fprintf (context->file, "\tilu::OutputObjectID (_call, _kobj, ilu_TRUE, NULL);\n");
  list_enumerate (m->arguments, (iluparser_EnumProc) EncodeArgument, context);
  fprintf (context->file, "\tilu::FinishRequest (_call);\n\n");
  if (BlockingCall(m))
    {
      fprintf (context->file, "\tif ((_perror = ilu::WaitForReply (_call, &_scode)) == ilu_ProtocolException_Success)\n\t{\n");
      fprintf (context->file, "\t\tif (_scode == 0)\n\t\t{\n\t\t\t_status->returnCode = NULL;\n\t\t");
      if (t == void_Type)
	fprintf (context->file, "\t/* nothing to read from remote side */\n");
      else
	{
	  UnpackValue (context, m->returnType, m->def, "_retvalue",
		       (TypeIsNonObjectStruct(m->returnType)
			OR (TypeIsArray(m->returnType) AND NOT TypeIsString(m->returnType))),
		       m->returnOptional, TRUE);
	  if (IsCacheableMethod(m))
	    {
	      fprintf (context->file, "\t\t\tif (!this->Cached_Value_for__%s__Bound)\n\t\t\t\t{\n\t\t\t\tthis->Cached_Value_for__%s = _retvalue;\n", class_procedure_name(m), class_procedure_name(m));
	      fprintf (context->file, "\t\t\t\tthis->Cached_Value_for__%s__Bound = ilu_TRUE;\n\t\t\t\t};\n",
		       class_procedure_name(m));
	    }
	}
      fprintf (context->file, "\t\t}");
      if (list_size(m->exceptions) > 0)
	fprintf (context->file, "\n\t\telse\n\t\t\t%sCatchException (_call, _status, _scode);\n",
		 cplusplus_interface_name(context->interface));
      else
	fprintf (context->file, ";\n\t\t/* no exceptions to catch */\n");
      fprintf (context->file, "\t}\n\telse\n\t{\n");
      fprintf (context->file, "\t\t_status->returnCode = ilu::ProtocolError;\n");
      fprintf (context->file, "\t\t_status->values.anyvalue = (ilu_Cardinal) _perror;\n\t};\n");
    }
  fprintf (context->file, "\tilu::FinishCall (_call);\n");
  fprintf (context->file, "\treturn");
  if (t != void_Type)
    fprintf (context->file, "(_retvalue)");
  fprintf (context->file, ";\n}\n\n");
}

void generate_class_code (Type type, Context context)
{
  context->class = type;

  generate_methods_table (type, context);
  generate_class_table (type, context);
  generate_InstanceFromSBH (type, context);
  generate_CastDown (type, context);
  generate_constructor_destructor (type, context);

  list_enumerate ((class_object(type))->methods, (iluparser_EnumProc) generate_method_code, context);

  generate_staticCreate (type, context);
  generate_exceptionLinking (type, context);
}
