UNSAFE INTERFACE M3toC2;
IMPORT Ctypes;

TYPE
  SL = RECORD
         s: Ctypes.CharStar;
         l: CARDINAL;
       END;
  (* A string representation sometimes used in C: s is a pointer
     to the first character of the string, and l is the length of
     the string.  There is not (necessarily) a null character
     after the l characters. *)

PROCEDURE SLtoT (s: Ctypes.CharStar; l: CARDINAL): TEXT;
  (* Return a text containing the same character sequence as s&l.
     This may or may not copy.  The result may be invalid after
     s is freed. *)

PROCEDURE CopySLtoT (s: Ctypes.CharStar; l: CARDINAL): TEXT;
  (* Return a text containing the same character sequence as s&l.
     This copies s. *)

PROCEDURE TtoSL (t: TEXT): SL;
  (* Return an SL with the same character sequence as t.
     sl.s[sl.l] is the null character.  This may or may not copy.
     sl.s should be passed to FreeS after it is irrelevant and
     before t is collected. *)

PROCEDURE CopyTtoSL (t: TEXT): SL;
  (* Return an SL with the same character sequence as t.
     sl.s[sl.l] is the null character.  This copies t.  sl.s
     should be passed to FreeS after it is irrelevant and before
     t is collected. *)

PROCEDURE FreeS (s: Ctypes.CharStar);
  (* If s was copied from a text by TtoSL or CopyTtoSL, this
     frees the storage for s; if s was shared with a text by
     TtoSL, this is a no-op. *)

END M3toC2.
