/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*/

#ifndef _ILU_CPLUSPLUS_DEFS_H_
#define _ILU_CPLUSPLUS_DEFS_H_ 1

#ifndef NULL
#define NULL	0
#endif

/* ==================== basic types ==================== */

typedef enum { ilu_TRUE = 1, ilu_FALSE = 0} ilu_boolean;

typedef long int ilu_integer;
typedef short int ilu_shortinteger;
typedef long int ilu_longinteger[2];

typedef unsigned long int ilu_cardinal;
typedef unsigned short int ilu_shortcardinal;
typedef unsigned long int ilu_longcardinal[2];

typedef double ilu_real;
typedef float ilu_shortreal;
typedef double ilu_longreal;

typedef unsigned short ilu_character;
typedef unsigned char ilu_shortcharacter;

typedef char * ilu_string;
typedef ilu_character *ilu_wstring;
typedef unsigned char * ilu_opaque;
typedef unsigned char * ilu_bytes;
typedef unsigned char ilu_byte;

typedef void * ilu_refany;
typedef void * ilu_private;

typedef void		(*ilu_void_procedure)();
typedef ilu_boolean	(*ilu_boolean_procedure)();

typedef enum _ilu_PacketTypes {
  ilu_PacketType_Request = 0,
  ilu_PacketType_Reply = 1
} ilu_PacketType;

typedef enum ilu_ProtocolExceptions {
  ilu_ProtocolException_Success = 0,
  ilu_ProtocolException_NoSuchClassAtServer = 1,
  ilu_ProtocolException_ClassVersionMismatch = 2,
  ilu_ProtocolException_NoSuchMethodOnClass = 3,
  ilu_ProtocolException_GarbageArguments = 4,
  ilu_ProtocolException_Unknown = 5,
  ilu_ProtocolException_LostConnection = 6,
  ilu_ProtocolException_RequestRejected = 7,
  ilu_ProtocolException_RequestTimeout = 8
} ilu_ProtocolException;

enum ilu_InterpretRequestStatus {
  ilu_InterpretRequest_Failed = 1,		/* couldn't interpret packet */
  ilu_InterpretRequest_Succeeded = 2,	/* successful -- go ahead and invoke method */
  ilu_InterpretRequest_Handled = 3};	/* successful, and already handled, internally */

typedef char * ilu_Exception;	/* address of exception description */

typedef struct _ilu_Class_s *	ilu_Class;	/* class description for server */

typedef struct _ilu_Method_s * 	ilu_Method;	/* method description for server */

typedef struct _ilu_Call_s *	ilu_Call;	/* call description */

typedef void	(*ilu_stub_procedure)(ilu_Call);

struct _ilu_Method_s {			/* read-only; no locks needed */
  ilu_string me_name;
  ilu_cardinal me_id;
  ilu_boolean me_cacheable;		/* functional? */
  ilu_boolean me_asynchronous;		/* need to wait after calling? */
  ilu_Exception *me_exceptionVector;	/* list of possible exceptions */
  ilu_cardinal me_exceptionCount;	/* number of exceptions in list */
  ilu_stub_procedure me_stubproc;
};

struct _ilu_Class_s {				/* read-only: no locks needed */

  ilu_string cl_name;				/* ILU name of class */
  ilu_string cl_brand;				/* brand on class */
  ilu_string cl_unique_id;			/* unique id for type graph of class */
  ilu_boolean cl_singleton;			/* TRUE (1) if class is a singleton */
  ilu_boolean cl_collectible;
  ilu_string cl_authentication;			/* non-NULL with name of authentication type, if any */
  ilu_Method cl_methods;
  ilu_cardinal cl_method_count;
  ilu_cardinal cl_scls_count;
  ilu_string *cl_scls_ids;			/* name of superclass */
  ilu_Class *cl_sclses;				/* chain of links to root */
  ilu_boolean cl_shown;
};

typedef void * ilu_FineTime;

typedef void * ilu_Server;	/* handle held by client on server */

typedef void * ilu_Client;	/* handle held by server on client */

typedef void * ilu_Connection;	/* wrapper for bytestream connection */

typedef void * ilu_Object;	/* wrapper around server for instances */

typedef void * ilu_Pipe;	/* pipe for connection to other module */

typedef void * ilu_TransportClass;	/* methods for Transport */

typedef void * ilu_Transport;	/* abstraction of a TCP/IP or XNS Transport */

typedef void * ilu_Protocol;	/* protocol binding */

typedef void * ilu_PortClass;	/* methods for a Port */

typedef void * ilu_Port;	/* handle held by server on bytestream */

typedef void * ilu_Mooring;	/* abstraction of a listen socket */

typedef void * ilu_Lock;	/* slot for lock implementation's use */

struct _ilu_Call_s {
  ilu_cardinal		ca_SN;		/* serial number of request */
  ilu_Server		ca_server;	/* server of call */
  ilu_Class		ca_intro_type;	/* Significant in incoming calls */
  ilu_Method		ca_method;	/* method of call */
  ilu_Connection	ca_connection;	/* connection which points to (server or client) */
  ilu_refany		ca_private;	/* slot for lang-specific implementation's use */
};

typedef struct {
  ilu_private	(*lt_mcreate )(ilu_string d1, ilu_string d2);
  void		(*lt_acquire )(ilu_private m);
  void		(*lt_hold    )(ilu_private m);
  void		(*lt_release )(ilu_private m);
  void		(*lt_mdestroy)(ilu_private m);
  ilu_private	(*lt_ccreate)(ilu_string d1, ilu_string d2);
  void		(*lt_notify  )(ilu_private c);
  void		(*lt_cdestroy)(ilu_private c);
  void		(*lt_wait    )(ilu_private c, ilu_private m,
				 ilu_FineTime *limit);
} ilu_LockTech;

#endif /* _ILU_CPLUSPLUS_DEFS_H_ */
