INTERFACE fs;

(* Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

   Unlimited use, reproduction, and distribution of this software is
   permitted.  Any copy of this software must include both the above
   copyright notice of Xerox Corporation and this paragraph.  Any
   distribution of this software must comply with all applicable United
   States export control laws.  This software is made available AS IS,
   and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
   INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
   AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
   PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
   THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
   CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
   XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

   $Id: fs.isl,v 1.3 1993/09/23 22:16:32 janssen Exp $
*)

TYPE UnixTime = CARDINAL;
TYPE Filename = ilu.CString;
TYPE ByteSeq = SEQUENCE OF BYTE;
TYPE DirectoryListing = SEQUENCE OF ilu.CString;
TYPE FileInfo = RECORD
  name : ilu.CString,
  owner : ilu.CString,
  write-date : UnixTime,
  length : CARDINAL
END;

EXCEPTION NotFound : Filename;
EXCEPTION NotADirectory : Filename;
EXCEPTION OutOfBounds;

TYPE File = CLASS

  BRAND "v1"

  METHODS

   FUNCTIONAL Info () : FileInfo,	(* files are read-only *)
   Touch (),				(* test of method without result *)
   ASYNCHRONOUS TouchA (),		(* test of method without result declared ASYNCH *)
   Contents (begin : CARDINAL, length : CARDINAL) : ByteSeq
    RAISES OutOfBounds END

  END;

TYPE OptionalString = OPTIONAL ilu.CString;

TYPE Directory = CLASS

  SUPERCLASS File

  METHODS

   Files (pattern : OptionalString) : DirectoryListing RAISES NotADirectory END

  END;

TYPE Server = CLASS

  METHODS

   FindFile (name : Filename) : File RAISES NotFound END

  END;	
