(* GooM3Server.m3 *)
(* Last tweaked by Mike Spreitzer April 21, 1994 5:00 pm PDT *)

(* A server program that implements a Goo.O and a Goo.P. *)

MODULE GooM3Server EXPORTS Main;
IMPORT Fmt, Goo, Ilu, IluBasics, Stdio, Thread, Time, Wr;

<*FATAL Thread.Alerted, Wr.Failure*>

TYPE
  TrueO = Goo.O OBJECT
            id: INTEGER;
          OVERRIDES
            ILU_Get_Server := ILU_Get_Server;
            m1             := O_m1;
            ILU_Qua_Type   := Qua_From_O;
          END;

  TrueP = Goo.P OBJECT
            id: INTEGER
          OVERRIDES
            ILU_Get_Server := ILU_Get_Server;
            m1             := P_m1;
            m2             := m2;
            ILU_Qua_Type   := Qua_From_P;
          END;

VAR
  ts     :  Ilu.TrueServer;
  goType := Goo.ILU_Get_Type_O(NIL);
  goId   := Ilu.IdOfObjectType(goType);
  gpType := Goo.ILU_Get_Type_P(NIL);
  gpId   := Ilu.IdOfObjectType(gpType);

PROCEDURE Qua_From_O (self: TrueO; ot: Ilu.ObjectType): Ilu.Object =
  BEGIN
    IF ot = goType THEN RETURN self ELSE RETURN NIL END;
  END Qua_From_O;

PROCEDURE Qua_From_P (self: TrueP; ot: Ilu.ObjectType): Ilu.Object =
  BEGIN
    IF ot = goType OR ot = gpType THEN RETURN self ELSE RETURN NIL END;
  END Qua_From_P;

PROCEDURE ILU_Get_Server (<*UNUSED*> self: Ilu.Object): Ilu.Server =
  BEGIN
    RETURN ts;
  END ILU_Get_Server;

PROCEDURE O_m1 (self: TrueO; i: INTEGER): Goo.IS RAISES {Goo.E1} =
  VAR ans := NEW(Goo.IS, 2);
  BEGIN
    ans[0] := self.id;
    ans[1] := 10 * i + 1;
    RETURN ans;
  END O_m1;

PROCEDURE P_m1 (self: TrueP; i: INTEGER): Goo.IS RAISES {Goo.E1} =
  VAR ans := NEW(Goo.IS, 2);
  BEGIN
    ans[0] := self.id;
    ans[1] := 10 * i + 2;
    RETURN ans;
  END P_m1;

PROCEDURE m2 (self: TrueP; i: INTEGER): Goo.IS =
  VAR ans := NEW(Goo.IS, 2);
  BEGIN
    ans[0] := self.id;
    ans[1] := 10 * i + 3;
    RETURN ans;
  END m2;

VAR
  os1 := NEW(TrueO, id := 10);
  ps2 := NEW(TrueP, id := 20);
VAR sbh1, sbh2: TEXT;
VAR
  p1 := 60;
  p2 := 30;

BEGIN
  TRY
    ts := Ilu.InitTrueServer(NEW(Ilu.TrueServer));
    Ilu.Export_Server(ts, NEW(Ilu.SunRpc2), NEW(Ilu.TCP));

    Wr.PutText(Stdio.stdout, "Goo.O tid is " & goId & "\n");
    Wr.PutText(Stdio.stdout, "Goo.P tid is " & gpId & "\n");

    sbh1 := Ilu.SbhFromObject(os1);
    Wr.PutText(
      Stdio.stdout, "SBH1&mstid is '" & sbh1 & "' '" & goId & "'\n");
    Wr.Flush(Stdio.stdout);

    sbh2 := Ilu.SbhFromObject(ps2);
    Wr.PutText(
      Stdio.stdout, "SBH2&mstid is '" & sbh2 & "' '" & gpId & "'\n");
    Wr.Flush(Stdio.stdout);

    Time.LongPause(p1);
    Wr.PutText(Stdio.stdout, "Closing obj 1.\n");
    Wr.Flush(Stdio.stdout);
    os1.ILU_Close();

    Time.LongPause(p2);
    Wr.PutText(Stdio.stdout, "Closing obj 2.\n");
    Wr.Flush(Stdio.stdout);
    ps2.ILU_Close();

    LOOP
      (* Linebreak, if you PLEASE! *)
      Time.LongPause(10);
    END (*loop*);
  EXCEPT
    IluBasics.Failed (e) =>
      Wr.PutText(
        Stdio.stderr,
        Fmt.F("IluBasics.Failed(%s)\n", IluBasics.FullInfo(e)));
      Wr.PutText(
        Stdio.stderr,
        "(This might be caused by not registering Goo.isl.)\n");
  END (*try*);

END GooM3Server.
