(* FooM3Server.m3 *)
(* Last tweaked by Mike Spreitzer April 21, 1994 4:51 pm PDT *)

(* A server program that implements a couple of Foo.O objects. *)

MODULE FooM3Server EXPORTS Main;
IMPORT Fmt, Foo, Ilu, IluBasics, ParseParams, RTMisc, Scan, Stdio,
       Thread, Time, Wr;

<*FATAL Thread.Alerted, Wr.Failure*>

TYPE
  TrueFoo = Foo.O OBJECT
              id: INTEGER
            OVERRIDES
              ILU_Get_Server := ILU_Get_Server;
              U_CSS_to_U     := U_CSS_to_U;
              ILU_Qua_Type   := TrueQua;
            END;

VAR ts: Ilu.TrueServer;
VAR fooType := Foo.ILU_Get_Type_O(NIL);
VAR fooId := Ilu.IdOfObjectType(fooType);

PROCEDURE TrueQua (self: TrueFoo; ot: Ilu.ObjectType): Ilu.Object =
  BEGIN
    IF ot = fooType THEN RETURN self ELSE RETURN NIL END;
  END TrueQua;

PROCEDURE ILU_Get_Server (<*UNUSED*> self: TrueFoo): Ilu.Server =
  BEGIN
    RETURN ts;
  END ILU_Get_Server;

PROCEDURE U_CSS_to_U (self: TrueFoo; u: Foo.U; css: Foo.CSS): Foo.U
  RAISES {Foo.E1, Foo.E2} =
  BEGIN
    CASE NUMBER(css^) OF
    | 0 => RETURN u;
    | 1 => RAISE Foo.E1(u);
    | 2 => RAISE Foo.E2(self.id);
    | 3 => RETURN NEW(Foo.U_CSS, v := css);
    | 4 => RETURN NEW(Foo.U_O, v := self);
    ELSE
      RETURN NEW(Foo.U_OO, v := NEW(TrueFoo, id := NUMBER(css^)));
    END (*case*);
  END U_CSS_to_U;

VAR fs1 := NEW(TrueFoo, id := 100);
VAR fs2 := NEW(TrueFoo, id := 200);
VAR sbh1, sbh2: TEXT;
VAR ti: Ilu.TransportInfo := NEW(Ilu.TCP);

BEGIN
  TRY
    ParseParams.BeginParsing(Stdio.stderr);
    IF ParseParams.KeywordPresent("-u") THEN
      ti := NEW(Ilu.UDP)
    ELSIF ParseParams.KeywordPresent("-t") THEN
      ti := NEW(Ilu.TCP)
    END (*if*);
    ParseParams.EndParsing();
  EXCEPT
  | Scan.BadFormat =>
      Wr.PutText(Stdio.stderr, "Usage: FooM3Server [-t|-u]\n");
      RTMisc.Exit(1);
  END (*try*);

  TRY
    ts := Ilu.InitTrueServer(NEW(Ilu.TrueServer));
    Ilu.Export_Server(ts, NEW(Ilu.SunRpc2), ti);

    sbh1 := Ilu.SbhFromObject(fs1);
    Wr.PutText(
      Stdio.stdout, "SBH1&mstid is '" & sbh1 & "' '" & fooId & "'\n");
    Wr.Flush(Stdio.stdout);

    sbh2 := Ilu.SbhFromObject(fs2);
    Wr.PutText(
      Stdio.stdout, "SBH2&mstid is '" & sbh2 & "' '" & fooId & "'\n");
    Wr.Flush(Stdio.stdout);

    LOOP
      (* Linebreak, if you PLEASE! *)
      Time.LongPause(10);
    END (*loop*);
  EXCEPT
    IluBasics.Failed (e) =>
      Wr.PutText(
        Stdio.stderr,
        Fmt.F("IluBasics.Failed(%s)\n", IluBasics.FullInfo(e)));
      Wr.PutText(
        Stdio.stderr,
        "(This might have been caused by not registering Foo.isl.)\n");
  END (*try*);
END FooM3Server.
