


imake(1)                 USER COMMANDS                   imake(1)



NAME
     imake - C preprocessor interface to the make utility

SYNOPSIS
     imake [-D_d_e_f_i_n_e]  [-I_d_i_r]  [-T_t_e_m_p_l_a_t_e]  [-f  _f_i_l_e_n_a_m_e]  [-s
     _f_i_l_e_n_a_m_e] [-e] [-v]

DESCRIPTION
     _I_m_a_k_e is used to generate _M_a_k_e_f_i_l_e_s from a template,  a  set
     of  _c_p_p  macro  functions,  and  a  per-directory input file
     called an _I_m_a_k_e_f_i_l_e.  This allows machine dependencies (such
     has  compiler  options, alternate command names, and special
     _m_a_k_e rules) to be kept separate from the descriptions of the
     various items to be built.

OPTIONS
     The following command line options may be passed to _i_m_a_k_e:

     -D_d_e_f_i_n_e
             This option is passed directly to _c_p_p.  It is  typi-
             cally used to set directory-specific variables.  For
             example, the X Window System uses this flag  to  set
             _T_O_P_D_I_R  to  the name of the directory containing the
             top of the core distribution and _C_U_R_D_I_R to the  name
             of the current directory, relative to the top.

     -I_d_i_r_e_c_t_o_r_y
             This option is passed directly to _c_p_p.  It is  typi-
             cally  used  to  indicate the directory in which the
             _i_m_a_k_e template and configuration files may be found.

     -T_t_e_m_p_l_a_t_e
             This option specifies the name of  the  master  tem-
             plate  file  (which is usually located in the direc-
             tory specified with -_I) used by _c_p_p.  The default is
             _I_m_a_k_e._t_m_p_l.

     -f _f_i_l_e_n_a_m_e
             This option specifies the name of the  per-directory
             input file.  The default is _I_m_a_k_e_f_i_l_e.

     -s _f_i_l_e_n_a_m_e
             This option specifies the name of the _m_a_k_e  descrip-
             tion  file  to  be  generated but _m_a_k_e should not be
             invoked.  If the _f_i_l_e_n_a_m_e is a dash (-), the  output
             is  written  to _s_t_d_o_u_t.  The default is to generate,
             but not execute, a _M_a_k_e_f_i_l_e.

     -e      This option indicates the _i_m_a_k_e should  execute  the
             generated _M_a_k_e_f_i_l_e.  The default is to leave this to
             the user.




X Version 11      Last change: 8 November 1990                  1






imake(1)                 USER COMMANDS                   imake(1)



     -v      This option indicates that _i_m_a_k_e  should  print  the
             _c_p_p  command  line  that it is using to generate the
             _M_a_k_e_f_i_l_e.

HOW IT WORKS
     _I_m_a_k_e invokes _c_p_p with any -_I or -_D flags passed on the com-
     mand line and passes it the following 3 lines:

               #define IMAKE_TEMPLATE "Imake.tmpl"
               #define INCLUDE_IMAKEFILE "Imakefile"
               #include IMAKE_TEMPLATE

     where _I_m_a_k_e._t_m_p_l and _I_m_a_k_e_f_i_l_e may be overridden by  the  -_T
     and -_f command options, respectively.  If the _I_m_a_k_e_f_i_l_e con-
     tains any lines beginning with a '#' character that  is  not
     followed  by  a  _c_p_p  directive  (#include, #define, #undef,
     #ifdef, #else, #endif, or #if), _i_m_a_k_e will make a  temporary
     _m_a_k_e_f_i_l_e  in  which  the  '#'  lines  are prepended with the
     string ``/**/'' (so that _c_p_p will copy  the  line  into  the
     _M_a_k_e_f_i_l_e as a comment).

     The _I_m_a_k_e_f_i_l_e reads  in  file  containing  machine-dependent
     parameters  (specified  as  _c_p_p  symbols),  a  site-specific
     parameters file, a file containing _c_p_p macro  functions  for
     generating  _m_a_k_e rules, and finally the _I_m_a_k_e_f_i_l_e (specified
     by  INCLUDE_IMAKEFILE)  in  the  current   directory.    The
     _I_m_a_k_e_f_i_l_e  uses the macro functions to indicate what targets
     should  be  built;  _i_m_a_k_e  takes  care  of  generating   the
     appropriate rules.

     The rules file (usually named _I_m_a_k_e._r_u_l_e_s in the  configura-
     tion  directory)  contains  a variety of _c_p_p macro functions
     that are  configured  according  to  the  current  platform.
     _I_m_a_k_e  replaces  any occurrences of the string ``@@'' with a
     newline to allow macros that generate more than one line  of
     _m_a_k_e rules. For example, the macro

     #define program_target(program, objlist)          @@\
     program:        objlist                           @@\
             $(CC) -o $@ objlist $(LDFLAGS)

     when called with  _p_r_o_g_r_a_m__t_a_r_g_e_t(_f_o_o,  _f_o_o_1._o  _f_o_o_2._o)  will
     expand to

     foo:    foo1.o foo2.o
             $(CC) -o $@ foo1.o foo2.o $(LDFLAGS)


     On systems whose _c_p_p reduces multiple tabs and spaces  to  a
     single  space, _i_m_a_k_e attempts to put back any necessary tabs
     (_m_a_k_e is very picky about the difference  between  tabs  and
     spaces).   For this reason, colons (:) in command lines must



X Version 11      Last change: 8 November 1990                  2






imake(1)                 USER COMMANDS                   imake(1)



     be preceded by a backslash (\).

USE WITH THE X WINDOW SYSTEM
     The X Window System uses _i_m_a_k_e extensively,  for  both  full
     builds  within  the  source  tree and external software.  As
     mentioned above, two special variables,  _T_O_P_D_I_R  and  _C_U_R_D_I_R
     set  to  make  referencing  files  using relative path names
     easier.  For example, the  following  command  is  generated
     automatically  to build the _M_a_k_e_f_i_l_e in the directory _l_i_b/_X/
     (relative to the top of the sources):

             %  ../.././config/imake  -I../.././config \
                     -DTOPDIR=../../. -DCURDIR=./lib/X

     When building X programs outside the source tree, a  special
     symbol  _U_s_e_I_n_s_t_a_l_l_e_d  is  defined  and _T_O_P_D_I_R and _C_U_R_D_I_R are
     omitted.  If the  configuration  files  have  been  properly
     installed,  the  script  _x_m_k_m_f(_1) may be used to specify the
     proper options:

             %  xmkmf

     The command _m_a_k_e _M_a_k_e_f_i_l_e_s can  then  be  used  to  generate
     _M_a_k_e_f_i_l_e_s in any subdirectories.

FILES
     /usr/tmp/tmp-imake._n_n_n_n_n_n     temporary input file for cpp
     /usr/tmp/tmp-make._n_n_n_n_n_n      temporary input file for make
     /lib/cpp                      default C preprocessor

SEE ALSO
     make(1)
     S. I. Feldman _M_a_k_e - _A _P_r_o_g_r_a_m _f_o_r _M_a_i_n_t_a_i_n_i_n_g _C_o_m_p_u_t_e_r _P_r_o_-
     _g_r_a_m_s

ENVIRONMENT VARIABLES
     The following environment  variables  may  be  set,  however
     their  use is not recommended as they introduce dependencies
     that are not readily apparent when _i_m_a_k_e is run:

     IMAKEINCLUDE
          If defined, this should be a valid include argument for
          the  C  preprocessor.   E.g.  ``-I/usr/include/local''.
          Actually, any valid _c_p_p argument will work here.

     IMAKECPP
          If defined, this should be a valid path to a preproces-
          sor  program.   E.g.  ``/usr/local/cpp''.   By default,
          _i_m_a_k_e will use /lib/cpp.

     IMAKEMAKE
          If defined, this should be  a  valid  path  to  a  make



X Version 11      Last change: 8 November 1990                  3






imake(1)                 USER COMMANDS                   imake(1)



          program.   E.g. ``/usr/local/make''.  By default, _i_m_a_k_e
          will  use  whatever  _m_a_k_e  program   is   found   using
          execvp(3).

BUGS
     Comments should be preceded by  ``/**/#''  to  protect  them
     from _c_p_p.

AUTHOR
     Todd Brunhoff, Tektronix and MIT Project Athena; Jim Fulton,
     MIT X Consortium












































X Version 11      Last change: 8 November 1990                  4



