;;; -*- Mode: Lisp -*-

;;; binary-trees-package.lisp --
;;; Binary Search Trees in the CLR style. (Cormen,
;;; Leiserson and Rivest, "Introduction to Algorithms", ppgg.
;;; 244--262, MIT Press).
;;; Package definition file (in CLtL2 style).
;;;
;;; Author: Marco Antoniotti
;;; Address: Robotics Laboratory
;;;          Courant Institute of Mathematical Science
;;;          New York University
;;;          New York, NY, 10012
;;;
;;; Copyright (c) 1992. All rights reserved.
;;;
;;; Version: 1.0 beta

;;;============================================================================
;;; General License Agreement and Lack of Warranty
;;;
;;; See companion file 'binary-trees.lisp'


;;;============================================================================
;;; History:
;;; 12.26.1992: released.


(defpackage "TREES" (:use "COMMON-LISP" "CONDITIONS")
  (:export make-tree
	   tree-p
	   size
	   element-type
	   name
	   empty-p
	   search
	   insert
	   traverse
	   minimum
	   maximum
	   successor
	   predecessor
	   delete-by-key

	   empty-error
	   duplicate-key
	   )
  (:shadow search)
  )

(in-package "TREES")


;;; end of file -- binary-trees-package.lisp --
