;;; Mon May 31 19:20:27 1993 by Mark Kantrowitz <mkant@GLINDA.OZ.CS.CMU.EDU>
;;; autoload.lisp -- 615 bytes

;;; ****************************************************************
;;; Autoload *******************************************************
;;; ****************************************************************
;;; Based on code written by Thomas M. Breuel, <tmb@idiap.ch>.

;;; See also the LIBFASL feature of LOAD in Allegro CL.

(defun autoload (function file &optional documentation)
  "Defines FUNCTION (a symbol) to autoload from FILE (a string). 
   The third argument is the documentation for the function."
  (proclaim `(notinline ,function))
  (let ((%auto-loaded% nil))
;   (declare (special %auto-loaded%))
    (setf (symbol-function function)
	  #'(lambda (&rest args)
	      #-:cmu (declare (dynamic-extent args))
	      (cond (%auto-loaded%
		     ;; If the file has already been loaded and yet
		     ;; the function still has the autoload stub code,
		     ;; let's error to avoid an infinite loop.
		     (error "Function ~S has no definition in file ~S."
			    function file))
		    (t
		     (load file :verbose t)     
		     (setq %auto-loaded% t)
		     (apply (symbol-function function) args))))))
  (setf (documentation function 'function)
	(or documentation
	    (format nil "autoloaded function from file ~s" file)))
  function)

(defun autoload-functions (file functions)
  (dolist (function functions)
    (if (consp function)
	(funcall #'autoload (first function) file (second function))
	(funcall #'autoload function file))))

;;;(autoload 'foo "foo.lisp" "The FOO function for bazzing away.")

;;; *EOF*
