

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                                 ;;;
;;;                                                                                 ;;;
;;;                         CSP Representations                                     ;;;
;;;                                                                                 ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(in-package :user)

(proclaim '(optimize (compilation-speed 0) (safety 1) (speed 3)))

(defvar *n* 0)
(defvar *vars* nil)
(defvar *constraints* nil)
(defvar *free-constraints* nil)
(defvar *free-vars* nil)
(defvar *trace* nil)

(defvar v (make-array 31))
(defvar name (make-array 31))
(defvar domain (make-array 31))
(defvar original-domain (make-array 31))
(defvar current-domain (make-array 31))
(defvar constraint (make-array '(31 31)))
(defvar max-check (make-array 31))
(defvar conf-set (make-array 31))
(defvar mbl (make-array 31))
(defvar mcl (make-array '(31 31)))
(defvar reasons (make-array '(31 31)))
(defvar reason (make-array 31))
(defvar culprit (make-array '(31 31)))
(defvar nogood (make-array '(31 31)))
(defvar reductions (make-array 31))
(defvar past-fc (make-array 31))
(defvar future-fc (make-array 31))
(defvar P nil)
(defvar adjacent (make-array 31))
(defvar original-adjacent (make-array 31))
(defvar parents (make-array 31))
(defvar visited (make-array 31))
(defvar instantiated (make-array 31))

(defvar checks 0)
(defvar nodes 0)
(defvar backtracks 0)
(defvar solutions 0)
(defvar consistent t)

(defclass var ()
  ((name :initarg :name
	 :accessor name)
   (domain :initarg :domain
	  :accessor domain)
   (constraints :accessor constraints
	      :initform nil)
   (i :accessor i)))

(defun make-var (name domain)
  (let ((v (or (pop *free-vars*) (make-instance 'var))))
    (setf (name v) name
	  (domain v) domain
	  (constraints v) nil
	  (i v) nil)
    (setq *vars* (append *vars* (list v)))
    v))

(defmethod delete-object ((v var))
  (cond (*trace* (print (list 'delete-var (look v)))))
  (setq *vars* (remove v *vars*))
  (setf (name v) nil
	  (domain v) nil
	  (constraints v) nil
	  (i v) nil)
  (push v *free-vars*)
  nil)

(defun get-var (name)
  (let ((var (find name *vars* :key 'name)))
    (cond ((null var) (print (list "not found var named" name))))
    var))
	  

(defmethod look ((v var))
  (format nil "~A in ~A" (name v) (domain v)))

(defclass constraint ()
  ((v1 :accessor v1)
   (f :accessor f)
   (v2 :accessor v2)))

(defun make-constraint (name-v1 f name-v2)
  (let ((c (or (pop *free-constraints*) (make-instance 'constraint)))
	(v1 (get-var name-v1))
	(v2 (get-var name-v2)))
    (setf (v1 c) v1
	  (f c) f
	  (v2 c) v2)
    (push c (constraints v1))
    (push c *constraints*)
    c))

(defmethod delete-object ((c constraint))
  (cond (*trace* (print (list 'delete-constraint))))
  (setq *constraints* (remove c *constraints*))
  (push c *free-constraints*)
  (setf (v1 c) nil
	(f c) nil
	(v2 c) nil)
  nil)

(defmethod look ((c constraint))
  (format nil "~A ~A ~A" (name (v1 c)) (f c) (name (v2 c))))

(defun show (i)
  (let ((c nil)
	(f nil))
    (loop for j from 1 to 30 do
	  (cond ((setq f (aref constraint i j))
		 (setq c (append c (list (list (aref name i) f (aref name j))))))))
    (list (aref name i)
	  (aref domain i)
	  (aref current-domain i)
	  c)))

(defun init ()
  (setq *n* 0
	checks 0
	nodes 0
	backtracks 0
	solutions 0
	consistent t
	P (list 0))
  (loop for var in *vars* do
	(setf *n* (+ 1 *n*)
	      (aref v *n*) nil
	      (aref name *n*) (name var)
	      (aref domain *n*) (domain var)
	      (aref current-domain *n*) (domain var)
	      (aref original-domain *n*) (domain var)
	      (aref max-check *n*) 0
	      (aref conf-set *n*) (list 0)
	      (aref mbl *n*) 0
	      (aref reductions *n*) nil
	      (aref past-fc *n*) (list 0)
	      (aref future-fc *n*) nil
	      (aref visited *n*) 0
	      (aref instantiated *n*) nil
	      (aref reason *n*) 0
	      (i var) *n*)
	(loop for j from 1 to 30 do
	      (setf (aref mcl *n* j) 0
		    (aref reasons *n* j) *n*
		    (aref culprit *n* j) 0
		    (aref nogood *n* j) nil
		    (aref constraint *n* j) nil)))
  (loop for c in *constraints* do
	(setf (aref constraint (i (v1 c)) (i (v2 c))) (f c)))
  (loop for i from 1 to 30 do
	(setf (aref parents i) nil
	      (aref adjacent i) (list 0)
	      (aref original-adjacent i) (list 0))
	(loop for h from 1 to (- i 1) do
	      (cond ((aref constraint i h)
		     (push h (aref adjacent i))
		     (push h (aref original-adjacent i))
		     (setf (aref parents i) (union (aref parents i) (aref parents h)))
		     (pushnew h (aref parents i)))))))

(defun reset ()
  (loop for i from 1 to *n* do
	(setf (aref domain i) (aref original-domain i)
	      (aref current-domain i) (aref domain i)
	      (aref v i) nil
	      (aref max-check i) 0
	      (aref conf-set i) (list 0)
	      (aref mbl i) 0
	      (aref reductions i) nil
	      (aref past-fc i) (list 0)
	      (aref visited i) 0
	      (aref instantiated i) nil
	      (aref future-fc i) nil
	      (aref reason i) 0
	      (aref adjacent i) (aref original-adjacent i))
	(loop for j from 1 to 30 do
	      (setf (aref mcl i j) 0
		    (aref reasons i j) i
		    (aref culprit i j) 0
		    (aref nogood i j) nil)))
  (setq checks 0
	nodes 0
	backtracks 0
	solutions 0
	consistent t
	P (list 0)))
