(in-package :user)

(defun fact (n)
  (cond ((= 0 n) 1)
	(t (* n (fact (- n 1))))))

(defun find-max (field data)
  (let ((m -999))
    (loop for datum in data do
	  (setq m (max m (nth field datum))))
    m))

(defun find-min (field data)
  (let ((m 9999999999))
    (loop for datum in data do
	  (setq m (min m (nth field datum))))
    m))

(defun average (field data)
  (let ((sum 0))
    (loop for datum in data do
	  (setq sum (+ sum (nth field datum))))
    (/ sum (* 1.0 (length data)))))

(defvar *w* nil)


(defun make-win (title x y)
  (make-instance 'lv:base-window
		 :label title
		 :bounding-region (make-region :width x
					       :height y)))
#|
(setq *w1* (make-win "w1" 530 353))
|#


(defun circle (w x y r)
  (lv:draw-arc w x y (* r 2) (* r 2) 0 360))


(defun point (w x y)
  (circle w x y 1))


(defun square (w x y size)
  (lv:draw-rectangle w x y size size))

(defvar *results* nil)

(defun plot (w title data f-x f-y
	       x-org y-org
	       x-min y-min
	       x-scale y-scale
	       y-clicks)
  (let ((x nil)
	(y nil)
	(x-point nil)
	(y-point nil)
	(br (lv:bounding-region w)))
    (setf (lv:label w) title)
    ;(lv:draw-line w 0 y-org (lv:region-width br) y-org)
    (loop for y-click in y-clicks do
	  (setq y-point (- y-org
			   (* y-scale
			      (- y-click y-min))))
	  (lv:draw-line w
			0
			y-point
			(lv:region-width br)
			y-point))
    (loop for datum in data do
	  (setq x (funcall f-x datum)
		y (funcall f-y datum)
		x-point (round (+ x-org (* x-scale (- x x-min))))
		y-point (- y-org (* y-scale (- y y-min))))
	  (square w x-point y-point 5))))
#|
(plot *w1*
   "FC, FC-BJ, FC-GBJ:   x = bandwidth,  y = log(checks)"
    bt
    'first #'(lambda (datum)
	       (round (* 20 (log (second datum)))))
    70 300 16 80 50 1
    (map 'list #'(lambda (x)
		   (round (* 20 (log (expt 10 x)))))
	 '(1 2 3 4 5 6 7 8)))
|#

(defun plot-hist (w title pairs
		    x-org y-org
		    x-min y-min
		    x-scale y-scale)
  (let ((x nil)
	(y nil)
	(x-point nil)
	(y-point nil)
	(br (lv:bounding-region w)))
    (setf (lv:label w) title)
    (lv:draw-line w 0 y-org (lv:region-width br) y-org)
    #|
    (lv:draw-line w 0 (- y-org (* 20 y-scale))
		    (lv:region-width br)
		    (- y-org (* 20 y-scale)))
    (lv:draw-line w 0 (- y-org (* 40 y-scale))
		    (lv:region-width br)
		    (- y-org (* 40 y-scale)))
    |#
    (loop for pair in pairs do
	  (setq x (first pair)
		x-point (+ x-org (* x-scale (- x x-min)))
		y (second pair)
		y-point (- y-org (* y-scale (- y y-min))))
	  ;(print (list x x-point y y-point))
	  (lv:draw-line w x-point
			y-org
			x-point
			y-point :line-width 5))))
#|
(plot-hist *w1* "BT: Frequency" bt-hist
	   0 300 5 0 20 4)
|#

(defun get-hist-data (data field lwb upb f)
  (let ((hist-data nil))
    (loop for i from lwb to upb do
	  (push (list i (count i data :key field
			       :test #'(lambda (x y)
					 (funcall f x y))))
		hist-data))
    hist-data))
#|
(setq bt-hist (get-hist-data bt 'second 1 40
			     #'(lambda (x y)
				 (= x (round (log y 2))))))
|#

(defun get-ogive-data (data field lwb upb f)
  (let ((hist-data nil)
	(sum 0)
	(freq 0))
    (loop for i from lwb to upb do
	  (setq sum 0
		freq (count i data :key field
			    :test #'(lambda (x y)
				      (funcall f x y))))
	  (setq sum (+ sum freq))
	  (push (list i sum) hist-data))
    hist-data))

(defun plot-line (w title pairs
		    x-org y-org
		    x-min y-min
		    x-scale y-scale
		    style)
  (let ((x nil)
	(y nil)
	(old-x nil)
	(old-y nil)
	(old-x-point nil)
	(old-y-point nil)
	(x-point nil)
	(y-point nil)
	(y-inc (/ (find-max 1 pairs) 10))
	(br (lv:bounding-region w)))
    (setf (lv:label w) title)
    (loop for i from 0 to 10 do
	  (setq y-point (- y-org
			   (* y-scale
			      (- (* i y-inc) y-min))))
	  (lv:draw-line w 0
			y-point
			(lv:region-width br)
			y-point))
    (setq old-x (first (first pairs))
		old-x-point (+ x-org (* x-scale (- old-x x-min)))
		old-y (second (first pairs))
		old-y-point (- y-org (* y-scale (- old-y y-min))))
    (loop for pair in (rest pairs) do
	  (setq x (first pair)
		x-point (+ x-org (* x-scale (- x x-min)))
		y (second pair)
		y-point (- y-org (* y-scale (- y y-min))))
	  ;(lv:draw-string w x-point y-point st-point)
	  (lv:draw-line w old-x-point
			  old-y-point
			  x-point
			  y-point
			 :line-width style)
	  (lv:draw-line w x-point
			  y-org
			  x-point
			  0
			 :line-width 1)
	  (setq old-x-point x-point
		old-y-point y-point))))
      
(defun compare-2 (f data-1 data-2)
  (let ((n (length data-1))
	(results nil))
    (loop for i from (- n 1) downto 0 do
	  (cond ((funcall f (nth i data-1)
			  (nth i data-2))
		 (push i results))))
    (reverse results)))

(defun sqr (n) (* n n))

(defun coeff-of-correlation (x-list y-list)
  (let ((x nil)
	(y nil)
	(sigma-xy 0)
	(sigma-x 0)
	(sigma-y 0)
	(sigma-x-squared 0)
	(sigma-y-squared 0)
	(n (length x-list))
	(s-x 0) (s-y 0) (s-xy 0))
    (loop for i from 0 to (- n 1) do
	  (setq x (nth i x-list)
		y (nth i y-list)
		sigma-xy (+ sigma-xy (* x y))
		sigma-x (+ sigma-x x)	
		sigma-y (+ sigma-y y)
		sigma-x-squared (+ sigma-x-squared (sqr x))
		sigma-y-squared (+ sigma-y-squared (sqr y))))
    (setq s-xy (- (/ sigma-xy n) (* (/ sigma-x n) (/ sigma-y n)))
	  s-x (sqrt (- (/ sigma-x-squared n) (sqr (/ sigma-x n))))
	  s-y (sqrt (- (/ sigma-y-squared n) (sqr (/ sigma-y n)))))
    (list 'a (/ (- (* n sigma-xy) (* sigma-x sigma-y))
		(- (* n sigma-x-squared) (sqr sigma-x)) 1.0)
	  #|
	  'r (/ (- (* n sigma-xy)
		   (* sigma-x sigma-y))
		(sqrt (* (- (* n sigma-x-squared)
			    (sqr sigma-x))
			 (- (* n sigma-y-squared)
			    (sqr sigma-y)))))
          |#
	  'r-xy (/ s-xy (* s-x s-y 1.0)))))
#|
(coeff-of-correlation
 (map 'list 'first gbj)
 (map 'list #'(lambda (datum)
		(log (third datum) 2)) gbj))
|#


(defun stats (data)
  (let ((n (length data))
	(x-square 0)
	(x-sum 0)
	(min-x 999999)
	(max-x -99999))
    (loop for x in data do
	  (setq x-square (+ x-square (sqr x))
		x-sum (+ x-sum x)
		min-x (min x min-x)
		max-x (max x max-x)))
    (list (/ x-sum n 1.0)
	  (sqrt (- (/ x-square n)
		   (sqr (/ x-sum n))))
	  min-x
	  max-x)))

(defun get-results (key test  results-file)
  (let ((f-in (open results-file :direction :input))
	(datum nil)
	(results nil))
    (setq datum (read f-in))
    (loop until (equal datum "end of data") do
	  (cond ((funcall test key datum)
		 (setq results (append results (list datum)))))
	  (setq datum (read f-in)))
    (close f-in)
    results))


(defun x-over-y (x y f)
  (map 'list #'(lambda (x y) (/ x y 1.0)) (map 'list f x) (map 'list f y)))

(defun x-times-y (x y)
  (let ((data nil))
    (loop for i from 0 to (- (length x) 1) do
	  (setq data (append data (list (* (nth i x) (nth i y))))))
    data))

(defun x-plus-y (x y)
  (let ((data nil))
    (loop for i from 0 to (- (length x) 1) do
	  (setq data (append data (list (+ (nth i x) (nth i y))))))
    data))

(defun x-min-y (x y)
  (let ((data nil))
    (loop for i from 0 to (- (length x) 1) do
	  (setq data (append data (list (min (nth i x) (nth i y))))))
    data))

(defun x-max-y (x y)
  (let ((data nil))
    (loop for i from 0 to (- (length x) 1) do
	  (setq data (append data (list (max (nth i x) (nth i y))))))
    data))

(defun student-t (x-data y-data)
  (let ((n (length x-data))
	(d 0) (sum-d 0) (sum-d*d 0) (sd 0) (sd-bar 0) (d-bar 0)
	(x 0) (y 0))
    (loop for i from 0 to (- n 1) do
	  (setq x (nth i x-data)
		y (nth i y-data)
		d (- x y)
		sum-d (+ sum-d d)
		sum-d*d (+ sum-d*d (* d d))))
    (setq sd (sqrt (/ (- sum-d*d (/ (sqr sum-d) n)) (- n 1)))
	  sd-bar (/ sd (sqrt n))
	  d-bar (/ sum-d n))
    (/ d-bar sd-bar)))
  

(defun rank (data)
  (let ((result nil)
	(count nil))
    (loop for i in data do
	  (setq count 0)
	  (loop for j in data do
		(cond ((< i j) (setq count (+ 1 count)))))
	  (setq result (append result (list count))))
    result))


(defun save-gnu-xy (data x-field y-field filename)
  (let ((fout (open filename :direction :output :if-exists :rename))
	(d nil))
    (loop for datum in data do
	  (setq d (format nil "~A ~A" (funcall x-field datum) (funcall y-field datum)))
	  (write-string d fout)
	  (terpri fout))
    (close fout)))
